/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.support.AbstractFilterScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.support.AbstractTieredFilterContainerMenu;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class AbstractAdvancedFilterScreen<T extends AbstractTieredFilterContainerMenu<?>>
extends AbstractFilterScreen<T> {
    private static final ResourceLocation ELITE_TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/elite_generic.png");
    private static final ResourceLocation ULTRA_TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/ultra_generic.png");
    private static final ResourceLocation MEGA_TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/mega_generic.png");
    private static final SmallTextClientTooltipComponent CLICK_TO_OPEN_ADVANCED_FILTER = new SmallTextClientTooltipComponent((Component)CableTiersIdentifierUtil.createCableTiersTranslationAsHeading("gui", "filter_slot.click_to_open_advanced_filter"));
    private static final SmallTextClientTooltipComponent SHIFT_CLICK_TO_CLEAR = new SmallTextClientTooltipComponent((Component)IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"filter_slot.shift_click_to_clear"));
    protected final CableTiers tier;

    protected AbstractAdvancedFilterScreen(T menu, Inventory playerInventory, Component title, CableTiers tier) {
        super(menu, playerInventory, title);
        this.tier = tier;
        switch (tier) {
            case ELITE: {
                this.inventoryLabelY = 60;
                this.imageHeight = 155;
                break;
            }
            case ULTRA: {
                this.inventoryLabelY = 96;
                this.imageHeight = 191;
                break;
            }
            case MEGA: 
            case CREATIVE: {
                this.inventoryLabelY = 132;
                this.imageHeight = 227;
            }
        }
        this.imageWidth = this.hasUpgrades() ? 210 : 176;
    }

    protected ResourceLocation getTexture() {
        return AbstractAdvancedFilterScreen.getTexture(this.tier);
    }

    public static ResourceLocation getTexture(CableTiers tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case CableTiers.ELITE -> ELITE_TEXTURE;
            case CableTiers.ULTRA -> ULTRA_TEXTURE;
            case CableTiers.MEGA, CableTiers.CREATIVE -> MEGA_TEXTURE;
        };
    }

    protected void addResourceSlotTooltips(ResourceSlot slot, List<ClientTooltipComponent> tooltip) {
        ResourceTag resourceTag;
        if (((AbstractTieredFilterContainerMenu)this.getMenu()).getTagKeys() != null && (resourceTag = ((AbstractTieredFilterContainerMenu)this.getMenu()).getTagKeys().get(slot.index)) != null) {
            tooltip.add((ClientTooltipComponent)new SmallTextClientTooltipComponent((Component)Component.translatable((String)"gui.cabletiers.advanced_filter.tag_filter").append(": ").append((Component)Component.literal((String)resourceTag.key().location().toString())).withStyle(ChatFormatting.GOLD)));
        }
        tooltip.add((ClientTooltipComponent)CLICK_TO_OPEN_ADVANCED_FILTER);
        tooltip.add((ClientTooltipComponent)SHIFT_CLICK_TO_CLEAR);
    }

    public static boolean renderTieredExportingIndicators(GuiGraphics graphics, int leftPos, int topPos, int mouseX, int mouseY, int indicators, IntFunction<ExportingIndicator> indicatorProvider) {
        for (int i = 0; i < indicators; ++i) {
            boolean hovering;
            ExportingIndicator indicator = indicatorProvider.apply(i);
            int xx = leftPos + 7 + 18 * (i % 9) + 18 - 10 + 1;
            int yy = topPos + 19 + 18 + 18 * (i / 9) - 10 + 1;
            ResourceLocation sprite = indicator.getSprite();
            if (sprite != null) {
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 300.0f);
                graphics.blitSprite(sprite, xx, yy, 10, 10);
                graphics.pose().popPose();
            }
            boolean bl = hovering = mouseX >= xx && mouseX <= xx + 10 && mouseY >= yy && mouseY <= yy + 10;
            if (indicator == ExportingIndicator.NONE || !hovering) continue;
            Platform.INSTANCE.renderTooltip(graphics, List.of(ClientTooltipComponent.create((FormattedCharSequence)indicator.getTooltip().getVisualOrderText())), mouseX, mouseY);
            return true;
        }
        return false;
    }
}

