/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.datagen.tag;

import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterBlock;
import com.ultramega.cabletiers.common.constructordestructor.TieredConstructorBlock;
import com.ultramega.cabletiers.common.constructordestructor.TieredDestructorBlock;
import com.ultramega.cabletiers.common.exporter.TieredExporterBlock;
import com.ultramega.cabletiers.common.importer.TieredImporterBlock;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceBlock;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemTagsProviderImpl
extends ItemTagsProvider {
    public ItemTagsProviderImpl(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, TagsProvider<Block> blockTagsProvider, ExistingFileHelper existingFileHelper) {
        super(packOutput, registries, blockTagsProvider.contentsGetter(), "cabletiers", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (CableTiers tier : CableTiers.values()) {
            this.addAllToTag(tier.getItemTag(CableType.IMPORTER), Blocks.INSTANCE.getTieredImporters(tier).values().stream().map(block -> () -> ((TieredImporterBlock)((Object)block)).asItem()).toList());
            this.addAllToTag(tier.getItemTag(CableType.EXPORTER), Blocks.INSTANCE.getTieredExporters(tier).values().stream().map(block -> () -> ((TieredExporterBlock)((Object)block)).asItem()).toList());
            this.addAllToTag(tier.getItemTag(CableType.DESTRUCTOR), Blocks.INSTANCE.getTieredDestructors(tier).values().stream().map(block -> () -> ((TieredDestructorBlock)((Object)block)).asItem()).toList());
            this.addAllToTag(tier.getItemTag(CableType.CONSTRUCTOR), Blocks.INSTANCE.getTieredConstructors(tier).values().stream().map(block -> () -> ((TieredConstructorBlock)((Object)block)).asItem()).toList());
            this.addAllToTag(tier.getItemTag(CableType.DISK_INTERFACE), Blocks.INSTANCE.getTieredDiskInterfaces(tier).values().stream().map(block -> () -> ((TieredDiskInterfaceBlock)((Object)block)).asItem()).toList());
            this.addAllToTag(tier.getItemTag(CableType.AUTOCRAFTER), Blocks.INSTANCE.getTieredAutocrafters(tier).values().stream().map(block -> () -> ((TieredAutocrafterBlock)((Object)block)).asItem()).toList());
        }
    }

    private <T extends Item> void addAllToTag(TagKey<Item> t, Collection<Supplier<T>> items) {
        this.tag(t).add((Object[])((Item[])items.stream().map(Supplier::get).toArray(Item[]::new))).replace(false);
    }
}

