/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.iface;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceTransferResult;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.iface.InterfaceData;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.iface.ExportedResourcesContainer;
import com.ultramega.cabletiers.common.iface.TieredInterfaceContainerMenu;
import com.ultramega.cabletiers.common.iface.TieredInterfaceNetworkNode;
import com.ultramega.cabletiers.common.iface.externalstorage.TieredInterfaceExternalStorageProvider;
import com.ultramega.cabletiers.common.iface.externalstorage.TieredInterfaceExternalStorageProviderImpl;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.utils.ContentNames;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public class TieredInterfaceBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<TieredInterfaceNetworkNode>
implements NetworkNodeExtendedMenuProvider<InterfaceData>,
BlockEntityWithDrops {
    private static final String TAG_EXPORT_ITEMS = "ei";
    private static final String TAG_UPGRADES = "upgr";
    private final UpgradeContainer upgradeContainer;
    private final FilterWithFuzzyMode filter;
    private final ExportedResourcesContainer exportedResources;
    private final class_1263 exportedResourcesAsContainer;
    private final TieredInterfaceExternalStorageProvider externalStorageProvider;
    private final CableTiers tier;

    public TieredInterfaceBlockEntity(CableTiers tier, class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getTieredInterfaces(tier), pos, state, (AbstractNetworkNode)new TieredInterfaceNetworkNode(tier.getEnergyUsage(CableType.INTERFACE)));
        this.tier = tier;
        ((TieredInterfaceNetworkNode)this.mainNetworkNode).setTransferQuotaProvider(resource -> TieredInterfaceBlockEntity.getTransferQuota(tier, resource));
        this.upgradeContainer = new UpgradeContainer(1, (UpgradeDestination)UpgradeDestinations.INTERFACE, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = tier.getEnergyUsage(CableType.INTERFACE);
            ((TieredInterfaceNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
            boolean autocrafting = c.has((UpgradeItem)Items.INSTANCE.getAutocraftingUpgrade());
            ((TieredInterfaceNetworkNode)this.mainNetworkNode).setOnMissingResources((InterfaceNetworkNode.OnMissingResources)(autocrafting ? new InterfaceNetworkNode.AutocraftOnMissingResources() : InterfaceNetworkNode.OnMissingResources.EMPTY));
            this.method_5431();
        });
        this.filter = FilterWithFuzzyMode.create((ResourceContainer)TieredInterfaceBlockEntity.createFilterContainer(tier), () -> ((TieredInterfaceBlockEntity)this).method_5431());
        this.exportedResources = TieredInterfaceBlockEntity.createExportedResourcesContainer(tier, this.filter);
        this.exportedResources.setListener(() -> ((TieredInterfaceBlockEntity)this).method_5431());
        ((TieredInterfaceNetworkNode)this.mainNetworkNode).setExportState(this.exportedResources);
        this.exportedResourcesAsContainer = this.exportedResources.toItemContainer();
        this.externalStorageProvider = new TieredInterfaceExternalStorageProviderImpl((TieredInterfaceNetworkNode)this.mainNetworkNode);
    }

    static ResourceContainer createFilterContainer(CableTiers tier) {
        return new ResourceContainerImpl(tier.getInterfaceSlotsCount(), resource -> TieredInterfaceBlockEntity.getTransferQuota(tier, resource), RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    static ResourceContainer createFilterContainer(CableTiers tier, InterfaceData interfaceData) {
        ResourceContainer filterContainer = TieredInterfaceBlockEntity.createFilterContainer(tier);
        ResourceContainerData resourceContainerData = interfaceData.filterContainerData();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            ((Optional)resourceContainerData.resources().get(i)).ifPresent(resource -> filterContainer.set(ii, resource));
        }
        return filterContainer;
    }

    static ExportedResourcesContainer createExportedResourcesContainer(CableTiers tier, FilterWithFuzzyMode filter) {
        return new ExportedResourcesContainer(tier, tier.getInterfaceSlotsCount(), filter);
    }

    static ResourceContainer createExportedResourcesContainer(CableTiers tier, InterfaceData interfaceData, FilterWithFuzzyMode filter) {
        ExportedResourcesContainer exportedResourcesContainer = TieredInterfaceBlockEntity.createExportedResourcesContainer(tier, filter);
        ResourceContainerData resourceContainerData = interfaceData.exportedResourcesContainerData();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            ((Optional)resourceContainerData.resources().get(i)).ifPresent(resource -> exportedResourcesContainer.set(ii, (ResourceAmount)resource));
        }
        return exportedResourcesContainer;
    }

    static long getTransferQuota(CableTiers tier, ResourceKey resource) {
        if (resource instanceof PlatformResourceKey) {
            PlatformResourceKey platformResource = (PlatformResourceKey)resource;
            long transferQuotaMultiplier = tier.getTransferQuotaMultiplier(CableType.INTERFACE);
            if (transferQuotaMultiplier == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return platformResource.getInterfaceExportLimit() * transferQuotaMultiplier;
        }
        return 0L;
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_EXPORT_ITEMS, (class_2520)this.exportedResources.toTag(provider));
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, (class_7225.class_7874)provider));
    }

    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_EXPORT_ITEMS)) {
            this.exportedResources.fromTag(tag.method_10562(TAG_EXPORT_ITEMS), provider);
        }
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read((class_2487)tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, (class_7225.class_7874)provider);
        }
        super.method_11014(tag, provider);
    }

    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    void clearFilters() {
        this.filter.getFilterContainer().clear();
    }

    void setFilters(List<ResourceAmount> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            this.filter.getFilterContainer().set(i, filters.get(i));
        }
    }

    public ExportedResourcesContainer getExportedResources() {
        return this.exportedResources;
    }

    public class_1263 getExportedResourcesAsContainer() {
        return this.exportedResourcesAsContainer;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new TieredInterfaceContainerMenu(syncId, player, this, this.filter.getFilterContainer(), (ResourceContainer)this.exportedResources, this.exportedResourcesAsContainer, this.upgradeContainer, this.getExportingIndicators(), this.tier);
    }

    private ExportingIndicators getExportingIndicators() {
        return new ExportingIndicators(this.filter.getFilterContainer(), i -> this.toExportingIndicator(((TieredInterfaceNetworkNode)this.mainNetworkNode).getLastResult(i)), true);
    }

    private ExportingIndicator toExportingIndicator(@Nullable InterfaceTransferResult result) {
        InterfaceTransferResult interfaceTransferResult = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"STORAGE_DOES_NOT_ACCEPT_RESOURCE", "RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (InterfaceTransferResult)interfaceTransferResult, n)) {
            case 0 -> ExportingIndicator.DESTINATION_DOES_NOT_ACCEPT_RESOURCE;
            case 1 -> ExportingIndicator.RESOURCE_MISSING;
            case 2 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 3 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }

    public InterfaceData getMenuData() {
        return new InterfaceData(ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer()), ResourceContainerData.of((ResourceContainer)this.exportedResources), this.getExportingIndicators().getAll());
    }

    public class_9142<class_9129, InterfaceData> getMenuCodec() {
        return InterfaceData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.getContentName(this.tier, CableType.INTERFACE));
    }

    public final class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < this.exportedResourcesAsContainer.method_5439(); ++i) {
            drops.add((Object)this.exportedResourcesAsContainer.method_5438(i));
        }
        drops.addAll((Collection)this.upgradeContainer.getDrops());
        return drops;
    }

    TieredInterfaceExternalStorageProvider getExternalStorageProvider() {
        return this.externalStorageProvider;
    }

    TieredInterfaceNetworkNode getInterface() {
        return (TieredInterfaceNetworkNode)this.mainNetworkNode;
    }
}

