/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.advancedfilter;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.FuzzyModeNormalizer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceContainerImpl;
import com.ultramega.cabletiers.common.packet.s2c.UpdateAdvancedFilterPacket;
import com.ultramega.cabletiers.common.utils.TagsCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_8710;

public final class TagFilterWithFuzzyMode {
    private static final String TAG_FUZZY_MODE = "fm";
    private static final String TAG_RESOURCE_FILTER = "rf";
    private static final int ANIMATION_COOLDOWN = 20;
    private final AdvancedResourceContainerImpl filterContainer;
    @Nullable
    private final Runnable listener;
    @Nullable
    private final BiConsumer<Set<ResourceKey>, Set<class_6862<?>>> uniqueFilterListener;
    @Nullable
    private final BiConsumer<List<ResourceKey>, List<ResourceTag>> filterListener;
    private int animationTick;
    private boolean fuzzyMode;

    private TagFilterWithFuzzyMode(AdvancedResourceContainerImpl filterContainer, @Nullable Runnable listener, @Nullable BiConsumer<Set<ResourceKey>, Set<class_6862<?>>> uniqueFilterListener, @Nullable BiConsumer<List<ResourceKey>, List<ResourceTag>> filterListener) {
        this.filterContainer = filterContainer;
        this.listener = listener;
        this.uniqueFilterListener = uniqueFilterListener;
        this.filterListener = filterListener;
        this.filterContainer.setListener(index -> this.filterContainerChanged((Integer)index, true));
    }

    public void doWork() {
        if (++this.animationTick > 20) {
            this.animationTick = 0;
            for (int i = 0; i < this.filterContainer.getFilterTagsWithNull().size(); ++i) {
                this.updateShowcasedItem(i);
            }
        }
    }

    private void updateShowcasedItem(int index) {
        class_6862<?> filterTagKey = this.filterContainer.getFilterTag(index);
        if (filterTagKey == null) {
            return;
        }
        ResourceAmount resourceAmount = this.filterContainer.get(index);
        if (resourceAmount == null) {
            return;
        }
        ResourceKey resourceKey = resourceAmount.resource();
        if (resourceKey instanceof PlatformResourceKey) {
            PlatformResourceKey platformResourceKey = (PlatformResourceKey)resourceKey;
            for (ResourceTag tag : TagsCache.get(platformResourceKey)) {
                if (!tag.key().equals(filterTagKey)) continue;
                this.filterContainer.updateFakeSlot(index, tag);
            }
        }
    }

    private void filterContainerChanged(Integer index, boolean overwriteFilterTag) {
        this.filterContainer.setFakeShowcaseIndex(index, -1);
        this.filterContainer.setFake(index, null);
        if (overwriteFilterTag) {
            this.filterContainer.setFilterTag(index, null);
        }
        this.notifyListeners();
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public AdvancedResourceContainerImpl getFilterContainer() {
        return this.filterContainer;
    }

    public void resetFakeFilters() {
        this.filterContainer.resetFakeFilters();
    }

    public void sendFilterTagsToClient(class_3222 player) {
        ArrayList<Optional<ResourceTag>> optionalTags = new ArrayList<Optional<ResourceTag>>();
        for (ResourceTag resourceTag : this.filterContainer.getFilterTagsWithNull()) {
            optionalTags.add(Optional.ofNullable(resourceTag));
        }
        Platform.INSTANCE.sendPacketToClient(player, (class_8710)new UpdateAdvancedFilterPacket(optionalTags));
    }

    public void setFilterTag(int index, @Nullable ResourceTag resourceTag) {
        this.filterContainer.setFilterTag(index, resourceTag);
        if (resourceTag != null) {
            PlatformResourceKey resourceInContainer = this.filterContainer.getResource(index);
            for (int i = 0; i < resourceTag.resources().size(); ++i) {
                ResourceKey resource = (ResourceKey)resourceTag.resources().get(i);
                if (!resource.equals((Object)resourceInContainer)) continue;
                this.filterContainer.setFakeStartIndex(index, i);
            }
        }
        this.filterContainerChanged(index, false);
    }

    public boolean isFuzzyMode() {
        return this.fuzzyMode;
    }

    public void setFuzzyMode(boolean fuzzyMode) {
        this.fuzzyMode = fuzzyMode;
        this.notifyListeners();
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public void load(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_RESOURCE_FILTER)) {
            this.filterContainer.fromTag(tag.method_10562(TAG_RESOURCE_FILTER), provider);
        }
        if (tag.method_10545(TAG_FUZZY_MODE)) {
            this.fuzzyMode = tag.method_10577(TAG_FUZZY_MODE);
        }
        this.notifyListeners();
    }

    public void save(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10556(TAG_FUZZY_MODE, this.fuzzyMode);
        tag.method_10566(TAG_RESOURCE_FILTER, (class_2520)this.filterContainer.toTag(provider));
    }

    private void notifyListeners() {
        if (this.uniqueFilterListener != null) {
            this.uniqueFilterListener.accept(this.filterContainer.getUniqueResources(), this.filterContainer.getUniqueFilterTags());
        }
        if (this.filterListener != null) {
            this.filterListener.accept(this.filterContainer.getResources(), this.filterContainer.getFilterTags());
        }
    }

    public static List<ResourceKey> getResourcesFromFilter(List<ResourceKey> filters, List<ResourceTag> tagFilters, int index) {
        ResourceKey filter = filters.get(index);
        ResourceTag tagFilter = tagFilters.size() > index ? tagFilters.get(index) : null;
        ArrayList<ResourceKey> resources = new ArrayList<ResourceKey>();
        if (tagFilter != null && !tagFilter.resources().isEmpty()) {
            resources.addAll(tagFilter.resources());
        } else {
            resources.add(filter);
        }
        return resources;
    }

    public UnaryOperator<ResourceKey> createNormalizer() {
        return value -> {
            if (!this.fuzzyMode) {
                return value;
            }
            if (value instanceof FuzzyModeNormalizer) {
                FuzzyModeNormalizer normalizer = (FuzzyModeNormalizer)value;
                return normalizer.normalize();
            }
            return value;
        };
    }

    public static TagFilterWithFuzzyMode create(AdvancedResourceContainerImpl resourceContainer, @Nullable Runnable listener) {
        return new TagFilterWithFuzzyMode(resourceContainer, listener, null, null);
    }

    public static TagFilterWithFuzzyMode createAndListenForFilters(AdvancedResourceContainerImpl resourceContainer, Runnable listener, BiConsumer<List<ResourceKey>, List<ResourceTag>> filterListener) {
        return new TagFilterWithFuzzyMode(resourceContainer, listener, null, filterListener);
    }

    public static TagFilterWithFuzzyMode createAndListenForUniqueFilters(AdvancedResourceContainerImpl resourceContainer, Runnable listener, BiConsumer<Set<ResourceKey>, Set<class_6862<?>>> filterListener) {
        return new TagFilterWithFuzzyMode(resourceContainer, listener, filterListener, null);
    }
}

