/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.importer;

import com.refinedmods.refinedstorage.api.network.impl.node.importer.CompositeImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.TieredUpgradeDestinations;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceContainerImpl;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.importer.TieredImporterContainerMenu;
import com.ultramega.cabletiers.common.importer.TieredImporterNetworkNode;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.support.AbstractTieredCableLikeBlockEntity;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTieredImporterBlockEntity
extends AbstractTieredCableLikeBlockEntity<TieredImporterNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTieredImporterBlockEntity.class);

    protected AbstractTieredImporterBlockEntity(final CableTiers tier, class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getTieredImporters(tier), pos, state, new TieredImporterNetworkNode(tier.getEnergyUsage(CableType.IMPORTER)), tier, CableType.IMPORTER);
        this.filter = TagFilterWithFuzzyMode.createAndListenForUniqueFilters(AdvancedResourceContainerImpl.createForFilter(tier), this::method_5431, this::setFilters);
        ((TieredImporterNetworkNode)this.mainNetworkNode).setNormalizer(this.filter.createNormalizer());
        this.upgradeContainer = new UpgradeContainer(this, AbstractTieredImporterBlockEntity.getUpgradeDestination(tier), (c, upgradeEnergyUsage) -> {
            ((TieredImporterNetworkNode)this.mainNetworkNode).setEnergyUsage(tier.getEnergyUsage(CableType.IMPORTER) + upgradeEnergyUsage);
            this.method_5431();
            class_1937 patt0$temp = this.field_11863;
            if (patt0$temp instanceof class_3218) {
                class_3218 serverLevel = (class_3218)patt0$temp;
                this.initialize(serverLevel);
            }
        }){

            public boolean has(UpgradeItem upgradeItem) {
                if (tier.hasIntegratedStackUpgrade(CableType.IMPORTER) && upgradeItem == Items.INSTANCE.getStackUpgrade()) {
                    return true;
                }
                return super.has(upgradeItem);
            }

            public int getAmount(UpgradeItem upgradeItem) {
                if (tier == CableTiers.CREATIVE && upgradeItem == Items.INSTANCE.getSpeedUpgrade()) {
                    return 4;
                }
                return super.getAmount(upgradeItem);
            }
        };
        this.ticker = this.upgradeContainer.getTicker();
    }

    public static UpgradeDestination getUpgradeDestination(CableTiers tier) {
        return tier == CableTiers.CREATIVE ? TieredUpgradeDestinations.IMPORTER_NO_STACK_SPEED : (tier.hasIntegratedStackUpgrade(CableType.IMPORTER) ? TieredUpgradeDestinations.IMPORTER_NO_STACK : UpgradeDestinations.IMPORTER);
    }

    void setFilters(Set<ResourceKey> filters, Set<class_6862<?>> tagFilters) {
        ((TieredImporterNetworkNode)this.mainNetworkNode).setFilters(filters, tagFilters);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    FilterMode getFilterMode() {
        return ((TieredImporterNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    void setFilterMode(FilterMode mode) {
        ((TieredImporterNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.method_5431();
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        tag.method_10569("fim", FilterModeSettings.getFilterMode((FilterMode)((TieredImporterNetworkNode)this.mainNetworkNode).getFilterMode()));
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        if (tag.method_10545("fim")) {
            ((TieredImporterNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode((int)tag.method_10550("fim")));
        }
    }

    protected void initialize(class_3218 level, class_2350 direction) {
        super.initialize(level, direction);
        ImporterTransferStrategy strategy = AbstractTieredImporterBlockEntity.createStrategy(level, direction, this.field_11867, this.upgradeContainer);
        LOGGER.debug("Initialized importer at {} with strategy {}", (Object)this.field_11867, (Object)strategy);
        ((TieredImporterNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    public static ImporterTransferStrategy createStrategy(class_3218 serverLevel, class_2350 direction, class_2338 worldPosition, UpgradeContainer upgradeContainer) {
        class_2350 incomingDirection = direction.method_10153();
        class_2338 sourcePosition = worldPosition.method_10093(direction);
        List factories = RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().getAll();
        return new CompositeImporterTransferStrategy(factories.stream().map(factory -> factory.create(serverLevel, sourcePosition, incomingDirection, (UpgradeState)upgradeContainer)).toList());
    }

    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer());
    }

    public class_9142<class_9129, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)this.tier.getContentName(CableType.IMPORTER));
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        this.setInContainerMenu(true);
        return new TieredImporterContainerMenu(syncId, player, this, (ResourceContainer)this.filter.getFilterContainer(), this.upgradeContainer, this.tier);
    }
}

