/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.fabric;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.content.BlockEntityProvider;
import com.refinedmods.refinedstorage.common.content.BlockEntityTypeFactory;
import com.refinedmods.refinedstorage.common.content.DirectRegistryCallback;
import com.refinedmods.refinedstorage.common.content.ExtendedMenuTypeFactory;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import com.refinedmods.refinedstorage.common.support.packet.PacketHandler;
import com.refinedmods.refinedstorage.fabric.api.RefinedStorageFabricApi;
import com.refinedmods.refinedstorage.fabric.api.RefinedStoragePlugin;
import com.ultramega.cabletiers.common.AbstractModInitializer;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.Platform;
import com.ultramega.cabletiers.common.packet.c2s.ChangeAdvancedResourceSlotPacket;
import com.ultramega.cabletiers.common.packet.c2s.RequestSidedResourcesPacket;
import com.ultramega.cabletiers.common.packet.c2s.SetAdvancedFilterPacket;
import com.ultramega.cabletiers.common.packet.c2s.SetSidedResourcesOnPatternGridBlockPacket;
import com.ultramega.cabletiers.common.packet.c2s.TieredAutocrafterNameChangePacket;
import com.ultramega.cabletiers.common.packet.s2c.ReplaceSidedResourceOnPatternGridMenuPacket;
import com.ultramega.cabletiers.common.packet.s2c.SetSidedResourcesOnPatternGridMenuPacket;
import com.ultramega.cabletiers.common.packet.s2c.ShouldOpenAdvancedFilterPacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterLockedUpdatePacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterNameUpdatePacket;
import com.ultramega.cabletiers.common.packet.s2c.UpdateAdvancedFilterPacket;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.registry.CreativeModeTabItems;
import com.ultramega.cabletiers.common.utils.BlockEntityProviders;
import com.ultramega.cabletiers.common.utils.BlockEntityTierProvider;
import com.ultramega.cabletiers.common.utils.BlockEntityTierTypeFactory;
import com.ultramega.cabletiers.fabric.ConfigImpl;
import com.ultramega.cabletiers.fabric.constructordestructor.FabricTieredConstructorBlockEntity;
import com.ultramega.cabletiers.fabric.constructordestructor.FabricTieredDestructorBlockEntity;
import com.ultramega.cabletiers.fabric.exporter.FabricTieredExporterBlockEntity;
import com.ultramega.cabletiers.fabric.importer.FabricTieredImporterBlockEntity;
import com.ultramega.cabletiers.fabric.storage.diskinterface.FabricTieredDiskInterfaceBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public class ModInitializerImpl
extends AbstractModInitializer
implements RefinedStoragePlugin,
ModInitializer {
    private static final BlockEntityProviders BLOCK_ENTITY_PROVIDERS = new BlockEntityProviders(FabricTieredImporterBlockEntity::new, FabricTieredExporterBlockEntity::new, FabricTieredDestructorBlockEntity::new, FabricTieredConstructorBlockEntity::new, FabricTieredDiskInterfaceBlockEntity::new);

    public void onApiAvailable(RefinedStorageApi refinedStorageApi) {
        Platform.setConfigProvider(ConfigImpl::get);
        this.registerContent();
        this.registerPackets();
        this.registerPacketHandlers();
        this.registerCapabilities();
        this.registerCreativeModeTabListener(refinedStorageApi);
    }

    private void registerContent() {
        this.registerBlocks((RegistryCallback<class_2248>)new DirectRegistryCallback((class_2378)class_7923.field_41175), BLOCK_ENTITY_PROVIDERS);
        this.registerItems((RegistryCallback<class_1792>)new DirectRegistryCallback((class_2378)class_7923.field_41178));
        this.registerUpgradeMappings();
        this.registerBlockEntities((RegistryCallback<class_2591<?>>)new DirectRegistryCallback(class_7923.field_41181), new BlockEntityTierTypeFactory(this){

            @Override
            public <T extends class_2586> class_2591<T> create(CableTiers tier, BlockEntityTierProvider<T> factory, class_2248 ... allowedBlocks) {
                return new class_2591((pos, state) -> factory.create(tier, pos, state), new HashSet<class_2248>(Arrays.asList(allowedBlocks)), null);
            }
        }, new BlockEntityTypeFactory(this){

            public <T extends class_2586> class_2591<T> create(BlockEntityProvider<T> factory, class_2248 ... allowedBlocks) {
                return new class_2591((arg_0, arg_1) -> factory.create(arg_0, arg_1), new HashSet<class_2248>(Arrays.asList(allowedBlocks)), null);
            }
        }, BLOCK_ENTITY_PROVIDERS);
        this.registerMenus((RegistryCallback<class_3917<?>>)new DirectRegistryCallback(class_7923.field_41187), new ExtendedMenuTypeFactory(this){

            public <T extends class_1703, D> class_3917<T> create(ExtendedMenuTypeFactory.MenuSupplier<T, D> supplier, class_9139<class_9129, D> streamCodec) {
                return new ExtendedScreenHandlerType((arg_0, arg_1, arg_2) -> supplier.create(arg_0, arg_1, arg_2), streamCodec);
            }
        });
        this.registerDataComponents((RegistryCallback<class_9331<?>>)new DirectRegistryCallback(class_7923.field_49658));
    }

    private void registerCapabilities() {
        for (CableTiers tier : CableTiers.values()) {
            this.registerNetworkNodeContainerProvider(BlockEntities.INSTANCE.getTieredImporters(tier));
            this.registerNetworkNodeContainerProvider(BlockEntities.INSTANCE.getTieredExporters(tier));
            this.registerNetworkNodeContainerProvider(BlockEntities.INSTANCE.getTieredDestructors(tier));
            this.registerNetworkNodeContainerProvider(BlockEntities.INSTANCE.getTieredConstructors(tier));
            this.registerNetworkNodeContainerProvider(BlockEntities.INSTANCE.getTieredDiskInterfaces(tier));
            this.registerNetworkNodeContainerProvider(BlockEntities.INSTANCE.getTieredAutocrafters(tier));
            ItemStorage.SIDED.registerForBlockEntity((blockEntity, context) -> {
                InventoryStorage storage = InventoryStorage.of((class_1263)blockEntity.getDiskInventory(), (class_2350)context);
                ArrayList<Storage> parts = new ArrayList<Storage>();
                for (int i = 0; i < 6; ++i) {
                    SingleSlotStorage slot = storage.getSlot(i);
                    parts.add(i < 3 ? FilteringStorage.insertOnlyOf((Storage)slot) : FilteringStorage.extractOnlyOf((Storage)slot));
                }
                return new CombinedStorage(parts);
            }, BlockEntities.INSTANCE.getTieredDiskInterfaces(tier));
        }
    }

    private void registerNetworkNodeContainerProvider(class_2591<? extends AbstractNetworkNodeContainerBlockEntity<?>> type) {
        RefinedStorageFabricApi.INSTANCE.getNetworkNodeContainerProviderLookup().registerForBlockEntity((be, dir) -> be.getContainerProvider(), type);
    }

    private void registerCreativeModeTabListener(RefinedStorageApi refinedStorageApi) {
        class_5321 creativeModeTab = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)refinedStorageApi.getCreativeModeTabId());
        ItemGroupEvents.modifyEntriesEvent((class_5321)creativeModeTab).register(entries -> CreativeModeTabItems.appendBlocks(arg_0 -> ((FabricItemGroupEntries)entries).method_45420(arg_0)));
        class_5321 coloredCreativeModeTab = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)refinedStorageApi.getColoredCreativeModeTabId());
        ItemGroupEvents.modifyEntriesEvent((class_5321)coloredCreativeModeTab).register(entries -> CreativeModeTabItems.appendColoredVariants(arg_0 -> ((FabricItemGroupEntries)entries).method_45420(arg_0)));
    }

    private void registerPackets() {
        this.registerServerToClientPackets();
        this.registerClientToServerPackets();
    }

    private void registerServerToClientPackets() {
        PayloadTypeRegistry.playS2C().register(ShouldOpenAdvancedFilterPacket.PACKET_TYPE, ShouldOpenAdvancedFilterPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(UpdateAdvancedFilterPacket.PACKET_TYPE, UpdateAdvancedFilterPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(TieredAutocrafterLockedUpdatePacket.PACKET_TYPE, TieredAutocrafterLockedUpdatePacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(TieredAutocrafterNameUpdatePacket.PACKET_TYPE, TieredAutocrafterNameUpdatePacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(SetSidedResourcesOnPatternGridMenuPacket.PACKET_TYPE, SetSidedResourcesOnPatternGridMenuPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(ReplaceSidedResourceOnPatternGridMenuPacket.PACKET_TYPE, ReplaceSidedResourceOnPatternGridMenuPacket.STREAM_CODEC);
    }

    private void registerClientToServerPackets() {
        PayloadTypeRegistry.playC2S().register(ChangeAdvancedResourceSlotPacket.PACKET_TYPE, ChangeAdvancedResourceSlotPacket.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(SetAdvancedFilterPacket.PACKET_TYPE, SetAdvancedFilterPacket.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(TieredAutocrafterNameChangePacket.PACKET_TYPE, TieredAutocrafterNameChangePacket.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(RequestSidedResourcesPacket.PACKET_TYPE, RequestSidedResourcesPacket.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(SetSidedResourcesOnPatternGridBlockPacket.PACKET_TYPE, SetSidedResourcesOnPatternGridBlockPacket.STREAM_CODEC);
    }

    private void registerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(ChangeAdvancedResourceSlotPacket.PACKET_TYPE, ModInitializerImpl.wrapHandler(ChangeAdvancedResourceSlotPacket::handle));
        ServerPlayNetworking.registerGlobalReceiver(SetAdvancedFilterPacket.PACKET_TYPE, ModInitializerImpl.wrapHandler(SetAdvancedFilterPacket::handle));
        ServerPlayNetworking.registerGlobalReceiver(TieredAutocrafterNameChangePacket.PACKET_TYPE, ModInitializerImpl.wrapHandler(TieredAutocrafterNameChangePacket::handle));
        ServerPlayNetworking.registerGlobalReceiver(RequestSidedResourcesPacket.PACKET_TYPE, ModInitializerImpl.wrapHandler(RequestSidedResourcesPacket::handle));
        ServerPlayNetworking.registerGlobalReceiver(SetSidedResourcesOnPatternGridBlockPacket.PACKET_TYPE, ModInitializerImpl.wrapHandler(SetSidedResourcesOnPatternGridBlockPacket::handle));
    }

    private static <T extends class_8710> ServerPlayNetworking.PlayPayloadHandler<T> wrapHandler(PacketHandler<T> handler) {
        return (packet, ctx) -> handler.handle((Object)packet, () -> ((ServerPlayNetworking.Context)ctx).player());
    }

    public void onInitialize() {
        AutoConfig.register(ConfigImpl.class, Toml4jConfigSerializer::new);
    }
}

