/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.advancedfilter;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_6862;

public class AdvancedFilter
extends Filter {
    private final Set<ResourceKey> itemFilters = new HashSet<ResourceKey>();
    private final Set<class_6862<?>> tagFilters = new HashSet();
    private FilterMode mode = FilterMode.BLOCK;
    private UnaryOperator<ResourceKey> normalizer = value -> value;

    public FilterMode getMode() {
        return this.mode;
    }

    public void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        this.normalizer = normalizer;
    }

    public void setMode(FilterMode mode) {
        this.mode = mode;
    }

    public boolean isAllowed(ResourceKey resource) {
        ResourceKey normalized = (ResourceKey)this.normalizer.apply(resource);
        if (normalized instanceof PlatformResourceKey) {
            PlatformResourceKey platformResourceKey = (PlatformResourceKey)normalized;
            boolean foundTag = false;
            List tags = platformResourceKey.getTags();
            for (ResourceTag tag : tags) {
                if (!this.tagFilters.contains(tag.key())) continue;
                foundTag = true;
                break;
            }
            boolean isAllowed = !foundTag && !this.itemFilters.contains(normalized);
            return switch (this.mode) {
                default -> throw new MatchException(null, null);
                case FilterMode.ALLOW -> {
                    if (!isAllowed) {
                        yield true;
                    }
                    yield false;
                }
                case FilterMode.BLOCK -> isAllowed;
            };
        }
        return false;
    }

    public void setFilters(Set<ResourceKey> filters) {
        this.itemFilters.clear();
        this.itemFilters.addAll(filters.stream().map(this.normalizer).collect(Collectors.toSet()));
    }

    public void setTagFilters(Set<class_6862<?>> tagFilters) {
        this.tagFilters.clear();
        this.tagFilters.addAll(new HashSet(tagFilters));
    }
}

