/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.advancedfilter;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.support.widget.CustomButton;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchIconWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.advancedfilter.ActionButton;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedFilterContainerMenu;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedTag;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedTagSlot;
import com.ultramega.cabletiers.common.packet.c2s.SetAdvancedFilterPacket;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import net.minecraft.class_8710;

public class AdvancedFilterScreen
extends AbstractBaseScreen<AdvancedFilterContainerMenu> {
    static final int ROW_HEIGHT = 18;
    static final int ADVANCED_TAG_HEIGHT = 36;
    static final int RESOURCES_PER_ROW = 9;
    private static final class_2960 TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/advanced_filter.png");
    private static final class_5250 DONE = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "advanced_filter.done");
    private static final class_8666 EXPAND_SPRITES = new class_8666(IdentifierUtil.createIdentifier((String)"widget/expand"), IdentifierUtil.createIdentifier((String)"widget/expand_disabled"), IdentifierUtil.createIdentifier((String)"widget/expand_focused"), IdentifierUtil.createIdentifier((String)"widget/expand_disabled"));
    private static final class_8666 COLLAPSE_SPRITES = new class_8666(IdentifierUtil.createIdentifier((String)"widget/collapse"), IdentifierUtil.createIdentifier((String)"widget/collapse_focused"));
    private static final class_5250 EXPAND = IdentifierUtil.createTranslation((String)"gui", (String)"pattern_grid.alternatives.expand");
    private static final class_2561 SEARCH_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"pattern_grid.alternatives.search_help").method_27692(class_124.field_1080);
    private static final int TAGS_DISPLAYED = 2;
    private static final int ROWS_PER_TAG = 2;
    private static final int INSET_WIDTH = 194;
    private static final int INSET_HEIGHT = 90;
    private static final int ACTION_BUTTON_HEIGHT = 20;
    private static final int ACTION_BUTTON_SPACING = 20;
    @Nullable
    private ScrollbarWidget scrollbar;
    @Nullable
    private class_342 searchField;
    @Nullable
    private final class_437 parent;
    private final int slotIndex;
    @Nullable
    private final class_6862<?> selectedTagKey;
    private final List<CheckboxWidget> advancedTagCheckboxes = new ArrayList<CheckboxWidget>();
    private final List<class_4185> expandButtons = new ArrayList<class_4185>();

    public AdvancedFilterScreen(@Nullable class_437 parent, class_1661 playerInventory, int slotIndex, @Nullable class_6862<?> selectedTagKey, @Nullable PlatformResourceKey selectedResource, class_2561 title) {
        super((class_1703)new AdvancedFilterContainerMenu(selectedResource), playerInventory, title);
        this.slotIndex = slotIndex;
        this.parent = parent;
        this.selectedTagKey = selectedTagKey;
        this.field_2792 = 223;
        this.field_2779 = 182;
    }

    protected void method_25426() {
        super.method_25426();
        this.advancedTagCheckboxes.clear();
        this.expandButtons.clear();
        int x = this.getCheckboxStartX();
        for (int i = 0; i < ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags().size(); ++i) {
            this.addWidgetsForTags(i, x);
        }
        this.addConfirmButton(160, 155);
        this.scrollbar = new ScrollbarWidget(this.field_2776 + 203, this.field_2800 + 59, ScrollbarWidget.Type.NORMAL, 90);
        int overflowingRows = ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags().size() - 2;
        int maxOffset = this.scrollbar.isSmoothScrolling() ? overflowingRows * 36 : overflowingRows * 2;
        this.scrollbar.setMaxOffset((double)maxOffset);
        this.scrollbar.setEnabled(maxOffset > 0);
        this.scrollbar.setListener(value -> this.updateWidgets());
        this.method_25429((class_364)this.scrollbar);
        Objects.requireNonNull(this.field_22793);
        this.searchField = new class_342(this.field_22793, this.field_2776 + 24, this.field_2800 + 46, 187, 9, (class_2561)class_2561.method_43473());
        this.searchField.method_1858(false);
        this.searchField.method_1862(true);
        this.searchField.method_1856(true);
        this.searchField.method_25365(false);
        this.searchField.method_1863(query -> ((AdvancedFilterContainerMenu)this.method_17577()).filter((String)query));
        this.method_37063((class_364)this.searchField);
        this.method_37063((class_364)new SearchIconWidget(this.field_2776 + 7, this.field_2800 + 44, () -> SEARCH_HELP, this.searchField));
    }

    private int getCheckboxStartX() {
        return this.field_2776 + 8;
    }

    private int getCheckboxStartY() {
        return this.field_2800 + 59;
    }

    private int getAdvancedTagY(int idx) {
        return this.getCheckboxStartY() + 36 * idx;
    }

    private void addWidgetsForTags(int idx, int x) {
        AdvancedTag advancedTag = ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags().get(idx);
        int y = this.getAdvancedTagY(idx);
        boolean hasTranslation = class_1074.method_4663((String)advancedTag.getTranslationKey());
        class_5250 id = class_2561.method_43470((String)advancedTag.getId().toString());
        CheckboxWidget advancedTagCheckbox = new CheckboxWidget(x + 2, y + 9 - 4, 141, (class_2561)(hasTranslation ? class_2561.method_43471((String)advancedTag.getTranslationKey()) : id), this.field_22793, this.selectedTagKey != null && this.selectedTagKey.comp_327().equals((Object)advancedTag.getId()), CheckboxWidget.Size.SMALL);
        advancedTagCheckbox.setOnPressed((checkbox, selected) -> {
            this.advancedTagCheckboxes.forEach(c -> c.setSelected(false));
            checkbox.setSelected(selected);
        });
        if (hasTranslation) {
            advancedTagCheckbox.method_47400(class_7919.method_47407((class_2561)id));
        }
        this.advancedTagCheckboxes.add((CheckboxWidget)this.method_25429((class_364)advancedTagCheckbox));
        CustomButton expandButton = new CustomButton(x + 194 - 16 - 1, y + 1, 16, 16, EXPAND_SPRITES, btn -> {
            boolean expanding = advancedTag.expandOrCollapse();
            btn.setSprites(expanding ? COLLAPSE_SPRITES : EXPAND_SPRITES);
        }, (class_2561)EXPAND);
        expandButton.field_22763 = advancedTag.getResources().size() > 9;
        this.expandButtons.add((class_4185)this.method_25429((class_364)expandButton));
    }

    protected void method_37432() {
        super.method_37432();
        ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags().forEach(AdvancedTag::update);
        this.updateWidgets();
    }

    protected void renderResourceSlots(class_332 graphics) {
        ResourceSlotRendering.render((class_332)graphics, (ResourceSlot)((AdvancedFilterContainerMenu)this.method_17577()).getFilterSlot(), (int)this.field_2776, (int)this.field_2800);
    }

    private void updateWidgets() {
        ScrollbarWidget theScrollbar = this.scrollbar;
        if (theScrollbar == null) {
            return;
        }
        double totalHeight = 0.0;
        int totalRows = 0;
        int scrollbarOffset = (int)theScrollbar.getOffset();
        int y = this.getAdvancedTagY(0) - (theScrollbar.isSmoothScrolling() ? scrollbarOffset : scrollbarOffset * 18);
        for (int i = 0; i < ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags().size(); ++i) {
            AdvancedTag advancedTag = ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags().get(i);
            CheckboxWidget advancedTagCheckbox = this.advancedTagCheckboxes.get(i);
            class_4185 expandButton = this.expandButtons.get(i);
            if (!advancedTag.isVisible()) {
                advancedTagCheckbox.field_22764 = false;
                expandButton.field_22764 = false;
                this.updateAdvancedTagSlots(advancedTag.getMainSlots(), y, 0, false);
                this.updateAdvancedTagSlots(advancedTag.getOverflowSlots(), y, 1, false);
                continue;
            }
            totalRows += 2;
            int overflowRows = AdvancedFilterScreen.getOverflowRows(advancedTag);
            totalRows += (int)((double)overflowRows * advancedTag.getExpandPct());
            int height = 36 + (int)((double)(overflowRows * 18) * advancedTag.getExpandPct());
            this.updateAdvancedTagCheckbox(advancedTagCheckbox, y);
            this.updateExpandButton(expandButton, y);
            this.updateAdvancedTagSlots(advancedTag.getMainSlots(), y, 0, true);
            this.updateAdvancedTagSlots(advancedTag.getOverflowSlots(), y, 1, advancedTag.getExpandPct() > 0.0);
            totalHeight += (double)height;
            y += height;
        }
        double maxOffset = theScrollbar.isSmoothScrolling() ? totalHeight - 72.0 : (double)(totalRows - 1 - 4);
        theScrollbar.setMaxOffset(maxOffset);
        theScrollbar.setEnabled(maxOffset > 0.0);
    }

    private void updateAdvancedTagCheckbox(CheckboxWidget advancedTagCheckbox, int y) {
        advancedTagCheckbox.method_46419(y + 9 - 4);
        advancedTagCheckbox.field_22764 = advancedTagCheckbox.method_46427() >= this.getCheckboxStartY() - advancedTagCheckbox.method_25364() && advancedTagCheckbox.method_46427() < this.getCheckboxStartY() + 90;
    }

    private void updateExpandButton(class_4185 expandButton, int y) {
        expandButton.method_46419(y + 1);
        expandButton.field_22764 = expandButton.method_46427() >= this.getCheckboxStartY() - expandButton.method_25364() && expandButton.method_46427() < this.getCheckboxStartY() + 90;
    }

    private void updateAdvancedTagSlots(List<AdvancedTagSlot> slots, int y, int rowOffset, boolean visible) {
        for (int i = 0; i < slots.size(); ++i) {
            int row = i / 9 + rowOffset;
            AdvancedTagSlot resourceSlot = slots.get(i);
            Platform.INSTANCE.setSlotY((class_1735)resourceSlot, y + 18 + row * 18 + 1 - this.field_2800);
            resourceSlot.setActive(resourceSlot.field_7872 + this.field_2800 >= this.getCheckboxStartY() - 18 && resourceSlot.field_7872 + this.field_2800 < this.getCheckboxStartY() + 90 && visible);
        }
    }

    private static int getOverflowRows(AdvancedTag advancedTag) {
        return Math.ceilDiv(advancedTag.getResources().size() - 9, 9);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollbar != null) {
            this.scrollbar.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        super.method_2389(graphics, delta, mouseX, mouseY);
        int x = this.getCheckboxStartX();
        int y = this.getCheckboxStartY();
        graphics.method_44379(x, y, x + 194, y + 90);
        int currentY = y - (this.scrollbar != null ? (int)this.scrollbar.getOffset() : 0) * (this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? 1 : 18);
        for (int i = 0; i < ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags().size(); ++i) {
            currentY += this.renderAdvancedTagBackground(graphics, mouseX, mouseY, i, y, x, currentY);
        }
        this.renderAdvancedTagMainSlots(graphics, mouseX, mouseY);
        this.advancedTagCheckboxes.forEach(c -> c.method_25394(graphics, mouseX, mouseY, delta));
        this.expandButtons.forEach(c -> c.method_25394(graphics, mouseX, mouseY, delta));
        graphics.method_44380();
    }

    private int renderAdvancedTagBackground(class_332 graphics, int mouseX, int mouseY, int i, int startY, int x, int y) {
        boolean backgroundVisible;
        AdvancedTag advancedTag = ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags().get(i);
        if (!advancedTag.isVisible()) {
            return 0;
        }
        int height = 36 + (int)((double)(AdvancedFilterScreen.getOverflowRows(advancedTag) * 18) * advancedTag.getExpandPct());
        boolean bl = backgroundVisible = y >= startY - height && y < startY + 90;
        if (i % 2 == 0 && backgroundVisible) {
            graphics.method_51737(x, y, x + 194, y + height, 0, -3750202);
        }
        int mainSlotsY = y + 18;
        this.renderMainSlotsBackground(graphics, startY, x, mainSlotsY, advancedTag);
        int overflowSlotsY = y + 36;
        return 36 + this.renderOverflowSlotsBackground(graphics, mouseX, mouseY, startY, x, overflowSlotsY, advancedTag);
    }

    private void renderMainSlotsBackground(class_332 graphics, int startY, int x, int y, AdvancedTag advancedTag) {
        if (y >= startY - 18 && y < startY + 90) {
            for (int col = 0; col < Math.min(advancedTag.getResources().size(), 9); ++col) {
                int slotX = x + 1 + col * 18;
                graphics.method_52706(Sprites.SLOT, slotX, y, 18, 18);
            }
        }
    }

    private int renderOverflowSlotsBackground(class_332 graphics, int mouseX, int mouseY, int startY, int x, int y, AdvancedTag advancedTag) {
        int rows = AdvancedFilterScreen.getOverflowRows(advancedTag);
        int height = (int)((double)(rows * 18) * advancedTag.getExpandPct());
        if (height == 0) {
            return 0;
        }
        graphics.method_44379(x, y, x + 162, y + height);
        for (int row = 0; row < rows; ++row) {
            int idx;
            boolean visible;
            int rowY = y + 18 * row;
            boolean bl = visible = rowY >= startY - 18 && rowY < startY + 90;
            if (!visible) continue;
            for (int col = 0; col < 9 && (idx = 9 + row * 9 + col) < advancedTag.getResources().size(); ++col) {
                int slotX = x + 1 + col * 18;
                graphics.method_52706(Sprites.SLOT, slotX, rowY, 18, 18);
            }
        }
        this.renderSlots(advancedTag.getOverflowSlots(), graphics, mouseX, mouseY);
        graphics.method_44380();
        return height;
    }

    private void renderAdvancedTagMainSlots(class_332 graphics, int mouseX, int mouseY) {
        for (AdvancedTag advancedTag : ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags()) {
            this.renderSlots(advancedTag.getMainSlots(), graphics, mouseX, mouseY);
        }
    }

    private void renderSlots(List<AdvancedTagSlot> slots, class_332 graphics, int mouseX, int mouseY) {
        for (ResourceSlot resourceSlot : slots) {
            if (!resourceSlot.method_7682()) continue;
            ResourceSlotRendering.render((class_332)graphics, (ResourceSlot)resourceSlot, (int)this.field_2776, (int)this.field_2800);
            if (!this.method_2378(resourceSlot.field_7873, resourceSlot.field_7872, 16, 16, mouseX, mouseY)) continue;
            AdvancedFilterScreen.method_33285((class_332)graphics, (int)(this.field_2776 + resourceSlot.field_7873), (int)(this.field_2800 + resourceSlot.field_7872), (int)0);
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
    }

    private void addConfirmButton(int x, int y) {
        int width = this.field_22793.method_27525((class_5348)DONE) + 20 + 12;
        ActionButton button = new ActionButton(this.field_2776 + x, this.field_2800 + y, width, 20, (class_2561)DONE, btn -> this.tryConfirmAndCloseToParent());
        this.method_37063((class_364)button);
    }

    public boolean method_25402(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar != null && this.scrollbar.method_25402(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, clickedButton);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.scrollbar != null) {
            this.scrollbar.method_16014(mouseX, mouseY);
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.scrollbar != null && this.scrollbar.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean didScrollbar = this.isOverTagArea(mouseX, mouseY) && this.scrollbar != null && this.scrollbar.method_25401(mouseX, mouseY, scrollX, scrollY);
        return didScrollbar || super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    private boolean isOverTagArea(double mouseX, double mouseY) {
        return mouseX >= (double)this.getCheckboxStartX() && mouseX < (double)(this.getCheckboxStartX() + 194) && mouseY >= (double)this.getCheckboxStartY() && mouseY < (double)(this.getCheckboxStartY() + 90);
    }

    public boolean method_25400(char unknown1, int unknown2) {
        return this.searchField != null && this.searchField.method_25400(unknown1, unknown2) || super.method_25400(unknown1, unknown2);
    }

    private boolean tryConfirmAndCloseToParent() {
        if (this.parent != null) {
            class_310.method_1551().method_1507(this.parent);
            OptionalInt selectedIndex = IntStream.range(0, this.advancedTagCheckboxes.size()).filter(i -> this.advancedTagCheckboxes.get(i).isSelected()).findFirst();
            if (selectedIndex.isPresent()) {
                ResourceTag resourceTag = ((AdvancedFilterContainerMenu)this.method_17577()).getAdvancedTags().get(selectedIndex.getAsInt()).getTag();
                Platform.INSTANCE.sendPacketToServer((class_8710)new SetAdvancedFilterPacket(this.slotIndex, Optional.of(resourceTag)));
            } else {
                Platform.INSTANCE.sendPacketToServer((class_8710)new SetAdvancedFilterPacket(this.slotIndex, Optional.empty()));
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int key, int scanCode, int modifiers) {
        if (this.tryClose(key)) {
            return true;
        }
        if (this.searchField != null && (this.searchField.method_25404(key, scanCode, modifiers) || this.searchField.method_20315())) {
            return true;
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    private boolean tryClose(int key) {
        if (key == 256) {
            this.close();
            return true;
        }
        return false;
    }

    private void close() {
        if (!this.tryConfirmAndCloseToParent()) {
            this.method_25419();
        }
    }

    protected class_2960 getTexture() {
        return TEXTURE;
    }
}

