/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.advancedfilter;

import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.utils.ModCodecs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6862;
import net.minecraft.class_7225;

public class AdvancedResourceContainerImpl
extends ResourceContainerImpl {
    private static final String TAG_FILTER = "tf";
    private static final String TAG_FILTER_INDICES = "tfi";
    private ResourceTag[] filterTags;
    private ResourceAmount[] fakeSlots;
    private int[] fakeStartIndices;
    private int[] fakeShowcaseIndices;
    @Nullable
    private Consumer<Integer> listener;

    public AdvancedResourceContainerImpl(int size, ToLongFunction<ResourceKey> maxAmountProvider, ResourceFactory primaryResourceFactory, Set<ResourceFactory> alternativeResourceFactories) {
        super(size, maxAmountProvider, primaryResourceFactory, alternativeResourceFactories);
        this.filterTags = new ResourceTag[size];
        this.fakeSlots = new ResourceAmount[size];
        this.fakeStartIndices = new int[size];
        this.fakeShowcaseIndices = new int[size];
        Arrays.fill(this.fakeShowcaseIndices, -1);
    }

    public void setListener(Consumer<Integer> listener) {
        this.listener = listener;
    }

    public void set(int index, ResourceAmount resourceAmount) {
        super.set(index, resourceAmount);
        if (this.listener != null) {
            this.listener.accept(index);
        }
    }

    public void remove(int index) {
        super.remove(index);
        this.fakeSlots[index] = null;
        this.fakeStartIndices[index] = 0;
        this.fakeShowcaseIndices[index] = -1;
        if (this.listener != null) {
            this.listener.accept(index);
        }
    }

    @Nullable
    public ResourceAmount get(int index) {
        return this.fakeSlots[index] != null ? this.fakeSlots[index] : super.get(index);
    }

    public void updateFakeSlot(int index, ResourceTag tag) {
        if (this.fakeShowcaseIndices[index] == -1) {
            this.fakeShowcaseIndices[index] = this.fakeStartIndices[index];
        }
        int n = index;
        this.fakeShowcaseIndices[n] = this.fakeShowcaseIndices[n] + 1;
        int showcasedIndex = this.fakeShowcaseIndices[n];
        if (showcasedIndex >= tag.resources().size()) {
            this.fakeShowcaseIndices[index] = 0;
            showcasedIndex = 0;
        }
        this.setFake(index, new ResourceAmount((ResourceKey)tag.resources().get(showcasedIndex), 1L));
    }

    public void setFakeStartIndex(int index, int fakeStartIndex) {
        this.fakeStartIndices[index] = fakeStartIndex;
    }

    public void setFakeShowcaseIndex(int index, int fakeShowcaseIndex) {
        this.fakeShowcaseIndices[index] = fakeShowcaseIndex;
    }

    public int getFakeShowcaseIndex(int index) {
        if (this.fakeShowcaseIndices[index] == -1) {
            this.fakeShowcaseIndices[index] = this.fakeStartIndices[index];
        }
        return this.fakeShowcaseIndices[index];
    }

    public void setFilterTag(int index, @Nullable ResourceTag resourceTag) {
        this.filterTags[index] = resourceTag;
    }

    @Nullable
    public class_6862<?> getFilterTag(int index) {
        return this.filterTags[index] != null ? this.filterTags[index].key() : null;
    }

    public List<ResourceTag> getFilterTagsWithNull() {
        return new ArrayList<ResourceTag>(Arrays.asList(this.filterTags));
    }

    public List<ResourceTag> getFilterTags() {
        ArrayList<ResourceTag> tags = new ArrayList<ResourceTag>();
        for (int i = 0; i < this.size(); ++i) {
            PlatformResourceKey slot = this.getResource(i);
            if (slot == null) continue;
            tags.add(this.filterTags[i] != null ? this.filterTags[i] : null);
        }
        return tags;
    }

    public Set<class_6862<?>> getUniqueFilterTags() {
        HashSet uniqueTags = new HashSet();
        for (int i = 0; i < this.size(); ++i) {
            PlatformResourceKey slot = this.getResource(i);
            if (slot == null) continue;
            uniqueTags.add(this.filterTags[i] != null ? this.filterTags[i].key() : null);
        }
        return uniqueTags;
    }

    public void setFake(int index, @Nullable ResourceAmount resourceAmount) {
        this.fakeSlots[index] = resourceAmount;
    }

    public void resetFakeFilters() {
        this.fakeSlots = new ResourceAmount[this.fakeSlots.length];
        this.fakeStartIndices = new int[this.fakeSlots.length];
        this.fakeShowcaseIndices = new int[this.fakeSlots.length];
        Arrays.fill(this.fakeShowcaseIndices, -1);
    }

    public class_2487 toTag(class_7225.class_7874 provider) {
        class_2487 tag = super.toTag(provider);
        tag.method_10566(TAG_FILTER, (class_2520)this.filterTagsToTag());
        tag.method_10539(TAG_FILTER_INDICES, this.fakeStartIndices);
        return tag;
    }

    public void fromTag(class_2487 tag, class_7225.class_7874 provider) {
        super.fromTag(tag, provider);
        this.filterTags = this.filterTagsFromTag(tag);
        this.fakeStartIndices = tag.method_10561(TAG_FILTER_INDICES);
    }

    private class_2499 filterTagsToTag() {
        class_2499 listTag = new class_2499();
        for (ResourceTag resourceTag : this.getFilterTagsWithNull()) {
            if (resourceTag != null) {
                listTag.add((Object)((class_2520)ModCodecs.RESOURCE_TAG_CODEC.encode((Object)resourceTag, (DynamicOps)class_2509.field_11560, (Object)new class_2487()).getOrThrow()));
                continue;
            }
            listTag.add((Object)new class_2487());
        }
        return listTag;
    }

    private ResourceTag[] filterTagsFromTag(class_2487 tag) {
        class_2499 listTag = tag.method_10554(TAG_FILTER, 10);
        ResourceTag[] tags = new ResourceTag[listTag.size()];
        for (int i = 0; i < listTag.size(); ++i) {
            tags[i] = ModCodecs.RESOURCE_TAG_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)listTag.method_10602(i)).result().orElse(null);
        }
        return tags;
    }

    public static AdvancedResourceContainerImpl createForFilter(CableTiers tier) {
        return AdvancedResourceContainerImpl.createForFilter(tier.getFilterSlotsCount());
    }

    public static AdvancedResourceContainerImpl createForFilter(int size) {
        return new AdvancedResourceContainerImpl(size, resource -> Long.MAX_VALUE, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }
}

