/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.storage;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.DiskStateChangeListener;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceContainerImpl;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.utils.TagFiltering;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public abstract class AbstractTieredDiskContainerBlockEntity<T extends AbstractStorageContainerNetworkNode>
extends AbstractBaseNetworkNodeContainerBlockEntity<T>
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<ResourceContainerData>,
TagFiltering {
    private static final String TAG_DISK_INVENTORY = "inv";
    private static final String TAG_DISKS = "disks";
    protected final CableTiers tier;
    protected final CableType type;
    protected final TagFilterWithFuzzyMode filter;
    protected final DiskInventory diskInventory;
    @Nullable
    protected Disk[] disks;
    private final DiskStateChangeListener diskStateListener = new DiskStateChangeListener((class_2586)this);
    @Nullable
    private Runnable onChanged;
    private boolean inContainerMenu;

    protected AbstractTieredDiskContainerBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state, T node, CableTiers tier, CableType type) {
        super(blockEntityType, pos, state, node);
        this.tier = tier;
        this.type = type;
        this.diskInventory = new DiskInventory((inventory, slot) -> this.onDiskChanged(slot), ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getSize());
        this.filter = TagFilterWithFuzzyMode.createAndListenForUniqueFilters(AdvancedResourceContainerImpl.createForFilter(tier), this::method_5431, this::setFilters);
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setListener((StateTrackedStorage.Listener)this.diskStateListener);
        this.setNormalizer(this.filter.createNormalizer());
    }

    public void doWork() {
        for (int i = 0; i < this.tier.getSpeed(this.type); ++i) {
            super.doWork();
        }
        if (!this.inContainerMenu) {
            return;
        }
        this.filter.doWork();
    }

    protected void containerInitialized() {
        super.containerInitialized();
        PlatformUtil.sendBlockUpdateToClient((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    protected abstract void setFilters(Set<ResourceKey> var1, Set<class_6862<?>> var2);

    protected abstract void setNormalizer(UnaryOperator<ResourceKey> var1);

    @Override
    public void setTagFilter(int index, @Nullable ResourceTag resourceTag) {
        this.filter.setFilterTag(index, resourceTag);
    }

    @Override
    @Nullable
    public class_6862<?> getTagFilter(int index) {
        return this.filter.getFilterContainer().getFilterTag(index);
    }

    @Override
    public void resetFakeFilters() {
        this.filter.resetFakeFilters();
    }

    @Override
    public void sendFilterTagsToClient(class_3222 player) {
        this.filter.sendFilterTagsToClient(player);
    }

    @Override
    public void setOnChanged(@Nullable Runnable onChanged) {
        this.onChanged = onChanged;
    }

    @Override
    public void setInContainerMenu(boolean inContainerMenu) {
        this.inContainerMenu = inContainerMenu;
    }

    @Nullable
    public static class_1792 getDisk(class_2487 tag, int slot, class_7225.class_7874 provider) {
        if (!tag.method_10545(TAG_DISK_INVENTORY)) {
            return null;
        }
        class_2487 diskInventoryTag = tag.method_10562(TAG_DISK_INVENTORY);
        if (!ContainerUtil.hasItemInSlot((class_2487)diskInventoryTag, (int)slot)) {
            return null;
        }
        class_1799 diskStack = ContainerUtil.getItemInSlot((class_2487)diskInventoryTag, (int)slot, (class_7225.class_7874)provider);
        return diskStack.method_7960() ? null : diskStack.method_7909();
    }

    void updateDiskStateIfNecessaryInLevel() {
        this.diskStateListener.updateIfNecessary();
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (!level.method_8608()) {
            this.initialize(level);
        }
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.initialize(this.field_11863);
        }
        if (this.onChanged != null) {
            this.onChanged.run();
        }
    }

    private void initialize(class_1937 level) {
        this.diskInventory.setStorageRepository(RefinedStorageApi.INSTANCE.getStorageRepository(level));
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setProvider((AbstractStorageContainerNetworkNode.Provider)this.diskInventory);
    }

    public void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        PlatformUtil.sendBlockUpdateToClient((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        this.fromClientTag(tag);
        if (tag.method_10545(TAG_DISK_INVENTORY)) {
            ContainerUtil.read((class_2487)tag.method_10562(TAG_DISK_INVENTORY), (class_1263)this.diskInventory, (class_7225.class_7874)provider);
        }
        super.method_11014(tag, provider);
    }

    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_DISK_INVENTORY, (class_2520)ContainerUtil.write((class_1263)this.diskInventory, (class_7225.class_7874)provider));
    }

    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    public FilteredContainer getDiskInventory() {
        return this.diskInventory;
    }

    private void onDiskChanged(int slot) {
        boolean isPlacedThroughDismantlingMode;
        boolean isJustPlacedIntoLevelOrLoading = this.field_11863 == null || this.field_11863.method_8608();
        boolean bl = isPlacedThroughDismantlingMode = ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork() == null;
        if (isJustPlacedIntoLevelOrLoading || isPlacedThroughDismantlingMode) {
            return;
        }
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).onStorageChanged(slot);
        PlatformUtil.sendBlockUpdateToClient((class_1937)this.field_11863, (class_2338)this.field_11867);
        this.method_5431();
    }

    private void fromClientTag(class_2487 tag) {
        if (!tag.method_10545(TAG_DISKS)) {
            return;
        }
        this.disks = this.diskInventory.fromSyncTag(tag.method_10554(TAG_DISKS, 10));
        this.onClientDriveStateUpdated();
    }

    protected void onClientDriveStateUpdated() {
        if (this.field_11863 == null) {
            return;
        }
        Platform.INSTANCE.requestModelDataUpdateOnClient((class_1936)this.field_11863, this.field_11867, true);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        if (((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork() == null) {
            return tag;
        }
        tag.method_10566(TAG_DISKS, (class_2520)this.diskInventory.toSyncTag(arg_0 -> ((AbstractStorageContainerNetworkNode)((AbstractStorageContainerNetworkNode)this.mainNetworkNode)).getState(arg_0)));
        return tag;
    }

    public class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < this.diskInventory.method_5439(); ++i) {
            drops.add((Object)this.diskInventory.method_5438(i));
        }
        return drops;
    }

    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer());
    }

    public class_9142<class_9129, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((class_2680)oldBlockState, (class_2680)newBlockState);
    }
}

