/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.storage.diskinterface;

import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferListener;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.TieredUpgradeDestinations;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.storage.AbstractTieredDiskContainerBlockEntity;
import com.ultramega.cabletiers.common.storage.AdvancedStorageTransferNetworkNode;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceContainerMenu;
import com.ultramega.cabletiers.common.storage.diskinterface.TransferModeSettings;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import net.minecraft.class_7225;

public abstract class AbstractTieredDiskInterfaceBlockEntity
extends AbstractTieredDiskContainerBlockEntity<AdvancedStorageTransferNetworkNode>
implements StorageTransferListener {
    public static final int AMOUNT_OF_DISKS = 6;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_TRANSFER_MODE = "tm";
    private final UpgradeContainer upgradeContainer;

    protected AbstractTieredDiskInterfaceBlockEntity(final CableTiers tier, class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getTieredDiskInterfaces(tier), pos, state, new AdvancedStorageTransferNetworkNode(tier.getEnergyUsage(CableType.DISK_INTERFACE), Platform.INSTANCE.getConfig().getDiskInterface().getEnergyUsagePerDisk(), 6), tier, CableType.DISK_INTERFACE);
        this.upgradeContainer = new UpgradeContainer(this, AbstractTieredDiskInterfaceBlockEntity.getUpgradeDestination(tier), (c, upgradeEnergyUsage) -> {
            ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setEnergyUsage(tier.getEnergyUsage(CableType.DISK_INTERFACE) + upgradeEnergyUsage);
            this.method_5431();
        }){

            public boolean has(UpgradeItem upgradeItem) {
                if (tier.hasIntegratedStackUpgrade(CableType.DISK_INTERFACE) && upgradeItem == Items.INSTANCE.getStackUpgrade()) {
                    return true;
                }
                return super.has(upgradeItem);
            }

            public int getAmount(UpgradeItem upgradeItem) {
                if (tier == CableTiers.CREATIVE && upgradeItem == Items.INSTANCE.getSpeedUpgrade()) {
                    return 4;
                }
                return super.getAmount(upgradeItem);
            }
        };
        this.ticker = this.upgradeContainer.getTicker();
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setListener(this);
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setTransferQuotaProvider(storage -> {
            if (storage instanceof SerializableStorage) {
                SerializableStorage serializableStorage = (SerializableStorage)storage;
                return serializableStorage.getType().getDiskInterfaceTransferQuota(this.upgradeContainer.has((UpgradeItem)Items.INSTANCE.getStackUpgrade())) * (long)tier.getSpeed(CableType.DISK_INTERFACE);
            }
            return tier.getSpeed(CableType.DISK_INTERFACE);
        });
    }

    public static UpgradeDestination getUpgradeDestination(CableTiers tier) {
        return tier.hasIntegratedStackUpgrade(CableType.DISK_INTERFACE) ? TieredUpgradeDestinations.DISK_INTERFACE_NO_STACK : UpgradeDestinations.DISK_INTERFACE;
    }

    @Override
    protected void setFilters(Set<ResourceKey> filters, Set<class_6862<?>> tagFilters) {
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setFilters(filters, tagFilters);
    }

    @Override
    protected void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setNormalizer(normalizer);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read((class_2487)tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, (class_7225.class_7874)provider);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, (class_7225.class_7874)provider));
        tag.method_10569(TAG_FILTER_MODE, FilterModeSettings.getFilterMode((FilterMode)((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).getFilterMode()));
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        if (tag.method_10545(TAG_TRANSFER_MODE)) {
            ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setMode(TransferModeSettings.getTransferMode(tag.method_10550(TAG_TRANSFER_MODE)));
        }
        if (tag.method_10545(TAG_FILTER_MODE)) {
            ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode((int)tag.method_10550(TAG_FILTER_MODE)));
        }
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        tag.method_10569(TAG_TRANSFER_MODE, TransferModeSettings.getTransferMode(((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).getMode()));
    }

    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)this.tier.getContentName(CableType.DISK_INTERFACE));
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        this.setInContainerMenu(true);
        return new TieredDiskInterfaceContainerMenu(syncId, player, this, this.diskInventory, (ResourceContainer)this.filter.getFilterContainer(), this.upgradeContainer, this.tier);
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        class_2371<class_1799> drops = super.getDrops();
        for (int i = 0; i < this.upgradeContainer.method_5439(); ++i) {
            drops.add((Object)this.upgradeContainer.method_5438(i));
        }
        return drops;
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        this.method_5431();
    }

    FilterMode getFilterMode() {
        return ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    void setFilterMode(FilterMode mode) {
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.method_5431();
    }

    public StorageTransferMode getTransferMode() {
        return ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).getMode();
    }

    public void setTransferMode(StorageTransferMode mode) {
        ((AdvancedStorageTransferNetworkNode)this.mainNetworkNode).setMode(mode);
        this.method_5431();
    }

    public void onTransferSuccess(int index) {
        class_1799 diskStack = this.diskInventory.method_5438(index);
        if (diskStack.method_7960()) {
            return;
        }
        for (int newIndex = 3; newIndex < 6; ++newIndex) {
            if (!this.diskInventory.method_5438(newIndex).method_7960()) continue;
            this.diskInventory.method_5447(index, class_1799.field_8037);
            this.diskInventory.method_5447(newIndex, diskStack);
            return;
        }
    }
}

