/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_6862;
import net.rodofire.easierworldcreator.tag.TagUtil;
import net.rodofire.easierworldcreator.util.LongPosHelper;

public class StructurePlacementRuleManager {
    private boolean force = false;
    private Set<class_2248> overriddenBlocks = new HashSet<class_2248>();

    public StructurePlacementRuleManager() {
    }

    public StructurePlacementRuleManager(Set<class_2248> overridenBlocks) {
        this.overriddenBlocks = new HashSet<class_2248>(overridenBlocks);
    }

    public StructurePlacementRuleManager(Set<class_2248> overriddenBlocks, Set<class_6862<class_2248>> overriddenTags) {
        this.overriddenBlocks = new HashSet<class_2248>(overriddenBlocks);
        this.addTagKeys(overriddenTags);
    }

    public StructurePlacementRuleManager(boolean force) {
        this.force = force;
    }

    public StructurePlacementRuleManager(boolean force, Set<class_2248> overriddenBlocks) {
        this.force = force;
        this.overriddenBlocks = new HashSet<class_2248>(overriddenBlocks);
    }

    public StructurePlacementRuleManager(boolean force, Set<class_2248> overriddenBlocks, Set<class_6862<class_2248>> overriddenTags) {
        this.force = force;
        this.overriddenBlocks = new HashSet<class_2248>(overriddenBlocks);
        this.addTagKeys(overriddenTags);
    }

    public Set<class_2248> getOverriddenBlocks() {
        return this.overriddenBlocks;
    }

    public void setOverriddenBlocks(Set<class_2248> overriddenBlocks) {
        this.overriddenBlocks = new HashSet<class_2248>(overriddenBlocks);
    }

    public void setOverriddenTags(Set<class_6862<class_2248>> overriddenTags) {
        this.overriddenBlocks = TagUtil.BlockTags.convertBlockTagToBlockSet(overriddenTags);
    }

    public void addOverrideBlock(class_2248 block) {
        this.overriddenBlocks.add(block);
    }

    public void addTagKey(class_6862<class_2248> tagKey) {
        this.overriddenBlocks.addAll(TagUtil.BlockTags.convertBlockTagToBlockSet(tagKey));
    }

    public void addOverrideBlocks(Set<class_2248> overriddenBlocks) {
        this.overriddenBlocks.addAll(overriddenBlocks);
    }

    public void addTagKeys(Set<class_6862<class_2248>> tagKeys) {
        this.overriddenBlocks.addAll(TagUtil.BlockTags.convertBlockTagToBlockSet(tagKeys));
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean canPlace(class_5281 worldAccess, class_2338 pos) {
        class_2680 state = worldAccess.method_8320(pos);
        return this.canPlace(state);
    }

    public boolean canPlace(class_5281 worldAccess, long pos) {
        class_2680 state = worldAccess.method_8320(LongPosHelper.decodeBlockPos(pos));
        return this.canPlace(state);
    }

    public boolean canPlace(class_2680 state) {
        if (this.force) {
            return !this.overriddenBlocks.contains(state.method_26204());
        }
        return state.method_26215() || this.overriddenBlocks.contains(state.method_26204());
    }

    public String toString() {
        return "StructurePlacementRuleManager{force=" + this.force + ", overriddenBlocks=" + this.overriddenBlocks.parallelStream().map(class_2248::toString).collect(Collectors.joining(", ", "[", "]")) + "}";
    }
}

