/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata;

import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.Long2ShortOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Collection;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.rodofire.easierworldcreator.blockdata.BlockDataKey;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import net.rodofire.easierworldcreator.util.map.ObjectShortLinkHashBiMap;
import org.jetbrains.annotations.NotNull;

public class WorldStateCollector {
    ObjectShortLinkHashBiMap<BlockDataKey> data = new ObjectShortLinkHashBiMap();
    Long2ShortOpenHashMap posLink = new Long2ShortOpenHashMap();

    public WorldStateCollector() {
        this(30);
    }

    public WorldStateCollector(int capacity) {
        this.posLink = new Long2ShortOpenHashMap(capacity);
        this.posLink.defaultReturnValue((short)-1);
    }

    public <T extends AbstractLongCollection> WorldStateCollector collect(class_3218 world, T posList) {
        LongIterator longIterator = posList.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            if (this.posLink.containsKey(pos)) continue;
            class_2338 decodedPos = LongPosHelper.decodeBlockPos(pos);
            BlockDataKey data = WorldStateCollector.getDataKey(world, decodedPos);
            this.posLink.put(pos, this.data.put(data));
        }
        return this;
    }

    public <T extends Collection<class_2338>> WorldStateCollector collect(class_3218 world, T posList) {
        for (class_2338 decodedPos : posList) {
            long pos = LongPosHelper.encodeBlockPos(decodedPos);
            if (this.posLink.containsKey(pos)) continue;
            BlockDataKey data = WorldStateCollector.getDataKey(world, decodedPos);
            this.posLink.put(pos, this.data.put(data));
        }
        return this;
    }

    @NotNull
    private static BlockDataKey getDataKey(class_3218 world, class_2338 decodedPos) {
        class_2680 state = world.method_8320(decodedPos);
        BlockDataKey data = new BlockDataKey(state);
        class_2586 entity = world.method_8321(decodedPos);
        if (entity != null) {
            class_5455 registry = world.method_30349();
            class_2487 currentNbt = entity.method_38242((class_7225.class_7874)registry);
            data.setTag(currentNbt);
        }
        return data;
    }

    public class_2680 getState(long pos) {
        short index = this.posLink.get(pos);
        if (index == -1) {
            return null;
        }
        return this.data.get(index).getState();
    }

    public BlockDataKey getData(long pos) {
        short index = this.posLink.get(pos);
        if (index == -1) {
            return null;
        }
        return this.data.get(index);
    }

    public class_2680 getState(class_2338 decodedPos) {
        long pos = LongPosHelper.encodeBlockPos(decodedPos);
        short index = this.posLink.get(pos);
        if (index == -1) {
            return null;
        }
        return this.data.get(index).getState();
    }

    public BlockDataKey getData(class_2338 decodedPos) {
        long pos = LongPosHelper.encodeBlockPos(decodedPos);
        short index = this.posLink.get(pos);
        if (index == -1) {
            return null;
        }
        return this.data.get(index);
    }
}

