/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata.blocklist;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import net.rodofire.easierworldcreator.blockdata.BlockDataKey;
import net.rodofire.easierworldcreator.blockdata.StructurePlacementRuleManager;
import net.rodofire.easierworldcreator.util.BlockPlaceUtil;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import net.rodofire.easierworldcreator.util.file.EwcFolderData;

public class BlockList {
    StructurePlacementRuleManager ruler = new StructurePlacementRuleManager();
    private final LongArrayList posList = new LongArrayList();
    private BlockDataKey dataKey;
    class_3215 chunkManager;
    boolean markDirty = false;
    boolean init = false;

    public BlockList(class_2680 state, class_2487 tag, List<class_2338> posList) {
        this.addAllPos(posList);
        this.dataKey = new BlockDataKey(state, tag);
    }

    public BlockList(class_2680 state, class_2487 tag, class_2338 pos) {
        this(state, tag, List.of(pos));
    }

    public BlockList(class_2680 state, class_2487 tag, LongArrayList posList) {
        this.addAllPos(posList);
        this.dataKey = new BlockDataKey(state, tag);
    }

    public BlockList(class_2680 state, class_2487 tag, long pos) {
        this(state, tag, LongArrayList.of((long[])new long[]{pos}));
    }

    public BlockList(class_2680 state, List<class_2338> posList) {
        this(state, null, posList);
    }

    public BlockList(class_2680 state, class_2338 pos) {
        this(state, null, pos);
    }

    public BlockList(class_2680 state, LongArrayList posList) {
        this(state, null, posList);
    }

    public BlockList(class_2680 state, long pos) {
        this(state, null, pos);
    }

    public BlockList() {
        this(class_2246.field_10002.method_9564(), null, List.of());
    }

    public int size() {
        return this.posList.size();
    }

    public BlockList replacePos(int index, class_2338 newPos) {
        this.posList.set(index, LongPosHelper.encodeBlockPos(newPos));
        return this;
    }

    public BlockList replacePos(int index, long newPos) {
        this.posList.set(index, newPos);
        return this;
    }

    public BlockList addAllPos(List<class_2338> posList) {
        for (class_2338 pos : posList) {
            this.addPos(pos);
        }
        return this;
    }

    public BlockList addAllPos(LongArrayList posList) {
        LongListIterator longListIterator = posList.iterator();
        while (longListIterator.hasNext()) {
            long pos = (Long)longListIterator.next();
            this.addPos(pos);
        }
        return this;
    }

    public BlockList addPos(class_2338 pos) {
        this.posList.add(LongPosHelper.encodeBlockPos(pos));
        return this;
    }

    public BlockList addPos(long pos) {
        this.posList.add(pos);
        return this;
    }

    public BlockList setPosList(List<class_2338> posList) {
        this.posList.clear();
        this.addAllPos(posList);
        return this;
    }

    public BlockList setPosList(LongArrayList posList) {
        this.posList.clear();
        this.addAllPos(posList);
        return this;
    }

    public BlockList set(int index, class_2338 newPos) {
        this.posList.set(index, LongPosHelper.encodeBlockPos(newPos));
        return this;
    }

    public List<class_2338> getConvertedPosList() {
        ArrayList<class_2338> posList = new ArrayList<class_2338>();
        LongListIterator longListIterator = this.posList.iterator();
        while (longListIterator.hasNext()) {
            long pos = (Long)longListIterator.next();
            posList.add(LongPosHelper.decodeBlockPos(pos));
        }
        return posList;
    }

    public LongArrayList getPosList() {
        return this.posList;
    }

    public class_2338 getPos(int index) {
        return LongPosHelper.decodeBlockPos(this.posList.getLong(index));
    }

    public class_2338 getFirstPos() {
        return LongPosHelper.decodeBlockPos((Long)this.posList.getFirst());
    }

    public class_2338 getLastPos() {
        return LongPosHelper.decodeBlockPos((Long)this.posList.getLast());
    }

    public class_2338 getRandomPos() {
        return LongPosHelper.decodeBlockPos(this.posList.getLong(class_5819.method_43047().method_39332(0, this.size() - 1)));
    }

    public class_2338 getRandomPos(class_5819 random) {
        return LongPosHelper.decodeBlockPos(this.posList.getLong(random.method_39332(0, this.size() - 1)));
    }

    public long getLongPos(int index) {
        return this.posList.getLong(index);
    }

    public long getFirstLongPos() {
        return (Long)this.posList.getFirst();
    }

    public long getLastLongPos() {
        return (Long)this.posList.getLast();
    }

    public long getRandomLongPos() {
        return this.posList.getLong(class_5819.method_43047().method_39332(0, this.size() - 1));
    }

    public long getRandomLongPos(class_5819 random) {
        return this.posList.getLong(random.method_39332(0, this.size() - 1));
    }

    public class_2338 removePos(int index) {
        return LongPosHelper.decodeBlockPos(this.posList.removeLong(index));
    }

    public class_2338 removeLastPos() {
        return LongPosHelper.decodeBlockPos(this.posList.removeLong(this.posList.size() - 1));
    }

    public class_2338 removeFirstPos() {
        return LongPosHelper.decodeBlockPos(this.posList.removeLong(this.posList.size() - 1));
    }

    public BlockList removePos(class_2338 pos) {
        this.posList.removeLong(this.posList.indexOf(LongPosHelper.encodeBlockPos(pos)));
        return this;
    }

    public Optional<class_2487> getTag() {
        return Optional.ofNullable(this.dataKey.getTag());
    }

    public void setTag(class_2487 tag) {
        this.dataKey.setTag(tag);
    }

    public BlockList removeAll(List<class_2338> list) {
        for (class_2338 pos : list) {
            this.posList.removeLong(this.posList.indexOf(LongPosHelper.encodeBlockPos(pos)));
        }
        return this;
    }

    public StructurePlacementRuleManager getRuler() {
        return this.ruler;
    }

    public void setRuler(StructurePlacementRuleManager ruler) {
        this.ruler = ruler;
    }

    public class_2680 getState() {
        return this.dataKey.getState();
    }

    public void setState(class_2680 state) {
        this.dataKey.setState(state);
    }

    public BlockDataKey getBlockData() {
        return this.dataKey;
    }

    public void setBlockData(BlockDataKey data) {
        this.dataKey = data;
    }

    public boolean placeLast(class_5281 world) {
        return this.place(world, (Long)this.posList.getLast());
    }

    public boolean placeFirst(class_5281 world) {
        return this.place(world, (Long)this.posList.getFirst());
    }

    public boolean place(class_5281 world, int index) {
        return this.place(world, this.posList.getLong(index));
    }

    public boolean placeAll(class_5281 worldAccess, int flag) {
        boolean placed = true;
        LongListIterator longListIterator = this.posList.iterator();
        while (longListIterator.hasNext()) {
            long pos = (Long)longListIterator.next();
            if (this.place(worldAccess, pos, flag)) continue;
            placed = false;
        }
        return placed;
    }

    public boolean placeLast(class_5281 world, int flag) {
        return this.place(world, (Long)this.posList.getLast(), flag);
    }

    public boolean placeFirst(class_5281 world, int flag) {
        return this.place(world, (Long)this.posList.getFirst(), flag);
    }

    public boolean place(class_5281 world, int index, int flag) {
        return this.place(world, this.posList.getLong(index), flag);
    }

    public boolean placeAll(class_5281 worldAccess) {
        boolean placed = true;
        LongListIterator longListIterator = this.posList.iterator();
        while (longListIterator.hasNext()) {
            long pos = (Long)longListIterator.next();
            if (this.place(worldAccess, pos) || !placed) continue;
            placed = false;
        }
        return placed;
    }

    public boolean placeLastNDelete(class_5281 world) {
        return this.place(world, (Long)this.posList.removeLast());
    }

    public boolean placeNDelete(class_5281 world, int index) {
        return this.place(world, this.posList.removeLong(index));
    }

    public boolean placeNDelete(class_5281 world, int index, int flag) {
        return this.place(world, this.posList.removeLong(index), flag);
    }

    public boolean placeAllNDelete(class_5281 worldAccess) {
        boolean placed = this.placeAll(worldAccess);
        this.posList.clear();
        return placed;
    }

    public boolean placeAllNDelete(class_5281 worldAccess, int flag) {
        boolean placed = this.placeAll(worldAccess, flag);
        this.posList.clear();
        return placed;
    }

    private boolean place(class_5281 world, long pos) {
        boolean placed;
        if (!this.init) {
            this.init(world);
        }
        if ((placed = this.place(world, pos, 16)) && this.markDirty) {
            this.chunkManager.method_14128(LongPosHelper.decodeBlockPos(pos));
        }
        return placed;
    }

    private boolean place(class_5281 world, long pos, int flags) {
        class_2338 pos1 = LongPosHelper.decodeBlockPos(pos);
        class_2680 state = world.method_8320(pos1);
        if (this.ruler != null) {
            return BlockPlaceUtil.place(world, pos1, this.dataKey, this.ruler, flags);
        }
        return state.method_26215() && BlockPlaceUtil.place(world, pos1, this.dataKey, null, flags);
    }

    public JsonObject toJson(class_1923 chunkPos) {
        return this.toJson(new class_1923(0, 0), chunkPos);
    }

    public JsonObject toJson(class_1923 offset, class_1923 chunkPos) {
        Gson gson = new Gson();
        JsonObject jsonObject = new JsonObject();
        int offsetX = offset.field_9181 << 4;
        int offsetZ = offset.field_9180 << 4;
        int chunkMinX = chunkPos.field_9181 << 4;
        int chunkMinZ = chunkPos.field_9180 << 4;
        jsonObject.addProperty("state", this.dataKey.getState().toString());
        if (this.ruler != null) {
            jsonObject.addProperty("force", Boolean.valueOf(this.ruler.isForce()));
            jsonObject.add("overriddenBlock", (JsonElement)gson.toJsonTree(this.ruler.getOverriddenBlocks()).getAsJsonArray());
        }
        if (this.dataKey.getTag() != null) {
            jsonObject.addProperty("tag", this.dataKey.getTag().toString());
        }
        this.addCustomProperty(jsonObject);
        int size = this.size();
        int[] compactPositions = new int[size];
        for (int i = 0; i < size; ++i) {
            int compactPos;
            class_2338 pos = LongPosHelper.decodeBlockPos(this.posList.getLong(i));
            int relX = pos.method_10263() - chunkMinX + offsetX;
            int relZ = pos.method_10260() - chunkMinZ + offsetZ;
            int relY = pos.method_10264();
            if (relX < -1024 || relX > 1023 || relZ < -1024 || relZ > 1023) {
                throw new IllegalArgumentException("pos out of range: " + String.valueOf(pos));
            }
            compactPositions[i] = compactPos = (relX & 0x7FF) << 21 | relY + 512 << 11 | relZ & 0x7FF;
        }
        jsonObject.add("positions", (JsonElement)gson.toJsonTree((Object)compactPositions).getAsJsonArray());
        return jsonObject;
    }

    public void addCustomProperty(JsonObject json) {
    }

    public void placeJson(class_1923 chunkPos) {
        this.toJson(new class_1923(0, 0), chunkPos);
    }

    public void placeJson(class_5281 world, class_1923 offset, class_1923 chunkPos) {
        Gson gson = new Gson();
        chunkPos = new class_1923(chunkPos.field_9181 + offset.field_9181, chunkPos.field_9180 + offset.field_9180);
        Path path = EwcFolderData.getNVerifyDataDir(world, chunkPos);
        JsonObject jsonObj = this.toJson(offset, chunkPos);
        if (path == null) {
            return;
        }
        try {
            Files.writeString(path, (CharSequence)gson.toJson((JsonElement)jsonObj), new OpenOption[0]);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    public void init(class_5281 world) {
        MinecraftServer server = world.method_8503();
        if (server != null && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.chunkManager = serverWorld.method_14178();
            this.markDirty = true;
        }
    }
}

