/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata.blocklist;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.Ewc;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockList;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.sorter.BlockSorter;
import net.rodofire.easierworldcreator.util.BlockStateUtil;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import net.rodofire.easierworldcreator.util.file.FileUtil;

public class BlockListHelper {
    @SafeVarargs
    public static List<BlockList> combineNBlockList(List<BlockList> ... lists) {
        if (lists.length == 0) {
            return new ArrayList<BlockList>();
        }
        if (lists.length == 1) {
            return new ArrayList<BlockList>(lists[0]);
        }
        return ((Stream)Arrays.stream(lists).parallel()).reduce(new ArrayList(), (list1, list2) -> {
            ArrayList<BlockList> result = new ArrayList<BlockList>((Collection<BlockList>)list1);
            BlockListHelper.combine2BlockList(result, list2);
            return result;
        });
    }

    public static BlockListManager getSorted(List<BlockList> blockList, BlockSorter sorter) {
        BlockListManager sortedList = new BlockListManager(blockList);
        sorter.sortInsideBlockList(sortedList);
        return sortedList;
    }

    public static void combine2BlockList(List<BlockList> defaultBlockList1, List<BlockList> defaultBlockList2) {
        HashMap<class_2680, Integer> blockStateIndexMap = new HashMap<class_2680, Integer>();
        int i = 0;
        for (BlockList list : defaultBlockList1) {
            blockStateIndexMap.put(list.getState(), i++);
        }
        for (BlockList list : defaultBlockList2) {
            class_2680 state = list.getState();
            if (blockStateIndexMap.containsKey(state)) {
                int index = (Integer)blockStateIndexMap.get(state);
                defaultBlockList1.get(index).addAllPos(list.getPosList());
                continue;
            }
            defaultBlockList1.add(list);
        }
    }

    public static BlockListManager fromJsonPath(class_5281 world, Path path) {
        int chunkZ;
        int chunkX;
        String fileName = path.getParent().getFileName().toString();
        Pattern pattern = Pattern.compile("chunk_(-?\\d+)_(-?\\d+)$");
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.matches()) {
            chunkX = Integer.parseInt(matcher.group(1));
            chunkZ = Integer.parseInt(matcher.group(2));
        } else {
            chunkZ = 0;
            chunkX = 0;
        }
        if (path.toString().endsWith(".json")) {
            JsonArray jsonArray = (JsonArray)new Gson().fromJson(FileUtil.loadJson(path), JsonArray.class);
            if (jsonArray == null) {
                return null;
            }
            return BlockListHelper.fromJson(world, jsonArray, new class_1923(chunkX, chunkZ));
        }
        return null;
    }

    public static BlockListManager fromJson(class_5281 worldAccess, JsonArray jsonArray, class_1923 chunkPos) {
        BlockListManager manager = new BlockListManager();
        Gson gson = new Gson();
        for (JsonElement jsonElement : jsonArray) {
            BlockList blockList = new BlockList();
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            class_2680 state = BlockStateUtil.parseBlockState(worldAccess, jsonObject.get("state").getAsString());
            blockList.setState(state);
            if (jsonObject.has("force")) {
                boolean force = jsonObject.get("force").getAsBoolean();
                blockList.ruler.setForce(force);
            }
            if (jsonObject.has("overriddenBlock")) {
                Set overriddenBlocks = (Set)gson.fromJson(jsonObject.get("overriddenBlock"), new TypeToken<Set<class_2248>>(){}.getType());
                blockList.ruler.setOverriddenBlocks(overriddenBlocks);
            }
            if (jsonObject.has("tag")) {
                String tagString = jsonObject.get("tag").getAsString();
                try {
                    class_2487 tag = class_2522.method_10718((String)tagString);
                    blockList.setTag(tag);
                }
                catch (Exception e) {
                    Ewc.LOGGER.info("cannot parse NbtCompound");
                    e.fillInStackTrace();
                }
            }
            JsonArray positionsArray = jsonObject.getAsJsonArray("positions");
            int[] compactPositions = (int[])gson.fromJson((JsonElement)positionsArray, int[].class);
            int chunkMinX = chunkPos.field_9181 << 4;
            int chunkMinZ = chunkPos.field_9180 << 4;
            for (int compactPos : compactPositions) {
                int relX = compactPos >> 21 & 0x7FF;
                int relY = (compactPos >> 11 & 0x3FF) - 512;
                int relZ = compactPos & 0x7FF;
                if (relX >= 1024) {
                    relX -= 2048;
                }
                if (relZ >= 1024) {
                    relZ -= 2048;
                }
                int x = relX + chunkMinX;
                int y = relY;
                int z = relZ + chunkMinZ;
                blockList.addPos(LongPosHelper.encodeBlockPos(x, y, z));
            }
            manager.put(blockList);
        }
        return manager;
    }
}

