/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata.blocklist;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.rodofire.easierworldcreator.blockdata.BlockDataKey;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockList;
import net.rodofire.easierworldcreator.blockdata.blocklist.OrderedBlockListManager;
import net.rodofire.easierworldcreator.blockdata.sorter.BlockSorter;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import net.rodofire.easierworldcreator.util.file.EwcFolderData;

public class BlockListManager {
    protected List<BlockList> blockLists = new ArrayList<BlockList>();
    protected List<BlockDataKey> stateIndexes = new ArrayList<BlockDataKey>();
    protected Object2ShortOpenHashMap<BlockDataKey> blockDataMap = new Object2ShortOpenHashMap();

    public BlockListManager(BlockListManager comparator) {
        this.blockLists = comparator.blockLists;
        this.stateIndexes = comparator.stateIndexes;
        this.blockDataMap = comparator.blockDataMap;
    }

    public BlockListManager(List<BlockList> blockList) {
        this.put(blockList);
    }

    public BlockListManager(BlockList blockList) {
        this.put(blockList);
    }

    public BlockListManager() {
    }

    public BlockList getBlockList(int index) {
        return this.blockLists.get(index);
    }

    public List<BlockList> getAllBlockList() {
        return this.blockLists;
    }

    public BlockList getFirstBlockList() {
        return this.blockLists.getFirst();
    }

    public BlockList getLastBlockList() {
        return this.blockLists.getLast();
    }

    public class_2680 getState(int index) {
        return this.stateIndexes.get(index).getState();
    }

    public short size() {
        return (short)this.blockLists.size();
    }

    public int totalSize() {
        int sum = 0;
        for (BlockList blockList : this.blockLists) {
            sum += blockList.size();
        }
        return sum;
    }

    public int stateSize() {
        return this.stateIndexes.size();
    }

    public BlockListManager put(class_2680 state, class_2487 tag, LongArrayList pos) {
        BlockDataKey blockData = new BlockDataKey(state, tag);
        if (this.blockDataMap.containsKey((Object)blockData)) {
            short index = this.blockDataMap.getShort((Object)blockData);
            this.blockLists.get(index).addAllPos(pos);
            return this;
        }
        short index = this.size();
        this.blockDataMap.put((Object)blockData, index);
        this.blockLists.add(new BlockList(state, tag, pos));
        return this;
    }

    public BlockListManager put(class_2680 state, class_2487 tag, long pos) {
        return this.put(state, tag, LongArrayList.of((long[])new long[]{pos}));
    }

    public BlockListManager put(class_2680 state, class_2487 tag, List<class_2338> posList) {
        return this.put(state, tag, LongPosHelper.encodeBlockPos(posList));
    }

    public BlockListManager put(class_2680 state, class_2487 tag, class_2338 pos) {
        return this.put(state, tag, LongArrayList.of((long[])new long[]{LongPosHelper.encodeBlockPos(pos)}));
    }

    public BlockListManager put(class_2680 state, LongArrayList pos) {
        return this.put(state, null, pos);
    }

    public BlockListManager put(class_2680 state, long pos) {
        return this.put(state, null, LongArrayList.of((long[])new long[]{pos}));
    }

    public BlockListManager put(class_2680 state, List<class_2338> posList) {
        return this.put(state, null, LongPosHelper.encodeBlockPos(posList));
    }

    public BlockListManager put(class_2680 state, class_2338 pos) {
        return this.put(state, null, LongArrayList.of((long[])new long[]{LongPosHelper.encodeBlockPos(pos)}));
    }

    public BlockListManager put(BlockList[] blockLists) {
        for (BlockList blockList : blockLists) {
            this.put(blockList);
        }
        return this;
    }

    public BlockListManager put(List<BlockList> blockLists) {
        for (BlockList blockList : blockLists) {
            this.put(blockList);
        }
        return this;
    }

    public BlockListManager put(BlockList blockList) {
        BlockDataKey blockData = blockList.getBlockData();
        if (this.blockDataMap.containsKey((Object)blockData)) {
            short index = this.blockDataMap.getShort((Object)blockData);
            this.blockLists.get(index).addAllPos(blockList.getPosList());
            return this;
        }
        short index = this.size();
        this.blockDataMap.put((Object)blockData, index);
        this.stateIndexes.add(blockData);
        this.blockLists.add(blockList);
        return this;
    }

    public BlockListManager put(BlockListManager manager) {
        for (BlockList blockList : manager.blockLists) {
            this.put(blockList);
        }
        return this;
    }

    public OrderedBlockListManager getOrdered() {
        return new OrderedBlockListManager(this);
    }

    public OrderedBlockListManager getOrdered(BlockSorter sorter) {
        return sorter.sortOrderedBlockList(new OrderedBlockListManager(this));
    }

    public String toString() {
        return this.blockLists.toString();
    }

    public BlockListManager sort(BlockSorter sorter) {
        sorter.sortInsideBlockList(this);
        return this;
    }

    public void clear() {
        this.blockLists.clear();
        this.stateIndexes.clear();
        this.blockDataMap.clear();
    }

    public boolean placeAll(class_5281 worldAccess) {
        boolean placed = true;
        for (BlockList blockList : this.blockLists) {
            if (blockList.placeAll(worldAccess)) continue;
            placed = false;
        }
        return placed;
    }

    public boolean placeAllNDelete(class_5281 worldAccess) {
        boolean placed = true;
        for (BlockList blockList : this.blockLists) {
            if (blockList.placeAllNDelete(worldAccess)) continue;
            placed = false;
        }
        this.clear();
        return placed;
    }

    public boolean placeAll(class_5281 worldAccess, int flag) {
        boolean placed = true;
        for (BlockList blockList : this.blockLists) {
            if (blockList.placeAll(worldAccess, flag)) continue;
            placed = false;
        }
        return placed;
    }

    public boolean placeAllNDelete(class_5281 worldAccess, int flag) {
        boolean placed = true;
        for (BlockList blockList : this.blockLists) {
            if (blockList.placeAllNDelete(worldAccess, flag)) continue;
            placed = false;
        }
        this.clear();
        return placed;
    }

    public JsonArray toJson(class_1923 chunkPos) {
        return this.toJson(chunkPos, new class_1923(0, 0));
    }

    public JsonArray toJson(class_1923 chunkPos, class_1923 offset) {
        JsonArray jsonArray = new JsonArray();
        ForkJoinPool pool = new ForkJoinPool(Math.min(this.blockLists.size(), Runtime.getRuntime().availableProcessors() / 2));
        ArrayList<CompletableFuture<JsonObject>> futures = new ArrayList<CompletableFuture<JsonObject>>();
        for (BlockList blockList : this.blockLists) {
            CompletableFuture<JsonObject> future = CompletableFuture.supplyAsync(() -> blockList.toJson(offset, chunkPos), pool);
            futures.add(future);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        for (CompletableFuture completableFuture : futures) {
            try {
                jsonArray.add((JsonElement)completableFuture.get());
            }
            catch (InterruptedException | ExecutionException e) {
                e.fillInStackTrace();
            }
        }
        pool.shutdown();
        return jsonArray;
    }

    public void placeJson(class_5281 worldAccess, class_1923 chunkPos) {
        this.placeJson(worldAccess, chunkPos, new class_1923(0, 0), "custom_feature_" + class_5819.method_43047().method_43055());
    }

    public void placeJson(class_5281 worldAccess, class_1923 chunkPos, class_1923 offset, String name) {
        Gson gson = new Gson();
        chunkPos = new class_1923(chunkPos.field_9181 + offset.field_9181, chunkPos.field_9180 + offset.field_9180);
        Path path = EwcFolderData.getNVerifyDataDir(worldAccess, chunkPos);
        JsonArray jsonArray = this.toJson(chunkPos, offset);
        if (path == null) {
            return;
        }
        try {
            Files.writeString(path.resolve(name + ".json"), (CharSequence)gson.toJson((JsonElement)jsonArray), new OpenOption[0]);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }
}

