/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata.blocklist;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockList;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.OrderedBlockListManager;
import net.rodofire.easierworldcreator.blockdata.sorter.BlockSorter;
import net.rodofire.easierworldcreator.util.LongPosHelper;

public class DividedBlockListManager {
    private final Map<class_1923, BlockListManager> managers = new HashMap<class_1923, BlockListManager>();

    public DividedBlockListManager put(DividedBlockListManager manager) {
        for (Map.Entry<class_1923, BlockListManager> entry : manager.managers.entrySet()) {
            this.putWithoutVerification(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public DividedBlockListManager put(BlockList blockList) {
        class_2680 state = blockList.getState();
        LongListIterator longListIterator = blockList.getPosList().iterator();
        while (longListIterator.hasNext()) {
            long pos = (Long)longListIterator.next();
            this.managers.computeIfAbsent(LongPosHelper.getChunkPos(pos), k -> new BlockListManager(new BlockList())).put(state, pos);
        }
        return this;
    }

    public DividedBlockListManager putWithoutVerification(class_1923 pos, BlockList blockList) {
        this.managers.computeIfAbsent(pos, k -> new BlockListManager()).put(blockList);
        return this;
    }

    public DividedBlockListManager put(BlockListManager comparator) {
        for (BlockList blockList : comparator.getAllBlockList()) {
            this.put(blockList);
        }
        return this;
    }

    public DividedBlockListManager putWithoutVerification(class_1923 pos, BlockListManager manager) {
        this.managers.computeIfAbsent(pos, k -> new BlockListManager()).put(manager);
        return this;
    }

    public DividedBlockListManager put(class_2680 state, class_2487 tag, LongArrayList posList) {
        LongListIterator longListIterator = posList.iterator();
        while (longListIterator.hasNext()) {
            long pos = (Long)longListIterator.next();
            this.put(state, tag, pos);
        }
        return this;
    }

    public DividedBlockListManager put(class_2680 state, LongArrayList pos) {
        LongListIterator longListIterator = pos.iterator();
        while (longListIterator.hasNext()) {
            long po = (Long)longListIterator.next();
            this.put(state, null, po);
        }
        return this;
    }

    public DividedBlockListManager put(class_2680 state, long pos) {
        return this.put(state, null, pos);
    }

    public DividedBlockListManager put(class_2680 state, class_2487 tag, long pos) {
        this.managers.computeIfAbsent(LongPosHelper.getChunkPos(pos), k -> new BlockListManager()).put(state, tag, pos);
        return this;
    }

    public DividedBlockListManager put(class_2680 state, class_2487 tag, List<class_2338> posList) {
        for (class_2338 pos : posList) {
            this.put(state, tag, LongPosHelper.encodeBlockPos(pos));
        }
        return this;
    }

    public DividedBlockListManager put(class_2680 state, List<class_2338> posList) {
        for (class_2338 pos : posList) {
            this.put(state, null, LongPosHelper.encodeBlockPos(pos));
        }
        return this;
    }

    public DividedBlockListManager put(class_2680 state, class_2338 pos) {
        return this.put(state, null, LongPosHelper.encodeBlockPos(pos));
    }

    public DividedBlockListManager put(class_2680 state, class_2487 tag, class_2338 pos) {
        return this.put(state, tag, LongPosHelper.encodeBlockPos(pos));
    }

    public DividedBlockListManager putWithoutVerification(class_2680 state, class_2487 tag, LongArrayList pos) {
        this.managers.computeIfAbsent(LongPosHelper.getChunkPos((Long)pos.getFirst()), k -> new BlockListManager()).put(state, tag, pos);
        return this;
    }

    public DividedBlockListManager putWithoutVerification(class_2680 state, LongArrayList pos) {
        return this.putWithoutVerification(state, null, pos);
    }

    public DividedBlockListManager putWithoutVerification(class_2680 state, long pos) {
        return this.putWithoutVerification(state, null, LongArrayList.of((long[])new long[]{pos}));
    }

    public DividedBlockListManager putWithoutVerification(class_2680 state, class_2487 tag, long pos) {
        return this.putWithoutVerification(state, tag, LongArrayList.of((long[])new long[]{pos}));
    }

    public DividedBlockListManager putWithoutVerification(class_2680 state, class_2487 tag, List<class_2338> pos) {
        return this.putWithoutVerification(state, tag, LongPosHelper.encodeBlockPos(pos));
    }

    public DividedBlockListManager putWithoutVerification(class_2680 state, List<class_2338> pos) {
        return this.putWithoutVerification(state, null, LongPosHelper.encodeBlockPos(pos));
    }

    public DividedBlockListManager putWithoutVerification(class_2680 state, class_2338 pos) {
        return this.putWithoutVerification(state, null, LongArrayList.of((long[])new long[]{LongPosHelper.encodeBlockPos(pos)}));
    }

    public DividedBlockListManager putWithoutVerification(class_2680 state, class_2487 tag, class_2338 pos) {
        return this.putWithoutVerification(state, tag, LongArrayList.of((long[])new long[]{LongPosHelper.encodeBlockPos(pos)}));
    }

    public BlockListManager getManager(class_1923 pos) {
        return this.managers.get(pos);
    }

    public BlockListManager[] getAllManager() {
        return (BlockListManager[])this.managers.values().toArray(BlockListManager[]::new);
    }

    public void clear() {
        this.managers.clear();
    }

    public boolean contains(class_1923 pos) {
        return this.managers.containsKey(pos);
    }

    public Set<class_1923> getChunkPos() {
        return this.managers.keySet();
    }

    public boolean placeAll(class_5281 world) {
        boolean place = true;
        for (BlockListManager manager : this.managers.values()) {
            if (manager.placeAll(world)) continue;
            place = false;
        }
        return place;
    }

    public boolean placeAllNDelete(class_5281 world) {
        boolean place = true;
        for (BlockListManager manager : this.managers.values()) {
            if (manager.placeAll(world)) continue;
            place = false;
        }
        this.clear();
        return place;
    }

    public OrderedBlockListManager getOrdered() {
        OrderedBlockListManager manager = new OrderedBlockListManager();
        for (BlockListManager manager1 : this.managers.values()) {
            manager.put(manager1.getOrdered());
        }
        return manager;
    }

    public OrderedBlockListManager getOrdered(BlockSorter sorter) {
        OrderedBlockListManager manager = new OrderedBlockListManager();
        for (BlockListManager manager1 : this.managers.values()) {
            manager.put(manager1.getOrdered(sorter));
        }
        return manager;
    }

    public void placeJson(class_5281 worldAccess, String name) {
        for (Map.Entry<class_1923, BlockListManager> entry : this.managers.entrySet()) {
            entry.getValue().placeJson(worldAccess, entry.getKey(), new class_1923(0, 0), name);
        }
    }

    public void placeJson(class_5281 worldAccess, String name, class_1923 offset) {
        for (Map.Entry<class_1923, BlockListManager> entry : this.managers.entrySet()) {
            entry.getValue().placeJson(worldAccess, entry.getKey(), offset, name);
        }
    }

    public void putWithoutVerification(BlockListManager manager) {
        class_1923 pos = LongPosHelper.getChunkPos(manager.getFirstBlockList().getFirstLongPos());
        manager.blockLists.forEach(blockList -> this.putWithoutVerification(pos, (BlockList)blockList));
    }
}

