/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata.blocklist;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongShortImmutablePair;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import net.rodofire.easierworldcreator.blockdata.BlockDataKey;
import net.rodofire.easierworldcreator.blockdata.StructurePlacementRuleManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockList;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.util.BlockPlaceUtil;
import net.rodofire.easierworldcreator.util.LongPosHelper;

public class OrderedBlockListManager {
    List<BlockDataKey> state = new ArrayList<BlockDataKey>();
    Object2ShortOpenHashMap<BlockDataKey> blockDataMap = new Object2ShortOpenHashMap();
    Short2ReferenceOpenHashMap<StructurePlacementRuleManager> ruler = new Short2ReferenceOpenHashMap();
    List<LongShortImmutablePair> posListOptimized = new ArrayList<LongShortImmutablePair>();
    class_3215 chunkManager;
    boolean markDirty = false;
    boolean init = false;

    public OrderedBlockListManager(OrderedBlockListManager manager) {
        this.state = manager.state;
        this.ruler = manager.ruler;
        this.blockDataMap = manager.blockDataMap;
        this.posListOptimized = manager.posListOptimized;
    }

    public OrderedBlockListManager(BlockListManager manager) {
        this.posListOptimized = new ArrayList<LongShortImmutablePair>(manager.totalSize());
        for (BlockList blockList : manager.blockLists) {
            short index;
            BlockDataKey blockData = blockList.getBlockData();
            if (!this.blockDataMap.containsKey((Object)blockData)) {
                index = (short)this.blockDataMap.size();
                this.blockDataMap.put((Object)blockData, index);
                this.state.add(blockData);
            }
            index = this.blockDataMap.getShort((Object)blockData);
            LongArrayList posList = blockList.getPosList();
            LongListIterator longListIterator = posList.iterator();
            while (longListIterator.hasNext()) {
                long pos = (Long)longListIterator.next();
                this.posListOptimized.add(new LongShortImmutablePair(pos, index));
            }
        }
    }

    public OrderedBlockListManager(class_2680 state, List<class_2338> posList) {
    }

    public OrderedBlockListManager(Map<class_2680, List<class_2338>> info) {
    }

    public OrderedBlockListManager() {
    }

    public boolean arePosEmpty() {
        return this.posListOptimized.isEmpty();
    }

    public long removeBlockPos(int index) {
        return this.posListOptimized.remove(index).leftLong();
    }

    public class_3545<Long, class_2680> removeBlockPosPair(int index) {
        LongShortImmutablePair pos = this.posListOptimized.remove(index);
        return new class_3545((Object)pos.leftLong(), (Object)this.state.get(pos.rightShort()).getState());
    }

    public long removeFirstPos() {
        return this.removeBlockPos(0);
    }

    public long removeLastPos() {
        return this.removeBlockPos(this.posSize() - 1);
    }

    public class_3545<Long, class_2680> removeFirstBlockPos() {
        return this.removeBlockPosPair(0);
    }

    public class_3545<Long, class_2680> removeLastBlockPosPair() {
        return this.removeBlockPosPair(this.posSize() - 1);
    }

    public void clear() {
        this.state.clear();
        this.posListOptimized.clear();
    }

    public List<LongShortImmutablePair> getPosList() {
        return this.posListOptimized;
    }

    public long getBlockPos(int index) {
        return this.posListOptimized.get(index).leftLong();
    }

    public long getFirstBlockPos() {
        return this.posListOptimized.getFirst().leftLong();
    }

    public long getLastBlockPos() {
        return this.posListOptimized.getLast().leftLong();
    }

    public long getRandomBlockPos() {
        return this.getBlockPos(class_5819.method_43047().method_43048(this.posSize() - 1));
    }

    public long getRandomBlockPos(class_5819 random) {
        return this.getBlockPos(random.method_43048(this.posSize() - 1));
    }

    public int posSize() {
        return this.posListOptimized.size();
    }

    public int stateSize() {
        return this.state.size();
    }

    public boolean isPosEmpty() {
        return this.posSize() == 0;
    }

    public boolean isStateEmpty() {
        return this.stateSize() == 0;
    }

    public class_2680 getBlockState(short index) {
        return this.state.get(index).getState();
    }

    public BlockDataKey get(int index) {
        return this.state.get(index);
    }

    public class_2487 getCompound(short index) {
        return this.state.get(index).getTag();
    }

    public class_2680 getFirstBlockState() {
        return this.state.getFirst().getState();
    }

    public BlockDataKey getFirst() {
        return this.state.getFirst();
    }

    public class_2487 getFirstCompound() {
        return this.state.getFirst().getTag();
    }

    public class_2680 getLastBlockState() {
        return this.state.getLast().getState();
    }

    public BlockDataKey getLast() {
        return this.state.getLast();
    }

    public class_2487 getLastCompound() {
        return this.state.getLast().getTag();
    }

    public void setPosList(List<LongShortImmutablePair> posList) {
        this.posListOptimized = posList;
    }

    public void put(OrderedBlockListManager comparator) {
        ShortIterator shortIterator = comparator.blockDataMap.values().iterator();
        while (shortIterator.hasNext()) {
            short idx = (Short)shortIterator.next();
            BlockDataKey blockData = comparator.state.get(idx);
            StructurePlacementRuleManager rule = (StructurePlacementRuleManager)comparator.ruler.get(idx);
            if (this.blockDataMap.containsKey((Object)blockData)) continue;
            short index = (short)this.blockDataMap.size();
            this.blockDataMap.put((Object)blockData, index);
            this.state.add(blockData);
            if (rule == null) continue;
            this.ruler.put(index, (Object)rule);
        }
        for (LongShortImmutablePair pos : comparator.posListOptimized) {
            this.posListOptimized.add(new LongShortImmutablePair(pos.leftLong(), this.blockDataMap.getShort((Object)comparator.state.get(pos.rightShort()))));
        }
    }

    public OrderedBlockListManager put(BlockList blockList) {
        return this.put(blockList.getState(), (class_2487)blockList.getTag().orElse(null), blockList.getPosList());
    }

    public OrderedBlockListManager put(class_2680 state, class_2487 tag, LongArrayList posList) {
        short index;
        BlockDataKey blockData = new BlockDataKey(state, tag);
        if (!this.blockDataMap.containsKey((Object)blockData)) {
            index = (short)this.blockDataMap.size();
            this.blockDataMap.put((Object)blockData, index);
            this.state.add(blockData);
        }
        index = this.blockDataMap.getShort((Object)blockData);
        LongListIterator longListIterator = posList.iterator();
        while (longListIterator.hasNext()) {
            long pos = (Long)longListIterator.next();
            this.posListOptimized.add(new LongShortImmutablePair(pos, index));
        }
        return this;
    }

    public OrderedBlockListManager put(class_2680 state, class_2487 tag, long pos) {
        return this.put(state, tag, LongArrayList.of((long[])new long[]{pos}));
    }

    public OrderedBlockListManager put(class_2680 state, class_2487 tag, List<class_2338> posList) {
        return this.put(state, tag, LongPosHelper.encodeBlockPos(posList));
    }

    public OrderedBlockListManager put(class_2680 state, class_2487 tag, class_2338 pos) {
        return this.put(state, tag, LongArrayList.of((long[])new long[]{LongPosHelper.encodeBlockPos(pos)}));
    }

    public OrderedBlockListManager put(class_2680 state, LongArrayList pos) {
        return this.put(state, null, pos);
    }

    public OrderedBlockListManager put(class_2680 state, long pos) {
        return this.put(state, null, LongArrayList.of((long[])new long[]{pos}));
    }

    public OrderedBlockListManager put(class_2680 state, List<class_2338> posList) {
        return this.put(state, null, LongPosHelper.encodeBlockPos(posList));
    }

    public OrderedBlockListManager put(class_2680 state, class_2338 pos) {
        return this.put(state, null, LongArrayList.of((long[])new long[]{LongPosHelper.encodeBlockPos(pos)}));
    }

    public BlockDataKey getFromPosIndex(int index) {
        return this.state.get(this.posListOptimized.get(index).rightShort());
    }

    public Optional<StructurePlacementRuleManager> getPlacementRuleFromPosIndex(int index) {
        return Optional.ofNullable((StructurePlacementRuleManager)this.ruler.get(this.posListOptimized.get(index).rightShort()));
    }

    public boolean placeLast(class_5281 world) {
        return this.place(world, this.posSize() - 1);
    }

    public boolean placeFirst(class_5281 world) {
        return this.place(world, 0);
    }

    public boolean placeAll(class_5281 worldAccess) {
        boolean placed = true;
        boolean markdirty = false;
        class_3215 chunkManager = null;
        MinecraftServer server = worldAccess.method_8503();
        if (server != null && worldAccess instanceof class_3218) {
            class_3218 world = (class_3218)worldAccess;
            chunkManager = world.method_14178();
            markdirty = true;
        }
        for (int i = 0; i < this.posListOptimized.size(); ++i) {
            if (!this.place(worldAccess, i)) {
                placed = false;
                continue;
            }
            if (!markdirty) continue;
            chunkManager.method_14128(LongPosHelper.decodeBlockPos(this.posListOptimized.get(i).leftLong()));
        }
        return placed;
    }

    public boolean placeLastNDelete(class_5281 world) {
        boolean placed = this.place(world, this.posSize() - 1);
        this.posListOptimized.removeLast();
        return placed;
    }

    public boolean placeNDelete(class_5281 world, int index) {
        return this.place(world, index);
    }

    public boolean placeAllNDelete(class_5281 worldAccess) {
        boolean placed = this.placeAll(worldAccess);
        this.posListOptimized.clear();
        return placed;
    }

    public boolean place(class_5281 world, int index) {
        boolean placed;
        if (!this.init) {
            this.init(world);
        }
        if ((placed = this.place(world, index, 16)) && this.markDirty) {
            this.chunkManager.method_14128(LongPosHelper.decodeBlockPos(this.posListOptimized.get(index).leftLong()));
        }
        return placed;
    }

    public boolean place(class_5281 world, int index, int flag) {
        LongShortImmutablePair pair = this.posListOptimized.get(index);
        class_2338 pos = LongPosHelper.decodeBlockPos(pair.leftLong());
        class_2680 worldState = world.method_8320(pos);
        BlockDataKey data = this.state.get(pair.rightShort());
        return worldState.method_26215() && BlockPlaceUtil.place(world, pos, data, (StructurePlacementRuleManager)this.ruler.get((short)index), flag);
    }

    public void init(class_5281 world) {
        MinecraftServer server = world.method_8503();
        if (server != null && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.chunkManager = serverWorld.method_14178();
            this.markDirty = true;
        }
    }
}

