/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata.layer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.rodofire.easierworldcreator.blockdata.StructurePlacementRuleManager;
import net.rodofire.easierworldcreator.shape.block.placer.LayerPlacer;

public class BlockLayer {
    private List<class_2680> blockStates;
    List<Short> chances;
    private int depth = 1;
    private StructurePlacementRuleManager ruler;
    private LayerPlacer placer;

    public BlockLayer(LayerPlacer placer, List<class_2680> states, int depth, StructurePlacementRuleManager ruler) {
        this.blockStates = new ArrayList<class_2680>(states);
        this.chances = new ArrayList<Short>();
        for (int i = 0; i < states.size(); ++i) {
            this.chances.add((short)1);
        }
        this.depth = depth;
        this.ruler = ruler;
        this.placer = placer;
    }

    public BlockLayer(LayerPlacer placer, List<class_2680> states, List<Short> chances, int depth, StructurePlacementRuleManager ruler) {
        this.blockStates = new ArrayList<class_2680>(states);
        this.chances = new ArrayList<Short>();
        for (int i = 0; i < states.size(); ++i) {
            this.chances.add(chances.get(i));
        }
        this.depth = depth;
        this.ruler = ruler;
        this.placer = placer;
    }

    public BlockLayer(LayerPlacer placer, List<class_2680> states, StructurePlacementRuleManager ruler) {
        this.blockStates = new ArrayList<class_2680>(states);
        this.chances = new ArrayList<Short>();
        for (int i = 0; i < states.size(); ++i) {
            this.chances.add((short)1);
        }
        this.ruler = ruler;
        this.placer = placer;
    }

    public BlockLayer(LayerPlacer placer, class_2680 state, int depth, StructurePlacementRuleManager ruler) {
        this.blockStates = new ArrayList<class_2680>();
        this.blockStates.add(state);
        this.chances = new ArrayList<Short>();
        this.chances.add((short)1);
        this.depth = depth;
        this.ruler = ruler;
        this.placer = placer;
    }

    public BlockLayer(LayerPlacer placer, class_2680 state, StructurePlacementRuleManager ruler) {
        this.blockStates = new ArrayList<class_2680>();
        this.blockStates.add(state);
        this.chances = new ArrayList<Short>();
        this.chances.add((short)1);
        this.ruler = ruler;
        this.placer = placer;
    }

    public BlockLayer(LayerPlacer placer, List<class_2680> states, int depth) {
        this.blockStates = new ArrayList<class_2680>(states);
        this.chances = new ArrayList<Short>();
        for (int i = 0; i < states.size(); ++i) {
            this.chances.add((short)1);
        }
        this.depth = depth;
        this.placer = placer;
    }

    public BlockLayer(LayerPlacer placer, List<class_2680> states) {
        this.blockStates = new ArrayList<class_2680>(states);
        this.chances = new ArrayList<Short>();
        for (int i = 0; i < states.size(); ++i) {
            this.chances.add((short)1);
        }
        this.placer = placer;
    }

    public BlockLayer(LayerPlacer placer, List<class_2680> states, List<Short> chances) {
        this.blockStates = new ArrayList<class_2680>(states);
        this.chances = new ArrayList<Short>();
        for (int i = 0; i < states.size(); ++i) {
            this.chances.add(chances.get(i));
        }
        this.placer = placer;
    }

    public BlockLayer(LayerPlacer placer, class_2680 state, int depth) {
        this.blockStates = new ArrayList<class_2680>();
        this.blockStates.add(state);
        this.chances = new ArrayList<Short>();
        this.chances.add((short)1);
        this.depth = depth;
        this.placer = placer;
    }

    public BlockLayer(LayerPlacer placer, class_2680 state) {
        this.blockStates = new ArrayList<class_2680>();
        this.blockStates.add(state);
        this.chances = new ArrayList<Short>();
        this.chances.add((short)1);
        this.placer = placer;
    }

    public StructurePlacementRuleManager getRuler() {
        return this.ruler;
    }

    public void setRuler(StructurePlacementRuleManager ruler) {
        this.ruler = ruler;
    }

    public LayerPlacer getPlacer() {
        return this.placer;
    }

    public void setPlacer(LayerPlacer placer) {
        this.placer = placer;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void addDepth(int depth) {
        this.depth += depth;
    }

    public List<class_2680> getBlockStates() {
        ArrayList<class_2680> state = new ArrayList<class_2680>();
        for (int i = 0; i < this.blockStates.size(); ++i) {
            for (int j = 0; j < this.chances.get(i); ++j) {
                state.add(this.blockStates.get(i));
            }
        }
        return state;
    }

    public List<class_3545<class_2680, Short>> get() {
        ArrayList<class_3545<class_2680, Short>> list = new ArrayList<class_3545<class_2680, Short>>();
        for (int i = 0; i < this.blockStates.size(); ++i) {
            list.add((class_3545<class_2680, Short>)new class_3545((Object)this.blockStates.get(i), (Object)this.chances.get(i)));
        }
        return list;
    }

    public void setBlockStates(List<class_2680> blocks) {
        this.blockStates = new ArrayList<class_2680>(blocks);
        this.chances = new ArrayList<Short>();
        for (int i = 0; i < blocks.size(); ++i) {
            this.chances.add((short)1);
        }
    }

    public void addBlockState(class_2680 state) {
        this.blockStates.add(state);
        this.chances.add((short)1);
    }

    public void addBlockStates(List<class_2680> states) {
        this.blockStates.addAll(states);
        for (int i = 0; i < states.size(); ++i) {
            this.chances.add((short)1);
        }
    }

    public void addBlockState(class_2680 state, short chance) {
        this.blockStates.add(state);
        this.chances.add(chance);
    }

    public void addBlockStates(List<class_2680> states, List<Short> chances) {
        this.blockStates.addAll(states);
        for (int i = 0; i < states.size(); ++i) {
            this.chances.add(chances.get(i));
        }
    }

    public void removeBlockState(List<class_2680> state) {
        for (class_2680 blockState : state) {
            this.chances.remove(this.blockStates.indexOf(blockState));
        }
        this.blockStates.removeAll(state);
    }

    public void removeBlockState(class_2680 state) {
        this.chances.remove(this.blockStates.indexOf(state));
        this.blockStates.remove(state);
    }

    public void removeBlockState(int index) {
        this.chances.remove(index);
        this.blockStates.remove(index);
    }

    public int size() {
        return this.blockStates.size();
    }

    public String toString() {
        return "BlockLayer{blocks=" + String.valueOf(this.blockStates) + ", depth=" + this.depth + "}";
    }
}

