/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata.layer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2680;
import net.rodofire.easierworldcreator.blockdata.StructurePlacementRuleManager;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayer;
import net.rodofire.easierworldcreator.shape.block.placer.LayerPlacer;

public class BlockLayerManager {
    private List<BlockLayer> layers = new ArrayList<BlockLayer>();
    boolean repeatLayers = false;

    public BlockLayerManager(List<BlockLayer> layers) {
        this.layers = new ArrayList<BlockLayer>(layers);
    }

    public BlockLayerManager(BlockLayer ... layers) {
        this.layers.addAll(Arrays.stream(layers).toList());
    }

    public BlockLayerManager(BlockLayer layer) {
        this.layers = new ArrayList<BlockLayer>();
        this.layers.add(layer);
    }

    public BlockLayerManager(LayerPlacer placer, class_2680 state, short depth) {
        this.layers = new ArrayList<BlockLayer>();
        this.layers.add(new BlockLayer(placer, state, (int)depth));
    }

    public BlockLayerManager(LayerPlacer placer, List<class_2680> states, int depth, StructurePlacementRuleManager ruler) {
        this.layers.add(new BlockLayer(placer, states, depth, ruler));
    }

    public BlockLayerManager(LayerPlacer placer, List<class_2680> states, List<Short> chances, int depth, StructurePlacementRuleManager ruler) {
        this.layers.add(new BlockLayer(placer, states, chances, depth, ruler));
    }

    public BlockLayerManager(LayerPlacer placer, List<class_2680> states, StructurePlacementRuleManager ruler) {
        this.layers.add(new BlockLayer(placer, states, ruler));
    }

    public BlockLayerManager(LayerPlacer placer, class_2680 state, int depth, StructurePlacementRuleManager ruler) {
        this.layers.add(new BlockLayer(placer, state, depth, ruler));
    }

    public BlockLayerManager(LayerPlacer placer, class_2680 state, StructurePlacementRuleManager ruler) {
        this.layers.add(new BlockLayer(placer, state, ruler));
    }

    public BlockLayerManager(LayerPlacer placer, List<class_2680> states, int depth) {
        this.layers.add(new BlockLayer(placer, states, depth));
    }

    public BlockLayerManager(LayerPlacer placer, List<class_2680> states) {
        this.layers.add(new BlockLayer(placer, states));
    }

    public BlockLayerManager(LayerPlacer placer, List<class_2680> states, List<Short> chances) {
        this.layers.add(new BlockLayer(placer, states, chances));
    }

    public BlockLayerManager(LayerPlacer placer, class_2680 state, int depth) {
        this.layers.add(new BlockLayer(placer, state, depth));
    }

    public BlockLayerManager(LayerPlacer placer, class_2680 state) {
        this.layers.add(new BlockLayer(placer, state));
    }

    public List<BlockLayer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<BlockLayer> layers) {
        this.layers = new ArrayList<BlockLayer>(layers);
    }

    public void addLayer(BlockLayer layer) {
        this.layers.add(layer);
    }

    public void addBlockLayers(List<BlockLayer> layers) {
        this.layers.addAll(layers);
    }

    public BlockLayer get(int index) {
        if (index >= this.layers.size()) {
            index = this.repeatLayers ? (index %= this.layers.size()) : this.layers.size() - 1;
        }
        return this.layers.get(index);
    }

    public BlockLayer remove(int index) {
        return this.layers.remove(index);
    }

    public BlockLayer getFirstLayer() {
        return this.layers.getFirst();
    }

    public BlockLayer removeFirstLayer() {
        return this.layers.remove(0);
    }

    public BlockLayer getLastLayer() {
        return this.layers.get(this.size() - 1);
    }

    public BlockLayer removeLastLayer() {
        return this.layers.remove(this.size() - 1);
    }

    public void modifyBlocks(int index, List<class_2680> states) {
        this.layers.get(index).setBlockStates(states);
    }

    public void modifyDepth(int index, int depth) {
        this.layers.get(index).setDepth(depth);
    }

    public void modifyLayer(int index, BlockLayer layer) {
        this.layers.set(index, layer);
    }

    public int size() {
        return this.layers.size();
    }

    public boolean isEmpty() {
        return this.layers.isEmpty();
    }

    public boolean isRepeatLayers() {
        return this.repeatLayers;
    }

    public void setRepeatLayers(boolean repeatLayers) {
        this.repeatLayers = repeatLayers;
    }
}

