/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.blockdata.sorter;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongShortImmutablePair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockList;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.OrderedBlockListManager;
import net.rodofire.easierworldcreator.util.ListUtil;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import net.rodofire.easierworldcreator.util.WorldGenUtil;
import org.jetbrains.annotations.NotNull;

public class BlockSorter {
    private BlockSorterType type;
    private class_2338 centerPoint = new class_2338(0, 0, 0);
    private class_243 axisDirection = new class_243(-1.0, -1.0, 0.0);

    public BlockSorter(BlockSorterType type) {
        this.type = type;
    }

    public class_2338 getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(class_2338 centerPoint) {
        this.centerPoint = centerPoint;
    }

    public class_243 getAxisDirection() {
        return this.axisDirection;
    }

    public void setAxisDirection(class_243 axisDirection) {
        this.axisDirection = axisDirection;
    }

    public BlockSorterType getType() {
        return this.type;
    }

    public void setType(BlockSorterType type) {
        this.type = type;
    }

    public void setRandomSorter() {
        this.type = BlockSorterType.values()[class_5819.method_43047().method_43048(7)];
        if (this.type == BlockSorterType.ALONG_AXIS) {
            this.axisDirection = new class_243((double)(2.0f * class_5819.method_43047().method_43057() - 1.0f), (double)(2.0f * class_5819.method_43047().method_43057() - 1.0f), (double)(2.0f * class_5819.method_43047().method_43057() - 1.0f));
        }
    }

    public List<class_2338> sortBlockPos(List<class_2338> posList) {
        return switch (this.type.ordinal()) {
            case 2 -> {
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                yield posList.parallelStream().sorted(Comparator.comparingDouble(pos -> -WorldGenUtil.getDistance(this.centerPoint, pos))).toList();
            }
            case 3 -> {
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                yield posList.parallelStream().sorted(Comparator.comparingDouble(pos -> WorldGenUtil.getDistance(this.centerPoint, pos))).toList();
            }
            case 4 -> {
                this.centerPoint = ListUtil.getRandomElement(posList);
                yield posList.parallelStream().sorted(Comparator.comparingDouble(pos -> -WorldGenUtil.getDistance(this.centerPoint, pos))).toList();
            }
            case 5 -> {
                this.centerPoint = ListUtil.getRandomElement(posList);
                yield posList.parallelStream().sorted(Comparator.comparingDouble(pos -> WorldGenUtil.getDistance(this.centerPoint, pos))).toList();
            }
            case 8 -> {
                ArrayList<class_2338> copy = new ArrayList<class_2338>(posList);
                Collections.shuffle(copy);
                yield copy;
            }
            case 0 -> {
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                class_243 direction = this.axisDirection.method_1029();
                yield posList.parallelStream().sorted(Comparator.comparingDouble(pos -> (double)pos.method_10263() * direction.field_1352 + (double)pos.method_10264() * direction.field_1351 + (double)pos.method_10260() * direction.field_1350)).toList();
            }
            case 1 -> {
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                yield posList.parallelStream().sorted(Comparator.comparingDouble(pos -> {
                    class_243 axisPoint = this.centerPoint.method_46558();
                    class_243 axisDirection = this.axisDirection.method_1029();
                    class_243 blockPosition = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    class_243 pointToBlock = blockPosition.method_1020(axisPoint);
                    double projectionLength = pointToBlock.method_1026(axisDirection);
                    class_243 closestPointOnAxis = axisPoint.method_1019(axisDirection.method_1021(projectionLength));
                    return -WorldGenUtil.getDistance(class_2338.method_49638((class_2374)closestPointOnAxis), class_2338.method_49638((class_2374)axisPoint));
                })).toList();
            }
            case 10 -> posList;
            case 9 -> {
                ArrayList<class_2338> copy = new ArrayList<class_2338>(posList);
                Collections.reverse(copy);
                yield copy;
            }
            case 6 -> {
                class_243 axisPoint = this.centerPoint.method_46558();
                class_243 axisDirection = this.axisDirection.method_1029();
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                yield posList.parallelStream().sorted(Comparator.comparingDouble(pos -> {
                    class_243 blockVec = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    double distance = blockVec.method_1020(axisPoint).method_1026(axisDirection);
                    return -Math.abs(distance);
                })).toList();
            }
            case 7 -> {
                class_243 axisPoint = this.centerPoint.method_46558();
                class_243 axisDirection = this.axisDirection.method_1029();
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                yield posList.parallelStream().sorted(Comparator.comparingDouble(pos -> {
                    class_243 blockVec = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    double distance = blockVec.method_1020(axisPoint).method_1026(axisDirection);
                    return Math.abs(distance);
                })).toList();
            }
            default -> throw new IllegalStateException("Unexpected sorter value: " + String.valueOf((Object)this.type));
        };
    }

    public LongArrayList sortBlockPos(LongArrayList posList) {
        return switch (this.type.ordinal()) {
            case 2 -> {
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                int[] centerPoint = LongPosHelper.convert2Array(this.centerPoint);
                yield BlockSorter.modifyPos(posList, Comparator.comparingDouble(pos -> -WorldGenUtil.getDistance(centerPoint, (int[])pos.getValue())));
            }
            case 3 -> {
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                int[] centerPoint = LongPosHelper.convert2Array(this.centerPoint);
                yield BlockSorter.modifyPos(posList, Comparator.comparingDouble(pos -> WorldGenUtil.getDistance(centerPoint, (int[])pos.getValue())));
            }
            case 4 -> {
                int[] centerPoint = LongPosHelper.decodeBlockPos2Array(ListUtil.getRandomElement(posList));
                yield BlockSorter.modifyPos(posList, Comparator.comparingDouble(pos -> -WorldGenUtil.getDistance(centerPoint, (int[])pos.getValue())));
            }
            case 5 -> {
                int[] centerPoint = LongPosHelper.decodeBlockPos2Array(ListUtil.getRandomElement(posList));
                yield BlockSorter.modifyPos(posList, Comparator.comparingDouble(pos -> WorldGenUtil.getDistance(centerPoint, (int[])pos.getValue())));
            }
            case 8 -> {
                LongArrayList copy = posList.clone();
                Collections.shuffle(copy);
                yield copy;
            }
            case 0 -> {
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                class_243 direction = this.axisDirection.method_1029();
                yield BlockSorter.modifyPos(posList, Comparator.comparingDouble(pos -> (double)((int[])pos.getValue())[0] * direction.field_1352 + (double)((int[])pos.getValue())[1] * direction.field_1351 + (double)((int[])pos.getValue())[2] * direction.field_1350));
            }
            case 1 -> {
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                yield BlockSorter.modifyPos(posList, Comparator.comparingDouble(pos -> {
                    class_243 axisPoint = this.centerPoint.method_46558();
                    class_243 axisDirection = this.axisDirection.method_1029();
                    class_243 blockPosition = new class_243((double)((int[])pos.getValue())[0], (double)((int[])pos.getValue())[1], (double)((int[])pos.getValue())[2]);
                    class_243 pointToBlock = blockPosition.method_1020(axisPoint);
                    double projectionLength = pointToBlock.method_1026(axisDirection);
                    class_243 closestPointOnAxis = axisPoint.method_1019(axisDirection.method_1021(projectionLength));
                    return -WorldGenUtil.getDistance(class_2338.method_49638((class_2374)closestPointOnAxis), class_2338.method_49638((class_2374)axisPoint));
                }));
            }
            case 10 -> posList;
            case 9 -> {
                LongArrayList copy = posList.clone();
                Collections.reverse(copy);
                yield copy;
            }
            case 6 -> {
                class_243 axisPoint = this.centerPoint.method_46558();
                class_243 axisDirection = this.axisDirection.method_1029();
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                yield BlockSorter.modifyPos(posList, Comparator.comparingDouble(pos -> {
                    class_243 blockVec = new class_243((double)((int[])pos.getValue())[0], (double)((int[])pos.getValue())[1], (double)((int[])pos.getValue())[2]);
                    double distance = blockVec.method_1020(axisPoint).method_1026(axisDirection);
                    return -Math.abs(distance);
                }));
            }
            case 7 -> {
                class_243 axisPoint = this.centerPoint.method_46558();
                class_243 axisDirection = this.axisDirection.method_1029();
                if (posList == null || posList.isEmpty() || posList.size() == 1) {
                    yield posList;
                }
                yield BlockSorter.modifyPos(posList, Comparator.comparingDouble(pos -> {
                    class_243 blockVec = new class_243((double)((int[])pos.getValue())[0], (double)((int[])pos.getValue())[1], (double)((int[])pos.getValue())[2]);
                    double distance = blockVec.method_1020(axisPoint).method_1026(axisDirection);
                    return Math.abs(distance);
                }));
            }
            default -> throw new IllegalStateException("Unexpected sorter value: " + String.valueOf((Object)this.type));
        };
    }

    public void sortInsideBlockList(BlockListManager manager) {
        switch (this.type.ordinal()) {
            case 2: {
                for (BlockList blockList : manager.getAllBlockList()) {
                    int[] center = LongPosHelper.convert2Array(this.centerPoint);
                    BlockSorter.modifyPos(blockList, Comparator.comparingDouble(pos -> -WorldGenUtil.getDistance(center, (int[])pos.getValue())));
                }
                break;
            }
            case 3: {
                for (BlockList blockList : manager.getAllBlockList()) {
                    int[] center = LongPosHelper.convert2Array(this.centerPoint);
                    BlockSorter.modifyPos(blockList, Comparator.comparingDouble(pos -> WorldGenUtil.getDistance(center, (int[])pos.getValue())));
                }
                break;
            }
            case 4: {
                for (BlockList blockList : manager.getAllBlockList()) {
                    this.centerPoint = blockList.getRandomPos();
                    int[] center = LongPosHelper.convert2Array(this.centerPoint);
                    BlockSorter.modifyPos(blockList, Comparator.comparingDouble(pos -> -WorldGenUtil.getDistance(center, (int[])pos.getValue())));
                }
                break;
            }
            case 5: {
                for (BlockList blockList : manager.getAllBlockList()) {
                    this.centerPoint = blockList.getRandomPos();
                    int[] center = LongPosHelper.convert2Array(this.centerPoint);
                    BlockSorter.modifyPos(blockList, Comparator.comparingDouble(pos -> WorldGenUtil.getDistance(center, (int[])pos.getValue())));
                }
                break;
            }
            case 8: {
                for (BlockList blockList : manager.getAllBlockList()) {
                    Collections.shuffle(blockList.getPosList());
                }
                break;
            }
            case 0: {
                for (BlockList blockList : manager.getAllBlockList()) {
                    class_243 direction = this.axisDirection.method_1029();
                    BlockSorter.modifyPos(blockList, Comparator.comparingDouble(pos -> (double)((int[])pos.getValue())[0] * direction.field_1352 + (double)((int[])pos.getValue())[1] * direction.field_1351 + (double)((int[])pos.getValue())[2] * direction.field_1350));
                }
                break;
            }
            case 1: {
                for (BlockList blockList : manager.getAllBlockList()) {
                    BlockSorter.modifyPos(blockList, Comparator.comparingDouble(pos -> {
                        class_243 axisPoint = this.centerPoint.method_46558();
                        class_243 axisDirection = this.axisDirection.method_1029();
                        class_243 blockPosition = new class_243((double)((int[])pos.getValue())[0], (double)((int[])pos.getValue())[1], (double)((int[])pos.getValue())[2]);
                        class_243 pointToBlock = blockPosition.method_1020(axisPoint);
                        double projectionLength = pointToBlock.method_1026(axisDirection);
                        class_243 closestPointOnAxis = axisPoint.method_1019(axisDirection.method_1021(projectionLength));
                        return -WorldGenUtil.getDistance(class_2338.method_49638((class_2374)closestPointOnAxis), class_2338.method_49638((class_2374)axisPoint));
                    }));
                }
                break;
            }
            case 10: {
                break;
            }
            case 9: {
                for (BlockList blockList : manager.getAllBlockList()) {
                    Collections.reverse(blockList.getPosList());
                }
                break;
            }
            case 6: {
                class_243 axisPoint = this.centerPoint.method_46558();
                class_243 axisDirection = this.axisDirection.method_1029();
                for (BlockList blockList : manager.getAllBlockList()) {
                    BlockSorter.modifyPos(blockList, Comparator.comparingDouble(pos -> {
                        class_243 blockVec = new class_243((double)((int[])pos.getValue())[0], (double)((int[])pos.getValue())[1], (double)((int[])pos.getValue())[2]);
                        double distance = blockVec.method_1020(axisPoint).method_1026(axisDirection);
                        return -Math.abs(distance);
                    }));
                }
                break;
            }
            case 7: {
                class_243 axisPoint = this.centerPoint.method_46558();
                class_243 axisDirection = this.axisDirection.method_1029();
                for (BlockList blockList : manager.getAllBlockList()) {
                    BlockSorter.modifyPos(blockList, Comparator.comparingDouble(pos -> {
                        class_243 blockVec = new class_243((double)((int[])pos.getValue())[0], (double)((int[])pos.getValue())[1], (double)((int[])pos.getValue())[2]);
                        double distance = blockVec.method_1020(axisPoint).method_1026(axisDirection);
                        return Math.abs(distance);
                    }));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected sorter value: " + String.valueOf((Object)this.type));
            }
        }
    }

    public OrderedBlockListManager sortOrderedBlockList(OrderedBlockListManager orderedBlockList) {
        return switch (this.type.ordinal()) {
            case 0 -> {
                class_243 direction = this.axisDirection.method_1029();
                BlockSorter.modifyPos(orderedBlockList, Comparator.comparingDouble(entry -> {
                    int[] pos = LongPosHelper.decodeBlockPos2Array(entry.leftLong());
                    return (double)pos[0] * direction.field_1352 + (double)pos[2] * direction.field_1351 + (double)pos[1] * direction.field_1350;
                }));
                yield orderedBlockList;
            }
            case 1 -> {
                class_243 axisPoint = this.centerPoint.method_46558();
                class_243 axisDirection = this.axisDirection.method_1029();
                BlockSorter.modifyPos(orderedBlockList, Comparator.comparingDouble(entry -> {
                    int[] pos = LongPosHelper.decodeBlockPos2Array(entry.leftLong());
                    class_243 blockPosition = new class_243((double)pos[0], (double)pos[1], (double)pos[2]);
                    class_243 pointToBlock = blockPosition.method_1020(axisPoint);
                    double projectionLength = pointToBlock.method_1026(axisDirection);
                    class_243 closestPointOnAxis = axisPoint.method_1019(axisDirection.method_1021(projectionLength));
                    return -WorldGenUtil.getDistance(class_2338.method_49638((class_2374)closestPointOnAxis), class_2338.method_49638((class_2374)axisPoint));
                }));
                yield orderedBlockList;
            }
            case 2 -> {
                int[] center = LongPosHelper.convert2Array(this.centerPoint);
                BlockSorter.modifyPos(orderedBlockList, Comparator.comparingDouble(entry -> -WorldGenUtil.getDistance(center, LongPosHelper.decodeBlockPos2Array(entry.leftLong()))));
                yield orderedBlockList;
            }
            case 3 -> {
                int[] center = LongPosHelper.convert2Array(this.centerPoint);
                BlockSorter.modifyPos(orderedBlockList, Comparator.comparingDouble(entry -> WorldGenUtil.getDistance(center, LongPosHelper.decodeBlockPos2Array(entry.leftLong()))));
                yield orderedBlockList;
            }
            case 4 -> {
                int[] center = LongPosHelper.decodeBlockPos2Array(orderedBlockList.getRandomBlockPos());
                BlockSorter.modifyPos(orderedBlockList, Comparator.comparingDouble(entry -> -WorldGenUtil.getDistance(center, LongPosHelper.decodeBlockPos2Array(entry.leftLong()))));
                yield orderedBlockList;
            }
            case 5 -> {
                int[] center = LongPosHelper.decodeBlockPos2Array(orderedBlockList.getRandomBlockPos());
                BlockSorter.modifyPos(orderedBlockList, Comparator.comparingDouble(entry -> WorldGenUtil.getDistance(center, LongPosHelper.decodeBlockPos2Array(entry.leftLong()))));
                yield orderedBlockList;
            }
            case 6 -> {
                class_243 axisPoint = this.centerPoint.method_46558();
                class_243 axisDirection = this.axisDirection.method_1029();
                BlockSorter.modifyPos(orderedBlockList, Comparator.comparingDouble(entry -> {
                    int[] pos = LongPosHelper.decodeBlockPos2Array(entry.leftLong());
                    class_243 blockVec = new class_243((double)pos[0], (double)pos[1], (double)pos[2]);
                    double distance = blockVec.method_1020(axisPoint).method_1026(axisDirection);
                    return -Math.abs(distance);
                }));
                yield orderedBlockList;
            }
            case 7 -> {
                class_243 axisPoint = this.centerPoint.method_46558();
                class_243 axisDirection = this.axisDirection.method_1029();
                BlockSorter.modifyPos(orderedBlockList, Comparator.comparingDouble(entry -> {
                    int[] pos = LongPosHelper.decodeBlockPos2Array(entry.leftLong());
                    class_243 blockVec = new class_243((double)pos[0], (double)pos[1], (double)pos[2]);
                    double distance = blockVec.method_1020(axisPoint).method_1026(axisDirection);
                    return Math.abs(distance);
                }));
                yield orderedBlockList;
            }
            case 8 -> {
                Collections.shuffle(orderedBlockList.getPosList());
                yield orderedBlockList;
            }
            case 10 -> orderedBlockList;
            case 9 -> {
                Collections.reverse(orderedBlockList.getPosList());
                yield orderedBlockList;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.type));
        };
    }

    private static void modifyPos(OrderedBlockListManager orderedBlockList, @NotNull Comparator<LongShortImmutablePair> comparator) {
        orderedBlockList.setPosList(((Stream)orderedBlockList.getPosList().stream().parallel()).sorted(comparator).collect(Collectors.toList()));
    }

    private static LongArrayList modifyPos(LongArrayList list, @NotNull Comparator<AbstractMap.SimpleEntry<Long, int[]>> comparator) {
        return list.longStream().parallel().mapToObj(encodedLong -> new AbstractMap.SimpleEntry<Long, int[]>(encodedLong, LongPosHelper.decodeBlockPos2Array(encodedLong))).sorted(comparator).mapToLong(Map.Entry::getKey).collect(LongArrayList::new, List::addLast, LongList::addAll);
    }

    private static void modifyPos(BlockList blockList, @NotNull Comparator<AbstractMap.SimpleEntry<Long, int[]>> comparator) {
        blockList.setPosList(blockList.getPosList().longStream().parallel().mapToObj(encodedLong -> new AbstractMap.SimpleEntry<Long, int[]>(encodedLong, LongPosHelper.decodeBlockPos2Array(encodedLong))).sorted(comparator).mapToLong(Map.Entry::getKey).collect(LongArrayList::new, List::addLast, LongList::addAll));
    }

    public static enum BlockSorterType {
        ALONG_AXIS,
        RADIAL_AXIS,
        FROM_POINT,
        FROM_POINT_INVERTED,
        FROM_RANDOM_POINT,
        FROM_RANDOM_POINT_INVERTED,
        FROM_PLANE,
        FROM_PLANE_INVERTED,
        RANDOM,
        INVERSE,
        FROM_LIST;

    }
}

