/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.client.hud.widget;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractEntryWidget
extends class_339
implements class_4068 {
    private boolean drawsBackground = true;
    private boolean focusUnlocked = true;
    protected boolean editable = true;
    private boolean selecting;
    private final class_327 textRenderer;
    protected String text = "";
    private int maxLength = 32;
    private int focusedTicks;
    private int firstCharacterIndex;
    private int selectionStart;
    private int selectionEnd;
    private int editableColor = 0xE0E0E0;
    private int uneditableColor = 0x707070;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> changedListener;
    private Predicate<String> textPredicate = Objects::nonNull;
    private BiFunction<String, Integer, class_5481> renderTextProvider = (string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);
    @Nullable
    private class_2561 placeholder;
    PressAction onPress;
    TypeAction onType;

    public AbstractEntryWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
        this(textRenderer, x, y, width, height, null, text, "", null, null);
    }

    public AbstractEntryWidget(class_327 textRenderer, int x, int y, int width, int height, @Nullable AbstractEntryWidget copyFrom, class_2561 text, String defaultText, PressAction pressAction, TypeAction typeAction) {
        super(x, y, width, height, text);
        this.textRenderer = textRenderer;
        if (copyFrom != null) {
            this.setText(copyFrom.getText());
        }
        this.text = defaultText;
        this.onPress = pressAction;
        this.onType = typeAction;
    }

    public void setChangedListener(@Nullable Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    public void setRenderTextProvider(BiFunction<String, Integer, class_5481> renderTextProvider) {
        this.renderTextProvider = renderTextProvider;
    }

    public void tick() {
        ++this.focusedTicks;
    }

    protected class_5250 method_25360() {
        class_2561 text = this.method_25369();
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{text, this.text});
    }

    public void setText(String text) {
        if (this.textPredicate.test(text)) {
            this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.setCursorToEnd();
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(text);
        }
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.onPress(this);
        }
    }

    public void onType(String chr) {
        if (this.onType != null) {
            this.onType.onType(this, chr);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void setTextPredicate(Predicate<String> textPredicate) {
        this.textPredicate = textPredicate;
    }

    public void write(String text) {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        int k = this.maxLength - this.text.length() - (i - j);
        if (k > 0) {
            String string2;
            String string = class_3544.method_57180((String)text);
            int l = string.length();
            if (k < l) {
                if (Character.isHighSurrogate(string.charAt(k - 1))) {
                    --k;
                }
                string = string.substring(0, k);
                l = k;
            }
            if (this.textPredicate.test(string2 = new StringBuilder(this.text).replace(i, j, string).toString())) {
                if (!this.customWrite(text, this.text)) {
                    this.text = string2;
                }
                this.setSelectionStart(i + l);
                this.setSelectionEnd(this.selectionStart);
                this.onChanged(this.text);
                this.onType(this.text);
            }
        }
    }

    private void onChanged(String newText) {
        if (this.changedListener != null) {
            this.changedListener.accept(newText);
        }
    }

    private void erase(int offset) {
        if (class_437.method_25441()) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                this.eraseCharacters(this.getWordSkipPosition(wordOffset) - this.selectionStart);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                String string;
                int k;
                int i = this.getCursorPosWithOffset(characterOffset);
                int j = Math.min(i, this.selectionStart);
                if (j != (k = Math.max(i, this.selectionStart)) && this.textPredicate.test(string = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = string;
                    this.setCursor(j);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        return this.getWordSkipPosition(wordOffset, this.getCursor());
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition) {
        return this.getWordSkipPosition(wordOffset, cursorPosition, true);
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        int i = cursorPosition;
        boolean bl = wordOffset < 0;
        int j = Math.abs(wordOffset);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipOverSpaces && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipOverSpaces && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset));
    }

    private int getCursorPosWithOffset(int offset) {
        return class_156.method_27761((String)this.text, (int)this.selectionStart, (int)offset);
    }

    public void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selectionStart);
        }
        this.onChanged(this.text);
    }

    public void setSelectionStart(int cursor) {
        this.selectionStart = class_3532.method_15340((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorToStart() {
        this.setCursor(0);
    }

    public void setCursorToEnd() {
        this.setCursor(this.text.length());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        this.selecting = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.setCursorToEnd();
            this.setSelectionEnd(0);
            this.onType(this.text);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            this.onType(this.text);
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (this.editable) {
                this.write(class_310.method_1551().field_1774.method_1460());
            }
            this.onType(this.text);
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            if (this.editable) {
                this.write("");
            }
            this.onType(this.text);
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(-1);
                    this.selecting = class_437.method_25442();
                }
                this.onType(this.text);
                return true;
            }
            default: {
                this.onType(this.text);
                return false;
            }
            case 261: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(1);
                    this.selecting = class_437.method_25442();
                }
                this.onType(this.text);
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(1));
                } else {
                    this.moveCursor(1);
                }
                this.onType(this.text);
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                this.onType(this.text);
                return true;
            }
            case 268: {
                this.setCursorToStart();
                this.onType(this.text);
                return true;
            }
            case 269: 
        }
        this.setCursorToEnd();
        this.onType(this.text);
        return true;
    }

    public boolean isActive() {
        return this.isVisible() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        if (class_3544.method_57175((char)chr)) {
            if (this.editable && this.canWrite(chr)) {
                this.write(Character.toString(chr));
            }
            return true;
        }
        return false;
    }

    protected abstract boolean canWrite(char var1);

    protected boolean customWrite(String originText, String text) {
        return false;
    }

    public void method_25348(double mouseX, double mouseY) {
        this.onPress();
        int i = class_3532.method_15357((double)mouseX) - this.method_46426();
        if (this.drawsBackground) {
            i -= 4;
        }
        String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        this.setCursor(this.textRenderer.method_27523(string, i).length() + this.firstCharacterIndex);
    }

    public void method_25354(class_1144 soundManager) {
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            int i;
            if (this.drawsBackground()) {
                i = this.method_25370() ? -1 : -6250336;
                context.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.field_22758 + 1, this.method_46427() + this.field_22759 + 1, i);
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -16777216);
            }
            i = this.editable ? this.editableColor : this.uneditableColor;
            int j = this.selectionStart - this.firstCharacterIndex;
            int k = this.selectionEnd - this.firstCharacterIndex;
            String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
            boolean bl = j >= 0 && j <= string.length();
            boolean bl2 = this.method_25370() && this.focusedTicks / 6 % 2 == 0 && bl;
            int l = this.drawsBackground ? this.method_46426() + 4 : this.method_46426();
            int m = this.drawsBackground ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            int n = l;
            if (k > string.length()) {
                k = string.length();
            }
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, j) : string;
                n = context.method_35720(this.textRenderer, this.renderTextProvider.apply(string2, this.firstCharacterIndex), l, m, i);
            }
            boolean bl3 = this.selectionStart < this.text.length() || this.text.length() >= this.getMaxLength();
            int o = n;
            if (!bl) {
                o = j > 0 ? l + this.field_22758 : l;
            } else if (bl3) {
                o = n - 1;
                --n;
            }
            if (!string.isEmpty() && bl && j < string.length()) {
                context.method_35720(this.textRenderer, this.renderTextProvider.apply(string.substring(j), this.selectionStart), n, m, i);
            }
            if (this.placeholder != null && string.isEmpty() && !this.method_25370()) {
                context.method_27535(this.textRenderer, this.placeholder, n, m, i);
            }
            if (!bl3 && this.suggestion != null) {
                context.method_25303(this.textRenderer, this.suggestion, o - 1, m, -8355712);
            }
            if (bl2) {
                if (bl3) {
                    context.method_51739(class_1921.method_51785(), o, m - 1, o + 1, m + 1 + 9, -3092272);
                } else {
                    context.method_25303(this.textRenderer, "_", o, m, i);
                }
            }
            if (k != j) {
                int p = l + this.textRenderer.method_1727(string.substring(0, k));
                this.drawSelectionHighlight(context, o, m - 1, p - 1, m + 1 + 9);
            }
        }
    }

    private void drawSelectionHighlight(class_332 context, int x1, int y1, int x2, int y2) {
        int i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > this.method_46426() + this.field_22758) {
            x2 = this.method_46426() + this.field_22758;
        }
        if (x1 > this.method_46426() + this.field_22758) {
            x1 = this.method_46426() + this.field_22758;
        }
        context.method_51739(class_1921.method_51786(), x1, y1, x2, y2, -16776961);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.text.length() > maxLength) {
            this.text = this.text.substring(0, maxLength);
            this.onChanged(this.text);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursor() {
        return this.selectionStart;
    }

    private boolean drawsBackground() {
        return this.drawsBackground;
    }

    public void setDrawsBackground(boolean drawsBackground) {
        this.drawsBackground = drawsBackground;
    }

    public void setEditableColor(int editableColor) {
        this.editableColor = editableColor;
    }

    public void setUneditableColor(int uneditableColor) {
        this.uneditableColor = uneditableColor;
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        return this.field_22764 && this.editable ? super.method_48205(navigation) : null;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    public void method_25365(boolean focused) {
        if (this.focusUnlocked || focused) {
            super.method_25365(focused);
            if (focused) {
                this.focusedTicks = 0;
            }
        }
    }

    private boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getInnerWidth() {
        return this.drawsBackground() ? this.field_22758 - 8 : this.field_22758;
    }

    public void setSelectionEnd(int index) {
        int i = this.text.length();
        this.selectionEnd = class_3532.method_15340((int)index, (int)0, (int)i);
        if (this.textRenderer != null) {
            if (this.firstCharacterIndex > i) {
                this.firstCharacterIndex = i;
            }
            int j = this.getInnerWidth();
            String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), j);
            int k = string.length() + this.firstCharacterIndex;
            if (this.selectionEnd == this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.textRenderer.method_27524(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.firstCharacterIndex += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - this.selectionEnd;
            }
            this.firstCharacterIndex = class_3532.method_15340((int)this.firstCharacterIndex, (int)0, (int)i);
        }
    }

    public void setFocusUnlocked(boolean focusUnlocked) {
        this.focusUnlocked = focusUnlocked;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void setVisible(boolean visible) {
        this.field_22764 = visible;
    }

    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public int getCharacterX(int index) {
        return index > this.text.length() ? this.method_46426() : this.method_46426() + this.textRenderer.method_1727(this.text.substring(0, index));
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }

    public void setPlaceholder(@Nullable class_2561 placeholder) {
        this.placeholder = placeholder;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface PressAction {
        public void onPress(AbstractEntryWidget var1);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface TypeAction {
        public void onType(AbstractEntryWidget var1, String var2);
    }
}

