/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_7157;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListHelper;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.util.ChunkUtil;
import net.rodofire.easierworldcreator.util.file.EwcFolderData;
import net.rodofire.easierworldcreator.util.file.FileUtil;

public class PlaceAllMCFCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironmen) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"placeallmultichunkfeatures").executes(context -> PlaceAllMCFCommand.run((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"legacy", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlaceAllMCFCommand.run((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"legacy")))));
    }

    public static int run(CommandContext<class_2168> context, boolean legacy) throws CommandSyntaxException {
        Path path = legacy ? EwcFolderData.getStructuresDirectory(((class_2168)context.getSource()).method_9225()) : EwcFolderData.Legacy.getLegacyStructureDir((class_5281)((class_2168)context.getSource()).method_9225());
        if (((class_2168)context.getSource()).method_9259(2)) {
            try (Stream<Path> paths = Files.list(path);){
                paths.forEach(filePath -> {
                    int chunkZ;
                    int chunkX;
                    String fileName = filePath.getFileName().toString();
                    Pattern pattern = Pattern.compile("chunk_(-?\\d+)_(-?\\d+)$");
                    Matcher matcher = pattern.matcher(fileName);
                    if (matcher.matches()) {
                        chunkX = Integer.parseInt(matcher.group(1));
                        chunkZ = Integer.parseInt(matcher.group(2));
                    } else {
                        chunkZ = 0;
                        chunkX = 0;
                    }
                    if (ChunkUtil.isFeaturesGenerated((class_4538)((class_2168)context.getSource()).method_9225(), new class_1923(chunkX, chunkZ))) {
                        try (Stream<Path> files = Files.list(filePath);){
                            files.forEach(jsonFiles -> {
                                if (jsonFiles.toString().endsWith(".json")) {
                                    JsonArray jsonArray = (JsonArray)new Gson().fromJson(FileUtil.loadJson(jsonFiles), JsonArray.class);
                                    BlockListManager manager = BlockListHelper.fromJson((class_5281)((class_2168)context.getSource()).method_9225(), jsonArray, new class_1923(chunkX, chunkZ));
                                    manager.placeAllNDelete((class_5281)((class_2168)context.getSource()).method_9225());
                                }
                                try {
                                    Files.delete(jsonFiles);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.fillInStackTrace();
                        }
                        try {
                            Files.delete(filePath);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"multi_chunk_place"), true);
        return 1;
    }
}

