/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.rodofire.easierworldcreator.config.objects.BooleanConfigObject;
import net.rodofire.easierworldcreator.config.objects.EnumConfigObject;
import net.rodofire.easierworldcreator.config.objects.IntegerConfigObject;

public class ConfigCategory {
    final String name;
    Map<String, BooleanConfigObject> bools = new LinkedHashMap<String, BooleanConfigObject>();
    Map<String, IntegerConfigObject> ints = new LinkedHashMap<String, IntegerConfigObject>();
    Map<String, EnumConfigObject> enums = new LinkedHashMap<String, EnumConfigObject>();

    public ConfigCategory(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addBoolean(String name, boolean defaultValue) {
        this.bools.put(name, new BooleanConfigObject(defaultValue, name));
    }

    public void addBoolean(BooleanConfigObject bool) {
        this.bools.put(bool.getName(), bool);
    }

    public void addInt(String name, int defaultValue) {
        this.ints.put(name, new IntegerConfigObject(defaultValue, name));
    }

    public void addInt(IntegerConfigObject integer) {
        this.ints.put(integer.getName(), integer);
    }

    public void addInt(String name, int defaultValue, String description, int minValue, int maxValue) {
        IntegerConfigObject cfg = new IntegerConfigObject(defaultValue, name);
        cfg.setDescription(description);
        cfg.setMinValue(minValue);
        cfg.setMaxValue(maxValue);
        this.ints.put(name, cfg);
    }

    public void addInt(String name, int defaultValue, int minValue, int maxValue) {
        IntegerConfigObject cfg = new IntegerConfigObject(defaultValue, minValue, maxValue, name);
        this.ints.put(name, cfg);
    }

    public void addBoolean(String name, String description, boolean defaultValue) {
        this.bools.put(name, new BooleanConfigObject(defaultValue, description, name));
    }

    public void addInt(String name, String description, int defaultValue) {
        this.ints.put(name, new IntegerConfigObject(defaultValue, description, name));
    }

    public void addEnum(String name, String defaultValue, Set<String> strings) {
        if (!strings.contains(defaultValue)) {
            throw new IllegalStateException("Default enum value not present in possible values");
        }
        this.enums.put(name, new EnumConfigObject(defaultValue, name, strings));
    }

    public void addEnum(String name, String description, String defaultValue, Set<String> strings) {
        if (!strings.contains(name)) {
            throw new IllegalStateException("Default enum value not present in possible values");
        }
        this.enums.put(name, new EnumConfigObject(defaultValue, name, description, strings));
    }

    public void addEnum(EnumConfigObject obj) {
        this.enums.put(obj.getName(), obj);
    }

    public Map<String, BooleanConfigObject> getBools() {
        return this.bools;
    }

    public Map<String, IntegerConfigObject> getInts() {
        return this.ints;
    }

    public Map<String, EnumConfigObject> getEnums() {
        return this.enums;
    }

    public void init() {
    }

    public boolean equals(ConfigCategory category) {
        int i;
        if (this.bools.size() != category.bools.size()) {
            return false;
        }
        if (this.ints.size() != category.ints.size()) {
            return false;
        }
        if (this.enums.size() != category.enums.size()) {
            return false;
        }
        Iterator<BooleanConfigObject> bool = this.bools.values().iterator();
        Iterator<BooleanConfigObject> bool2 = category.bools.values().iterator();
        Iterator<IntegerConfigObject> it = this.ints.values().iterator();
        Iterator<IntegerConfigObject> it2 = category.ints.values().iterator();
        Iterator<EnumConfigObject> enu = this.enums.values().iterator();
        Iterator<EnumConfigObject> enu2 = category.enums.values().iterator();
        for (i = 0; i < category.bools.size(); ++i) {
            BooleanConfigObject boo2;
            BooleanConfigObject boo = bool.next();
            if (boo.equals(boo2 = bool2.next())) continue;
            return false;
        }
        for (i = 0; i < category.ints.size(); ++i) {
            IntegerConfigObject ii2;
            IntegerConfigObject ii = it.next();
            if (ii.equals(ii2 = it2.next())) continue;
            return false;
        }
        for (i = 0; i < category.enums.size(); ++i) {
            EnumConfigObject ei2;
            EnumConfigObject ei = enu.next();
            if (ei.equals(ei2 = enu2.next())) continue;
            return false;
        }
        return this.name.equals(category.name);
    }
}

