/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.rodofire.easierworldcreator.client.hud.screen.AbstractInfoScreen;
import net.rodofire.easierworldcreator.config.ModConfig;
import net.rodofire.easierworldcreator.config.client.ConfigScreen;
import net.rodofire.easierworldcreator.config.objects.AbstractConfigObject;

@Environment(value=EnvType.CLIENT)
public class ModClientConfig {
    private final ModConfig config;
    private final Map<String, Map<AbstractConfigObject<?>, AbstractInfoScreen>> screens = new LinkedHashMap();

    public ModClientConfig(ModConfig config) {
        this.config = config;
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public Map<String, Map<AbstractConfigObject<?>, AbstractInfoScreen>> getScreens() {
        return this.screens;
    }

    public Map<AbstractConfigObject<?>, AbstractInfoScreen> getCategoryScreens(String name) {
        return this.screens.get(name);
    }

    public Optional<AbstractInfoScreen> getScreen(String name, AbstractConfigObject<?> configObject) {
        return Optional.ofNullable(this.screens.get(name).get(configObject));
    }

    public AbstractInfoScreen put(String name, AbstractConfigObject<?> configObject, AbstractInfoScreen screen) {
        if (this.config.contains(name, configObject)) {
            this.screens.computeIfAbsent(name, key -> new HashMap());
            Map<AbstractConfigObject<?>, AbstractInfoScreen> nestedMap = this.screens.get(name);
            return nestedMap.put(configObject, screen);
        }
        return screen;
    }

    public void init() {
        ConfigScreen.putModId(this.config.getMOD_ID(), this);
    }
}

