/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.config;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.rodofire.easierworldcreator.config.ConfigCategory;
import net.rodofire.easierworldcreator.config.ConfigUtil;
import net.rodofire.easierworldcreator.config.ReadableConfig;
import net.rodofire.easierworldcreator.config.WritableConfig;
import net.rodofire.easierworldcreator.config.objects.AbstractConfigObject;
import net.rodofire.easierworldcreator.config.objects.BooleanConfigObject;
import net.rodofire.easierworldcreator.config.objects.EnumConfigObject;
import net.rodofire.easierworldcreator.config.objects.IntegerConfigObject;

public class ModConfig {
    boolean protectedConfig = false;
    private final String MOD_ID;
    Map<String, ConfigCategory> categories = new LinkedHashMap<String, ConfigCategory>();

    public ModConfig(String modID) {
        this.MOD_ID = modID;
    }

    public boolean isConfigProtected() {
        return this.protectedConfig;
    }

    public void addCategory(ConfigCategory category) {
        this.categories.put(category.getName(), category);
    }

    public void addCategory(Set<ConfigCategory> categories) {
        this.categories.putAll(categories.stream().collect(Collectors.toMap(ConfigCategory::getName, c -> c)));
    }

    public void addCategories(ConfigCategory ... categories) {
        Map<String, ConfigCategory> categoryMap = Arrays.stream(categories).collect(Collectors.toMap(ConfigCategory::getName, category -> category));
        this.categories.putAll(categoryMap);
    }

    public String getMOD_ID() {
        return this.MOD_ID;
    }

    public ConfigCategory getCategory(String name) {
        ConfigCategory cat = this.categories.get(name);
        if (cat == null) {
            return null;
        }
        if (!this.protectedConfig) {
            ReadableConfig reader = new ReadableConfig(this.MOD_ID);
            reader.refresh(cat);
        }
        return cat;
    }

    public ConfigCategory getTemporaryCategory(String name) {
        return this.categories.get(name);
    }

    public Set<ConfigCategory> getCategories() {
        return new LinkedHashSet<ConfigCategory>(this.categories.values());
    }

    public void refreshValues() {
        ReadableConfig reader = new ReadableConfig(this.MOD_ID);
        for (ConfigCategory cat : this.categories.values()) {
            reader.refresh(cat);
        }
    }

    public void apply(ConfigCategory category) {
        String name = category.getName();
        this.categories.put(name, category);
    }

    public void save() {
        Path path = ConfigUtil.getConfigPath(this.MOD_ID);
        for (ConfigCategory cat : this.categories.values()) {
            WritableConfig writer = new WritableConfig(this.MOD_ID, cat);
            writer.write(path.resolve(cat.getName() + ".toml"));
        }
    }

    public <T extends AbstractConfigObject<U>, U> void updateValues(String name) {
        WritableConfig writer = new WritableConfig(this.MOD_ID, this.getCategory(name));
        writer.repairConfig(this.getCategoryPath(name));
    }

    public boolean shouldRestart() {
        return this.categories.values().stream().anyMatch(configCategory -> configCategory.getBools().values().stream().anyMatch(AbstractConfigObject::shouldRestart)) || this.categories.values().stream().anyMatch(configCategory -> configCategory.getInts().values().stream().anyMatch(AbstractConfigObject::shouldRestart)) || this.categories.values().stream().anyMatch(configCategory -> configCategory.getEnums().values().stream().anyMatch(AbstractConfigObject::shouldRestart));
    }

    public void init() {
        List<ConfigCategory> caterories = this.shouldWrite();
        if (!caterories.isEmpty()) {
            this.writeConfigs(caterories);
        }
        this.repair();
        this.refreshValues();
        ServerWorldEvents.LOAD.register((minecraftServer, world) -> {
            this.protectedConfig = true;
        });
        ServerWorldEvents.UNLOAD.register((minecraftServer, world) -> {
            this.protectedConfig = false;
        });
    }

    public Path getCategoryPath(String name) {
        return ConfigUtil.getConfigPath(this.MOD_ID).resolve(this.getCategory(name).getName() + ".toml");
    }

    private void repair() {
        Path path = ConfigUtil.getConfigPath(this.MOD_ID);
        for (ConfigCategory category : this.categories.values()) {
            WritableConfig writableConfig = new WritableConfig(this.MOD_ID, category);
            writableConfig.repairConfig(path.resolve(category.getName() + ".toml"));
        }
    }

    private List<ConfigCategory> shouldWrite() {
        ArrayList<ConfigCategory> configCaterories = new ArrayList<ConfigCategory>();
        Path path = ConfigUtil.getConfigPath(this.MOD_ID);
        for (ConfigCategory cat : this.categories.values()) {
            if ((path = path.resolve(cat.getName() + ".toml")).toFile().exists()) continue;
            configCaterories.add(cat);
        }
        return configCaterories;
    }

    private void writeConfigs(List<ConfigCategory> categories) {
        Path path = ConfigUtil.getConfigPath(this.MOD_ID);
        for (ConfigCategory category : categories) {
            WritableConfig wc = new WritableConfig(this.MOD_ID, category);
            wc.write(path.resolve(category.getName() + ".toml"));
        }
    }

    public ModConfig copy() {
        ModConfig config = new ModConfig(this.MOD_ID);
        config.categories = new LinkedHashMap<String, ConfigCategory>(this.categories);
        config.protectedConfig = this.protectedConfig;
        return config;
    }

    public boolean contains(String name) {
        return this.categories.containsKey(name);
    }

    public <T extends AbstractConfigObject<U>, U> boolean contains(String name, T category) {
        boolean bl = false;
        if (this.categories.containsKey(name)) {
            if (category instanceof BooleanConfigObject && this.categories.get(name).getBools().containsValue(category)) {
                return true;
            }
            if (category instanceof EnumConfigObject && this.categories.get(name).getEnums().containsValue(category)) {
                return true;
            }
            return category instanceof IntegerConfigObject && this.categories.get(name).getInts().containsValue(category);
        }
        return false;
    }

    public void apply(ModConfig config) {
        this.protectedConfig = config.protectedConfig;
        this.categories = config.categories;
    }

    public boolean equals(ModConfig obj) {
        if (this.categories.size() != obj.categories.size()) {
            return false;
        }
        Iterator<ConfigCategory> catIt = this.categories.values().iterator();
        Iterator<ConfigCategory> catIt2 = obj.categories.values().iterator();
        for (int i = 0; i < this.categories.size(); ++i) {
            ConfigCategory cat2;
            ConfigCategory cat = catIt.next();
            if (cat.equals(cat2 = catIt2.next())) continue;
            return false;
        }
        boolean bl = true;
        return Objects.equals(obj.MOD_ID, this.MOD_ID);
    }
}

