/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.config;

import com.moandjiezana.toml.Toml;
import java.util.Map;
import net.rodofire.easierworldcreator.config.ConfigCategory;
import net.rodofire.easierworldcreator.config.ConfigUtil;
import net.rodofire.easierworldcreator.config.objects.AbstractConfigObject;
import net.rodofire.easierworldcreator.config.objects.BooleanConfigObject;
import net.rodofire.easierworldcreator.config.objects.EnumConfigObject;
import net.rodofire.easierworldcreator.config.objects.IntegerConfigObject;

public class ReadableConfig {
    private final String MOD_ID;

    public ReadableConfig(String modID) {
        this.MOD_ID = modID;
    }

    public void refresh(ConfigCategory caterory) {
        Toml toml = new Toml();
        toml.read(ConfigUtil.getConfigPath(this.MOD_ID).resolve(caterory.getName() + ".toml").toFile());
        for (Map.Entry<String, BooleanConfigObject> entry : caterory.bools.entrySet()) {
            entry.getValue().setPreviousValue(toml.getBoolean(entry.getKey()));
            entry.getValue().setActualValue(toml.getBoolean(entry.getKey()));
        }
        for (Map.Entry<String, AbstractConfigObject> entry : caterory.ints.entrySet()) {
            ((IntegerConfigObject)entry.getValue()).setPreviousValue(toml.getLong(entry.getKey()).intValue());
            ((IntegerConfigObject)entry.getValue()).setActualValue(toml.getLong(entry.getKey()).intValue());
        }
        for (Map.Entry<String, AbstractConfigObject> entry : caterory.enums.entrySet()) {
            ((EnumConfigObject)entry.getValue()).setPreviousValue(toml.getString(entry.getKey()));
            ((EnumConfigObject)entry.getValue()).setActualValue(toml.getString(entry.getKey()));
        }
    }
}

