/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.rodofire.easierworldcreator.config.ConfigCategory;
import net.rodofire.easierworldcreator.config.objects.AbstractConfigObject;
import net.rodofire.easierworldcreator.config.objects.BooleanConfigObject;
import net.rodofire.easierworldcreator.config.objects.EnumConfigObject;
import net.rodofire.easierworldcreator.config.objects.IntegerConfigObject;

public class WritableConfig {
    ConfigCategory category;
    String modId;

    public WritableConfig(String modId, ConfigCategory category) {
        this.category = category;
        this.modId = modId;
    }

    public void write(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("# ----- " + this.category.getName() + " -----");
            this.writeEntries(writer, this.category.bools);
            if (!this.category.bools.isEmpty() && !this.category.ints.isEmpty()) {
                writer.write("# ----------------------------");
            }
            this.writeEntries(writer, this.category.ints);
            if (!this.category.ints.isEmpty() && !this.category.bools.isEmpty()) {
                writer.write("# ----------------------------");
            }
            this.writeEntries(writer, this.category.enums);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config file", e);
        }
    }

    private <T extends AbstractConfigObject<U>, U> void writeEntries(BufferedWriter writer, Map<String, T> configObject) throws IOException {
        Optional<T> opt = configObject.values().stream().findFirst();
        if (opt.isPresent()) {
            writer.newLine();
            writer.newLine();
            writer.write("# " + ((AbstractConfigObject)opt.get()).getObjectCategory());
            writer.newLine();
            writer.newLine();
            for (Map.Entry<String, T> obj : configObject.entrySet()) {
                String key = obj.getKey();
                Object value = ((AbstractConfigObject)obj.getValue()).getActualValue();
                if (value instanceof String) {
                    String str = (String)value;
                    value = "\"" + str + "\"";
                }
                writer.write(((AbstractConfigObject)obj.getValue()).getDefaultDescription(this.modId));
                writer.newLine();
                writer.write(key + " = " + String.valueOf(value));
                writer.newLine();
                writer.newLine();
            }
        }
    }

    public void repairConfig(Path path) {
        HashMap<String, String> existingComments = new HashMap<String, String>();
        HashMap<String, Boolean> existingBools = new HashMap<String, Boolean>();
        HashMap<String, Integer> existingInts = new HashMap<String, Integer>();
        HashMap<String, String> existingStrings = new HashMap<String, String>();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException("Config file does not exist");
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            String lastComment = "";
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) {
                    lastComment = line.substring(1).trim();
                    continue;
                }
                if (!line.contains("=")) continue;
                String[] parts = line.split("=", 2);
                String key = parts[0].trim();
                String value = parts[1].trim();
                existingComments.put(key, lastComment);
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    existingBools.put(key, Boolean.parseBoolean(value));
                } else if (value.matches("-?\\d+")) {
                    existingInts.put(key, Integer.parseInt(value));
                } else if (value.startsWith("\"") && value.endsWith("\"")) {
                    existingStrings.put(key, value.substring(1, value.length() - 1));
                }
                lastComment = "";
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read config file", e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("# ----- " + this.category.getName() + " -----");
            writer.newLine();
            writer.newLine();
            this.repairEntries(writer, this.category.bools, existingComments, existingBools);
            if (!this.category.bools.isEmpty() && !this.category.ints.isEmpty()) {
                writer.write("# ----------------------------");
                writer.newLine();
            }
            this.repairEntries(writer, this.category.ints, existingComments, existingInts);
            if (!this.category.ints.isEmpty() && !this.category.enums.isEmpty()) {
                writer.write("# ----------------------------");
                writer.newLine();
            }
            this.repairEntries(writer, this.category.enums, existingComments, existingStrings);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to repair config file", e);
        }
    }

    private <T extends AbstractConfigObject<U>, U> void repairEntries(BufferedWriter writer, Map<String, T> configObject, Map<String, String> existingComments, Map<String, ?> existingValues) throws IOException {
        Optional<T> opt = configObject.values().stream().findFirst();
        if (opt.isPresent()) {
            writer.newLine();
            writer.write("# " + ((AbstractConfigObject)opt.get()).getObjectCategory());
            writer.newLine();
            writer.newLine();
            for (Map.Entry<String, T> entry : configObject.entrySet()) {
                String key = entry.getKey();
                AbstractConfigObject configValue = (AbstractConfigObject)entry.getValue();
                String defaultComment = configValue.getDefaultDescription(this.modId);
                if (!defaultComment.equals(existingComments.getOrDefault(key, ""))) {
                    writer.write("# " + defaultComment);
                }
                writer.newLine();
                Object defaultValue = configValue.getDefaultValue();
                Object existingValue = existingValues.get(key);
                if (!this.isValueValid(existingValue, configValue)) {
                    existingValue = defaultValue;
                }
                writer.write(key + " = " + this.formatValue(existingValue));
                writer.newLine();
                writer.newLine();
            }
        }
    }

    private boolean isValueValid(Object value, AbstractConfigObject<?> configValue) {
        if (value == null) {
            return false;
        }
        if (configValue instanceof BooleanConfigObject && value instanceof Boolean) {
            return true;
        }
        if (configValue instanceof IntegerConfigObject) {
            IntegerConfigObject intConfig = (IntegerConfigObject)configValue;
            if (value instanceof Integer) {
                int intValue = (Integer)value;
                return intValue >= intConfig.getMinValue() && intValue <= intConfig.getMaxValue();
            }
        }
        if (configValue instanceof EnumConfigObject) {
            EnumConfigObject enumConfig = (EnumConfigObject)configValue;
            if (value instanceof String) {
                return enumConfig.getPossibleValues().contains(value.toString());
            }
        }
        return false;
    }

    private String formatValue(Object value) {
        if (value instanceof String) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return value.toString();
    }
}

