/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.config.client;

import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.rodofire.easierworldcreator.client.hud.screen.AbstractInfoScreen;
import net.rodofire.easierworldcreator.client.hud.screen.BackgroundScreen;
import net.rodofire.easierworldcreator.client.hud.widget.AbstractEntryWidget;
import net.rodofire.easierworldcreator.client.hud.widget.ImageButtonWidget;
import net.rodofire.easierworldcreator.client.hud.widget.InfoButtonWidget;
import net.rodofire.easierworldcreator.client.hud.widget.TextButtonWidget;
import net.rodofire.easierworldcreator.config.ConfigCategory;
import net.rodofire.easierworldcreator.config.ModClientConfig;
import net.rodofire.easierworldcreator.config.ModConfig;
import net.rodofire.easierworldcreator.config.objects.AbstractConfigObject;
import net.rodofire.easierworldcreator.config.objects.BooleanConfigObject;
import net.rodofire.easierworldcreator.config.objects.EnumConfigObject;
import net.rodofire.easierworldcreator.config.objects.IntegerConfigObject;
import org.spongepowered.include.com.google.common.collect.BiMap;
import org.spongepowered.include.com.google.common.collect.HashBiMap;

public abstract class AbstractConfigScreen
extends BackgroundScreen {
    protected int selected = 0;
    protected final String modId;
    ModClientConfig clientConfig;
    private final ModConfig config;
    private final ModConfig copy;
    Set<ConfigCategory> categories;
    ConfigCategory category;
    protected final BiMap<String, Integer> indexes = HashBiMap.create();

    protected AbstractConfigScreen(ModClientConfig config, String modId) {
        super((class_2561)class_2561.method_43471((String)("config.screen." + modId + ".title")));
        this.clientConfig = config;
        this.modId = modId;
        this.config = config.getConfig();
        this.copy = config.getConfig().copy();
        this.categories = config.getConfig().getCategories();
        this.initIndexes();
        this.renitCategory();
    }

    public AbstractConfigScreen(class_2960 background, int backgroundWidth, int backgroundHeight, ModClientConfig config, String modId) {
        super((class_2561)class_2561.method_43471((String)("config.screen." + modId + ".title")), background, backgroundWidth, backgroundHeight);
        this.clientConfig = config;
        this.config = config.getConfig();
        this.modId = modId;
        this.copy = config.getConfig().copy();
        this.categories = config.getConfig().getCategories();
        this.initIndexes();
        this.renitCategory();
    }

    public AbstractConfigScreen(class_2960 background, int backgroundWidth, int backgroundHeight, int backgroundShaderColor, ModClientConfig config, String modId) {
        super((class_2561)class_2561.method_43471((String)("config.screen." + modId + ".title")), background, backgroundWidth, backgroundHeight, backgroundShaderColor);
        this.clientConfig = config;
        this.config = config.getConfig();
        this.modId = modId;
        this.copy = config.getConfig().copy();
        this.categories = config.getConfig().getCategories();
        this.initIndexes();
        this.renitCategory();
    }

    protected void method_25426() {
        this.copy.apply(this.category);
        this.renitCategory();
        this.init(this.category);
    }

    private void renitCategory() {
        this.category = this.copy.getTemporaryCategory((String)this.indexes.inverse().get((Object)this.selected));
    }

    protected abstract void init(ConfigCategory var1);

    public <T extends AbstractConfigObject<U>, U> ImageButtonWidget addResetButton(int startX, int yOffset, T obj) {
        ImageButtonWidget buttonWidget = new ImageButtonWidget(startX, yOffset, 20, 20, class_2960.method_60655((String)"easierworldcreator", (String)"textures/gui/reset_button.png"), press -> this.reset(obj));
        buttonWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.ewc.reset")));
        return buttonWidget;
    }

    public <T extends AbstractInfoScreen> InfoButtonWidget addInfoButton(int startX, int yOffset, T obj) {
        return new InfoButtonWidget(startX, yOffset, 20, 20, obj);
    }

    private void initIndexes() {
        int i = 0;
        for (ConfigCategory category : this.categories) {
            this.indexes.put((Object)category.getName(), (Object)i);
            ++i;
        }
    }

    protected boolean hasInfoScreen(AbstractConfigObject<?> category) {
        Map<AbstractConfigObject<?>, AbstractInfoScreen> a = this.clientConfig.getCategoryScreens(this.category.getName());
        return a != null && a.containsKey(category);
    }

    protected AbstractInfoScreen getInfoScreen(AbstractConfigObject<?> category) {
        return this.clientConfig.getCategoryScreens(this.category.getName()).get(category);
    }

    protected void toggleBoolean(BooleanConfigObject configObject, class_4185 button) {
        boolean newValue = (Boolean)configObject.getActualValue() == false;
        configObject.setActualValue(newValue);
        button.method_25355((class_2561)class_2561.method_43471((String)("config.ewc.boolean." + String.valueOf(configObject.getActualValue()))));
        if (button instanceof TextButtonWidget) {
            TextButtonWidget textButtonWidget = (TextButtonWidget)button;
            textButtonWidget.setColor(newValue ? 65280 : 0xFF0000);
        }
    }

    public void cycleEnum(EnumConfigObject configObject, class_4185 button) {
        configObject.setActualValue(configObject.getNext());
        button.method_25355((class_2561)class_2561.method_43471((String)("config." + this.modId + "." + (String)configObject.getActualValue())));
    }

    protected void verifyInteger(IntegerConfigObject configObject, AbstractEntryWidget button, String cgr) {
        if (cgr.isEmpty()) {
            return;
        }
        if (cgr.equals("-")) {
            button.setEditableColor(0xFF0000);
            return;
        }
        if (!configObject.isAcceptable(Integer.parseInt(cgr))) {
            button.setEditableColor(0xFF0000);
        } else {
            button.setEditableColor(0xFFFFFF);
            configObject.setActualValue(Integer.parseInt(cgr));
        }
    }

    private <T extends AbstractConfigObject<U>, U> void reset(T configObject) {
        ((AbstractConfigObject)configObject).setActualValue(((AbstractConfigObject)configObject).getDefaultValue());
        this.method_37067();
        this.method_25426();
    }

    protected boolean configEquals() {
        return this.config.equals(this.copy);
    }

    protected void saveConfig() {
        this.config.apply(this.copy);
        this.config.save();
    }

    protected boolean shouldRestart() {
        return this.config.shouldRestart();
    }
}

