/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.config.objects;

public abstract class AbstractConfigObject<T> {
    String key;
    String name;
    String description;
    T defaultValue;
    T actualValue;
    T previousValue;
    public boolean requireRestart = false;
    boolean restart = false;

    public AbstractConfigObject(String description, String name, T defaultValue) {
        this.description = description;
        this.defaultValue = defaultValue;
        this.actualValue = defaultValue;
        this.previousValue = defaultValue;
        this.key = name;
        this.name = name;
    }

    public AbstractConfigObject(String name, T defaultValue) {
        this.defaultValue = defaultValue;
        this.actualValue = defaultValue;
        this.previousValue = defaultValue;
        this.key = name;
        this.name = name;
    }

    public abstract String getObjectCategory();

    public void resetToDefaultValue() {
        this.actualValue = this.defaultValue;
    }

    public T getActualValue() {
        return this.actualValue;
    }

    public void setActualValue(T actualValue) {
        if (this.requireRestart) {
            this.restart = !actualValue.equals(this.previousValue);
        }
        this.actualValue = actualValue;
    }

    public boolean shouldRestart() {
        return this.restart;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultDescription(String modId) {
        return this.description == null ? "# Possible Values:\n" : "#" + this.description + "\n# Possible Values:\n";
    }

    public T getPreviousValue() {
        return this.previousValue;
    }

    public void setPreviousValue(T previousValue) {
        this.previousValue = previousValue;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionKey(String modId) {
        return "config." + modId + "." + this.key + ".description";
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(AbstractConfigObject<T> other) {
        if (this.name != null && other.name != null && !this.name.equals(other.name)) {
            return false;
        }
        if (other.name != null || this.name != null) {
            return false;
        }
        if (this.actualValue != null && other.actualValue != null && !this.actualValue.equals(other.actualValue)) {
            return false;
        }
        if (other.actualValue != null || this.actualValue != null) {
            return false;
        }
        if (this.defaultValue != null && other.defaultValue != null && !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.defaultValue != null || other.defaultValue == null) {
            return false;
        }
        if (this.description != null && other.description != null) {
            return false;
        }
        return other.description == null && this.description == null;
    }
}

