/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.config.objects;

import net.rodofire.easierworldcreator.config.objects.AbstractConfigObject;

public class IntegerConfigObject
extends AbstractConfigObject<Integer> {
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public IntegerConfigObject(int defaultValue, String description, String name) {
        super(description, name, defaultValue);
    }

    public IntegerConfigObject(int defaultValue, String name) {
        super(name, name, defaultValue);
    }

    public IntegerConfigObject(int defaultValue, int minValue, int maxValue, String name, String description) {
        super(description, name, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public IntegerConfigObject(int defaultValue, int minValue, int maxValue, String name) {
        super(name, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public void setActualValue(Integer actualValue) {
        if (actualValue > this.maxValue) {
            super.setActualValue(this.maxValue);
        } else if (actualValue < this.minValue) {
            super.setActualValue(this.minValue);
        } else {
            super.setActualValue(actualValue);
        }
    }

    public int getMinValue() {
        return this.minValue;
    }

    public boolean isAcceptable(int value) {
        return value >= this.minValue && value <= this.maxValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public String getObjectCategory() {
        return "Integers";
    }

    @Override
    public String getDefaultDescription(String modId) {
        return super.getDefaultDescription(modId) + "#\tMin value: " + this.minValue + "\n#\tMax value: " + this.maxValue;
    }
}

