/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.entity.trajectory;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.jfr.Experimental;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_6862;
import net.rodofire.easierworldcreator.tag.TagUtil;
import net.rodofire.easierworldcreator.util.WorldGenUtil;

@Experimental
public class JumpVerification {
    int totalTime;
    float overshoot;
    class_1297 entity;
    Set<class_2338> passing = new HashSet<class_2338>();
    Set<class_2338> verified = new HashSet<class_2338>();
    Set<class_2248> allowed;
    class_4048 dimensions;
    class_2338 endPos;
    class_2338 startPos;
    class_243 initial;

    public JumpVerification(class_1297 entity, class_2338 endPos, class_243 initial, int totalTick, List<class_6862<class_2248>> allowed) {
        this.dimensions = entity.method_18377(class_4050.field_30095);
        this.endPos = endPos;
        this.initial = initial;
        this.totalTime = totalTick;
        this.allowed = TagUtil.BlockTags.convertBlockTagToBlockSet(allowed);
    }

    public JumpVerification(class_1297 entity, class_2338 endPos, class_243 initial, int totalTick, List<class_6862<class_2248>> allowed, Set<class_2338> passing, Set<class_2338> verified) {
        this.dimensions = entity.method_18377(class_4050.field_30095);
        this.endPos = endPos;
        this.initial = initial;
        this.totalTime = totalTick;
        this.allowed = TagUtil.BlockTags.convertBlockTagToBlockSet(allowed);
        this.passing = new HashSet<class_2338>(passing);
        this.verified = new HashSet<class_2338>(verified);
    }

    public boolean verify() {
        class_243 currentPos = this.startPos.method_46558();
        class_243 velocity = this.initial;
        for (int i = 0; i < this.totalTime * 30; ++i) {
            if (i % 30 == 0) {
                velocity = new class_243(velocity.field_1352 * (double)0.91f, (velocity.field_1351 - (double)-0.08f) * (double)0.98f, velocity.field_1350 * (double)0.91f);
            }
            if (WorldGenUtil.getDistance(currentPos = currentPos.method_1019(velocity.method_1021(0.03333333333333333)), this.startPos.method_46558()) < 1.0f) continue;
            Set<class_2338> occupiedBlocks = this.getOccupiedBlocks(currentPos);
            for (class_2338 pos : occupiedBlocks) {
                if (this.passing.contains(pos)) continue;
                if (this.verified.contains(pos)) {
                    return false;
                }
                class_2680 state = this.entity.method_37908().method_8320(pos);
                if (this.allowed.contains(state.method_26204())) {
                    this.passing.add(pos);
                    continue;
                }
                this.verified.add(pos);
                return false;
            }
        }
        return true;
    }

    private Set<class_2338> getOccupiedBlocks(class_243 pos) {
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        double halfWidth = this.dimensions.method_30757(pos).method_17939() / 2.0;
        double height = this.dimensions.method_30757(pos).method_17940();
        int minX = (int)Math.floor(pos.field_1352 - halfWidth);
        int maxX = (int)Math.ceil(pos.field_1352 + halfWidth);
        int minY = (int)Math.floor(pos.field_1351);
        int maxY = (int)Math.ceil(pos.field_1351 + height);
        int minZ = (int)Math.floor(pos.field_1350 - halfWidth);
        int maxZ = (int)Math.ceil(pos.field_1350 + halfWidth);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    blocks.add(new class_2338(x, y, z));
                }
            }
        }
        return blocks;
    }
}

