/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.maths;

import net.rodofire.easierworldcreator.Ewc;

public class FastMaths {
    private static final int FAST_TRIGO_TABLE_SIZE = 360;
    private static final int FAST_TABLE_SIZE = 1000;
    private static final float[] cosFastTable;
    private static final float[] sinFastTable;
    private static final float[] expFastTable;
    private static final int PRECISE_TRIGO_TABLE_SIZE = 3600;
    private static final int PRECISE_TABLE_SIZE = 10000;
    private static final float[] cosPreciseTable;
    private static final float[] sinPreciseTable;
    private static final float[] expPreciseTable;

    public static void registerMaths() {
        Ewc.LOGGER.info("|\t- Registering FastMaths");
    }

    public static float getFastSin(float angle) {
        angle = (angle % 360.0f + 360.0f) % 360.0f;
        return sinFastTable[((int)angle + 360) % 360];
    }

    public static float getFastCos(float angle) {
        return cosFastTable[((int)(angle %= 360.0f) + 360) % 360];
    }

    public static float getFastTan(float x) {
        if ((int)x % 180 == 90) {
            Ewc.LOGGER.error("thrown error, tan can't accept values equal to 90\u00b0 +- 180\u00b0 (div by 0 error)");
            return 0.0f;
        }
        return sinFastTable[(int)x % 360] / cosFastTable[(int)x % 360];
    }

    public static float getFastExp(float x) {
        if ((double)x > 10.05) {
            Ewc.LOGGER.warn("getFastExp() : too big exponential, returning real exp value");
            return (float)Math.exp(x);
        }
        return expFastTable[(int)(x * 100.0f)];
    }

    public static float getPreciseSin(float angle) {
        int angle1 = (int)(angle * 10.0f) % 3600;
        return sinPreciseTable[(angle1 + 3600) % 3600];
    }

    public static float getPreciseCos(float angle) {
        int angle1 = (int)(angle * 10.0f) % 3600;
        return cosPreciseTable[(angle1 + 3600) % 3600];
    }

    public static float getPreciseTan(float x) {
        if ((int)(x * 10.0f) % 180 == 90) {
            Ewc.LOGGER.error("getPreciseExp() :thrown error, tan can't accept values equal to 90\u00b0 +- 180\u00b0 (div by 0 error)");
            return 0.0f;
        }
        return sinPreciseTable[(int)(x * 10.0f) % 3600] / cosPreciseTable[(int)x * 10 % 3600];
    }

    public static float getPreciseExp(float x) {
        if ((double)x > 10.05) {
            Ewc.LOGGER.warn("too big exponential, returning real exp value");
            return (float)Math.exp(x);
        }
        return expPreciseTable[(int)(x * 1000.0f)];
    }

    public static float getLength(int x, int y, int z) {
        return FastMaths.getFastSqrt(x * x + y * y + z * z);
    }

    public static float getLengthWPrecision(int x, int y, int z, float precision) {
        return FastMaths.getFastSqrt(x * x + y * y + z * z, precision);
    }

    public static float getLength(float x, float y, float z) {
        return FastMaths.getFastSqrt(x * x + y * y + z * z);
    }

    public static float getLengthWPrecision(float x, float y, float z, float precision) {
        return FastMaths.getFastSqrt(x * x + y * y + z * z, precision);
    }

    public static float getLength(int x, int z) {
        return FastMaths.getFastSqrt(x * x + z * z);
    }

    public static float getLengthWPrecision(int x, int z, float precision) {
        return FastMaths.getFastSqrt(x * x + z * z, precision);
    }

    public static float getLength(float x, float z) {
        return FastMaths.getFastSqrt(x * x + z * z);
    }

    public static float getLengthWPrecision(float x, float z, float precision) {
        return FastMaths.getFastSqrt(x * x + z * z, precision);
    }

    public static float getFastSqrt(float number) {
        return FastMaths.getFastSqrt(number, 0.2f);
    }

    public static double getFastSqrt(double number) {
        return FastMaths.getFastSqrt(number, 0.2f);
    }

    public static float getFastSqrt(float number, float precision) {
        float prev;
        if (number < 0.0f) {
            throw new IllegalArgumentException("Bound must be positive inside of sqrt");
        }
        if (number == 0.0f || number == 1.0f) {
            return number;
        }
        float x = number;
        while (Math.abs((x = (x + number / x) / 2.0f) - (prev = x)) > precision) {
        }
        return x;
    }

    public static double getFastSqrt(double number, float precision) {
        double prev;
        if (number < 0.0) {
            throw new IllegalArgumentException("Bound must be positive inside of sqrt");
        }
        if (number == 0.0 || number == 1.0) {
            return number;
        }
        double x = number;
        while (Math.abs((x = (x + number / x) / 2.0) - (prev = x)) > (double)precision) {
        }
        return x;
    }

    static {
        int i;
        cosFastTable = new float[360];
        sinFastTable = new float[360];
        expFastTable = new float[1000];
        cosPreciseTable = new float[3600];
        sinPreciseTable = new float[3600];
        expPreciseTable = new float[10000];
        for (i = 0; i < 360; ++i) {
            FastMaths.cosFastTable[i] = (float)Math.cos(Math.toRadians(i));
            FastMaths.sinFastTable[i] = (float)Math.sin(Math.toRadians(i));
        }
        for (i = 0; i < 3600; ++i) {
            double a = (double)i / 10.0;
            FastMaths.cosPreciseTable[i] = (float)Math.cos(Math.toRadians(a));
            FastMaths.sinPreciseTable[i] = (float)Math.sin(Math.toRadians(a));
        }
        for (i = 0; i < 1000; ++i) {
            FastMaths.expFastTable[i] = (float)Math.exp((double)i / 100.0);
        }
        for (i = 0; i < 10000; ++i) {
            FastMaths.expPreciseTable[i] = (float)Math.exp(-Math.exp((double)i / 1000.0));
        }
    }
}

