/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.maths.equation;

public class CubicEquation {
    private static final double TWO_PI = Math.PI * 2;
    private static final double FOUR_PI = Math.PI * 4;
    public int nRoots;
    public double x1;
    public double x2;
    public double x3;

    public void solve(double a, double b, double c, double d) {
        if (a == 0.0) {
            throw new RuntimeException("Cubic.solve(): a = 0");
        }
        double denom = a;
        a = b / denom;
        b = c / denom;
        c = d / denom;
        double a_over_3 = a / 3.0;
        double Q = (3.0 * b - a * a) / 9.0;
        double Q_CUBE = Q * Q * Q;
        double R = (9.0 * a * b - 27.0 * c - 2.0 * a * a * a) / 54.0;
        double R_SQR = R * R;
        double D = Q_CUBE + R_SQR;
        if (D < 0.0) {
            this.nRoots = 3;
            double theta = Math.acos(R / Math.sqrt(-Q_CUBE));
            double SQRT_Q = Math.sqrt(-Q);
            this.x1 = 2.0 * SQRT_Q * Math.cos(theta / 3.0) - a_over_3;
            this.x2 = 2.0 * SQRT_Q * Math.cos((theta + Math.PI * 2) / 3.0) - a_over_3;
            this.x3 = 2.0 * SQRT_Q * Math.cos((theta + Math.PI * 4) / 3.0) - a_over_3;
            this.sortRoots();
        } else if (D > 0.0) {
            this.nRoots = 1;
            double SQRT_D = Math.sqrt(D);
            double S = Math.cbrt(R + SQRT_D);
            double T = Math.cbrt(R - SQRT_D);
            this.x1 = S + T - a_over_3;
            this.x2 = Double.NaN;
            this.x3 = Double.NaN;
        } else {
            this.nRoots = 3;
            double CBRT_R = Math.cbrt(R);
            this.x1 = 2.0 * CBRT_R - a_over_3;
            this.x2 = this.x3 = CBRT_R - a_over_3;
            this.sortRoots();
        }
    }

    private void sortRoots() {
        double tmp;
        if (this.x1 < this.x2) {
            tmp = this.x1;
            this.x1 = this.x2;
            this.x2 = tmp;
        }
        if (this.x2 < this.x3) {
            tmp = this.x2;
            this.x2 = this.x3;
            this.x3 = tmp;
        }
        if (this.x1 < this.x2) {
            tmp = this.x1;
            this.x1 = this.x2;
            this.x2 = tmp;
        }
    }
}

