/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.mixin.world.gen;

import com.llamalad7.mixinextras.sugar.Local;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6796;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListHelper;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.shape.block.placer.WGShapeHandler;
import net.rodofire.easierworldcreator.shape.block.placer.WGShapePlacerManager;
import net.rodofire.easierworldcreator.util.file.EwcFolderData;
import net.rodofire.easierworldcreator.util.file.FileUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2794.class})
public abstract class ChunkGeneratorMixin {
    @Unique
    WGShapePlacerManager[] placerManagers;
    @Unique
    class_6796 old;

    @Inject(method={"generateFeatures"}, at={@At(value="HEAD")})
    private void initShapeHandler(class_5281 world, class_2791 chunk, class_5138 structureAccessor, CallbackInfo ci) {
        HashSet<WGShapePlacerManager> shapePlacer = new HashSet<WGShapePlacerManager>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                class_1923 pos = new class_1923(chunk.method_12004().field_9181 + i, chunk.method_12004().field_9180 + j);
                shapePlacer.add(WGShapeHandler.decodeInformation(world, pos));
            }
        }
        this.placerManagers = shapePlacer.toArray(new WGShapePlacerManager[0]);
    }

    @Inject(method={"generateFeatures"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/gen/StructureAccessor;shouldGenerateStructures()Z")})
    private void onGenerationStep(class_5281 world, class_2791 chunk, class_5138 structureAccessor, CallbackInfo ci, @Local(ordinal=2) int k) {
        for (WGShapePlacerManager placerManager : this.placerManagers) {
            Path[] paths;
            if (placerManager == null) {
                return;
            }
            if (k >= class_2893.class_2895.values().length) {
                return;
            }
            for (Path path : paths = placerManager.getToPlace(world, class_2893.class_2895.values()[k])) {
                world.method_36972(() -> "\n\t-ewc multi-chunk feature generating: \n\t\t- " + String.valueOf(path.getFileName()) + "\n\t\t - step : generation step");
                BlockListManager manager = BlockListHelper.fromJsonPath(world, path);
                if (manager == null) continue;
                manager.placeAllNDelete(world);
                FileUtil.removeFile(path);
            }
        }
    }

    @Inject(method={"generateFeatures"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/StructureWorldAccess;setCurrentlyGeneratingStructureName(Ljava/util/function/Supplier;)V", ordinal=1)})
    private void onFeatureGenerated(class_5281 world, class_2791 chunk, class_5138 structureAccessor, CallbackInfo ci, @Local class_6796 placedFeature) {
        for (WGShapePlacerManager placerManager : this.placerManagers) {
            Path[] paths;
            if (placerManager == null) {
                return;
            }
            for (Path path : paths = placerManager.getToPlace(world, this.old, placedFeature)) {
                world.method_36972(() -> "\n\t-ewc multi-chunk feature generating: \n\t\t- " + String.valueOf(path.getFileName()) + "\n\t\t - step : feature");
                BlockListManager comparator = BlockListHelper.fromJsonPath(world, path);
                if (comparator == null) continue;
                comparator.placeAllNDelete(world);
                FileUtil.removeFile(path);
            }
        }
        this.old = placedFeature;
    }

    @Inject(method={"generateFeatures"}, at={@At(value="TAIL")})
    private void endGeneration(class_5281 world, class_2791 chunk, class_5138 structureAccessor, CallbackInfo ci) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                class_1923 pos = new class_1923(chunk.method_12004().field_9181 + i, chunk.method_12004().field_9180 + j);
                Path basePaths = EwcFolderData.getStructureDataDir(world, pos);
                try (Stream<Path> paths = Files.list(basePaths);){
                    paths.forEach(path -> {
                        if (path.toString().endsWith(".json")) {
                            BlockListManager manager = BlockListHelper.fromJsonPath(world, path);
                            if (manager == null) {
                                return;
                            }
                            world.method_36972(() -> "\n| ewc multi-chunk feature generating: \n\t- step: end generation\n\t- center chunkPos: " + chunk.method_12004().toString() + "\n\t- parent directory: " + path.getParent().getFileName().toString() + "\n\t- generating: " + String.valueOf(path.getFileName()));
                            manager.placeAllNDelete(world);
                            FileUtil.removeFile(path);
                        }
                    });
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
                try {
                    Files.delete(basePaths);
                    continue;
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                }
            }
        }
        Path managerPath = EwcFolderData.getStructureReference(world, chunk.method_12004());
        try {
            Files.delete(managerPath);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }
}

