/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.gen;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.rodofire.easierworldcreator.maths.FastMaths;
import net.rodofire.easierworldcreator.shape.block.instanciator.AbstractFillableBlockShape;
import net.rodofire.easierworldcreator.shape.block.rotations.Rotator;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import org.jetbrains.annotations.NotNull;

public class CircleGen
extends AbstractFillableBlockShape {
    private int radiusX;
    private int radiusZ;

    public CircleGen(@NotNull class_2338 pos, Rotator rotator, int radiusX, int radiusZ) {
        super(pos, rotator);
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
    }

    public CircleGen(@NotNull class_2338 pos, int radius) {
        super(pos);
        this.radiusX = radius;
        this.radiusZ = radius;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public void setRadiusX(int radiusX) {
        this.radiusX = radiusX;
    }

    public int getRadiusZ() {
        return this.radiusZ;
    }

    public void setRadiusZ(int radiusZ) {
        this.radiusZ = radiusZ;
    }

    public void addRadiusX(int radiusX) {
        this.radiusX += radiusX;
    }

    public void addRadiusY(int radiusZ) {
        this.radiusZ += radiusZ;
    }

    @Override
    public Map<class_1923, LongOpenHashSet> getShapeCoordinates() {
        if (this.getFillingType() == AbstractFillableBlockShape.Type.HALF) {
            this.setCustomFill(0.5f);
        }
        if (this.getCustomFill() > 1.0f) {
            this.setCustomFill(1.0f);
        }
        if (this.getCustomFill() < 0.0f) {
            this.setCustomFill(0.0f);
        }
        if (this.getFillingType() == AbstractFillableBlockShape.Type.EMPTY) {
            this.generateEmptyOval();
        } else {
            this.generateFullOval();
        }
        return this.chunkMap;
    }

    public void generateFullOval() {
        int radiusXSquared = this.radiusX * this.radiusX;
        int radiusZSquared = this.radiusZ * this.radiusZ;
        float innerRadiusXSquared = (1.0f - this.getCustomFill()) * (1.0f - this.getCustomFill()) * (float)this.radiusX * (float)this.radiusX;
        float innerRadiusZSquared = (1.0f - this.getCustomFill()) * (1.0f - this.getCustomFill()) * (float)this.radiusZ * (float)this.radiusZ;
        if (this.rotator == null) {
            for (float x = (float)(-this.radiusX); x <= (float)this.radiusX; x += 1.0f) {
                float x2 = x * x;
                float xSquared = x * x / (float)radiusXSquared;
                for (float z = (float)(-this.radiusZ); z <= (float)this.radiusZ; z += 1.0f) {
                    float innerZSquared;
                    float innerXSquared;
                    float z2 = z * z;
                    if (!(xSquared + z2 / (float)radiusZSquared <= 1.0f)) continue;
                    boolean bl = true;
                    if (innerRadiusXSquared != 0.0f && (innerXSquared = x2 / innerRadiusXSquared) + (innerZSquared = z2 / innerRadiusZSquared) <= 1.0f) {
                        bl = false;
                    }
                    if (!bl) continue;
                    this.modifyChunkMap(LongPosHelper.encodeBlockPos((int)((float)this.centerX + x), this.centerY, (int)((float)this.centerZ + z)));
                }
            }
        } else {
            for (float x = (float)(-this.radiusX); x <= (float)this.radiusX; x += 0.5f) {
                float x2 = x * x;
                float xSquared = x2 / (float)radiusXSquared;
                for (float z = (float)(-this.radiusZ); z <= (float)this.radiusZ; z += 0.5f) {
                    float innerZSquared;
                    float innerXSquared;
                    float z2 = z * z;
                    if (!(xSquared + z2 / (float)radiusZSquared <= 1.0f)) continue;
                    boolean bl = true;
                    if (innerRadiusXSquared != 0.0f && (innerXSquared = x2 / innerRadiusXSquared) + (innerZSquared = z2 / innerRadiusZSquared) <= 1.0f) {
                        bl = false;
                    }
                    if (!bl) continue;
                    this.modifyChunkMap(this.rotator.get(x, 0.0, z));
                }
            }
        }
    }

    public void generateEmptyOval() {
        if (this.rotator == null) {
            for (float u = 0.0f; u < 360.0f; u += 45.0f / (float)Math.max(this.radiusZ, this.radiusX)) {
                float x = (float)this.radiusX * FastMaths.getFastCos(u);
                float z = (float)this.radiusZ * FastMaths.getFastSin(u);
                this.modifyChunkMap(LongPosHelper.encodeBlockPos((int)(x + (float)this.centerX), this.centerY, (int)(z + (float)this.centerZ)));
            }
        } else {
            for (float u = 0.0f; u < 360.0f; u += 35.0f / (float)Math.max(this.radiusZ, this.radiusX)) {
                float x = (float)this.radiusX * FastMaths.getFastCos(u);
                float z = (float)this.radiusZ * FastMaths.getFastSin(u);
                this.modifyChunkMap(this.rotator.get(x, 0.0, z));
            }
        }
    }
}

