/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.gen;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.rodofire.easierworldcreator.maths.FastMaths;
import net.rodofire.easierworldcreator.shape.block.instanciator.AbstractFillableBlockShape;
import net.rodofire.easierworldcreator.shape.block.rotations.Rotator;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import org.jetbrains.annotations.NotNull;

public class CylinderGen
extends AbstractFillableBlockShape {
    private int radiusX;
    private int radiusZ;
    private int height;

    public CylinderGen(@NotNull class_2338 pos, Rotator rotator, int radiusX, int radiusZ, int height) {
        super(pos, rotator);
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
        this.height = height;
    }

    public CylinderGen(@NotNull class_2338 pos, int radius, int height) {
        super(pos);
        this.radiusX = radius;
        this.radiusZ = radius;
        this.height = height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRadiusX(int radius) {
        this.radiusX = radius;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public void setRadiusZ(int radius) {
        this.radiusZ = radius;
    }

    public int getRadiusZ() {
        return this.radiusZ;
    }

    @Override
    public Map<class_1923, LongOpenHashSet> getShapeCoordinates() {
        this.setFill();
        if (this.getFillingType() == AbstractFillableBlockShape.Type.EMPTY) {
            this.generateEmptyCylinder();
        } else {
            this.generateFullCylinder();
        }
        return this.chunkMap;
    }

    public void generateFullCylinder() {
        int radiusXSquared = this.radiusX * this.radiusX;
        int radiusZSquared = this.radiusZ * this.radiusZ;
        float innerRadiusXSquared = (1.0f - this.getCustomFill()) * (1.0f - this.getCustomFill()) * (float)this.radiusX * (float)this.radiusX;
        float innerRadiusZSquared = (1.0f - this.getCustomFill()) * (1.0f - this.getCustomFill()) * (float)this.radiusZ * (float)this.radiusZ;
        if (this.rotator == null) {
            for (float x = (float)(-this.radiusX); x <= (float)this.radiusX; x += 1.0f) {
                float x2 = x * x;
                float xSquared = x2 / (float)radiusXSquared;
                for (float z = (float)(-this.radiusZ); z <= (float)this.radiusZ; z += 1.0f) {
                    float innerZSquared;
                    float innerXSquared;
                    float z2 = z * z;
                    float zSquared = z2 / (float)radiusZSquared;
                    if (!(xSquared + zSquared <= 1.0f)) continue;
                    boolean bl = true;
                    if (innerRadiusXSquared != 0.0f && (innerXSquared = x2 / innerRadiusXSquared) + (innerZSquared = z2 / innerRadiusZSquared) <= 1.0f) {
                        bl = false;
                    }
                    if (!bl) continue;
                    for (float y = 0.0f; y <= (float)this.height; y += 1.0f) {
                        this.modifyChunkMap(LongPosHelper.encodeBlockPos((int)x + this.centerX, (int)y + this.centerY, (int)z + this.centerZ));
                    }
                }
            }
        } else {
            for (float x = (float)(-this.radiusX); x <= (float)this.radiusX; x += 0.5f) {
                float x2 = x * x;
                float xSquared = x * x / (float)radiusXSquared;
                for (float z = (float)(-this.radiusZ); z <= (float)this.radiusZ; z += 0.5f) {
                    float innerZSquared;
                    float innerXSquared;
                    float z2 = z * z;
                    boolean bl = true;
                    if (innerRadiusXSquared != 0.0f && (innerXSquared = x2 / innerRadiusXSquared) + (innerZSquared = z2 / innerRadiusZSquared) <= 1.0f) {
                        bl = false;
                    }
                    if (!bl) continue;
                    for (float y = 0.0f; y <= (float)this.height; y += 0.5f) {
                        if (!(xSquared + z * z / (float)radiusZSquared <= 1.0f)) continue;
                        this.modifyChunkMap(this.rotator.get(x, y, z));
                    }
                }
            }
        }
    }

    public void generateEmptyCylinder() {
        if (this.rotator == null) {
            for (float u = 0.0f; u < 360.0f; u += 45.0f / (float)Math.max(this.radiusZ, this.radiusX)) {
                float x = (float)this.radiusX * FastMaths.getFastCos(u);
                float z = (float)this.radiusZ * FastMaths.getFastSin(u);
                for (float y = 0.0f; y <= (float)this.height; y += 1.0f) {
                    this.modifyChunkMap(LongPosHelper.encodeBlockPos((int)((float)this.centerX + x), (int)((float)this.centerY + y), (int)((float)this.centerZ + z)));
                }
            }
        } else {
            for (float u = 0.0f; u < 360.0f; u += 35.0f / (float)Math.max(this.radiusZ, this.radiusX)) {
                float x = (float)this.radiusX * FastMaths.getFastCos(u);
                float z = (float)this.radiusZ * FastMaths.getFastSin(u);
                for (float y = 0.0f; y <= (float)this.height; y += 0.5f) {
                    this.modifyChunkMap(this.rotator.get(x, y, z));
                }
            }
        }
    }
}

