/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.gen;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.rodofire.easierworldcreator.shape.block.instanciator.AbstractBlockShape;
import net.rodofire.easierworldcreator.shape.block.rotations.Rotator;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import net.rodofire.easierworldcreator.util.WorldGenUtil;
import org.jetbrains.annotations.NotNull;

public class LineGen
extends AbstractBlockShape {
    private class_2338 secondPos;

    public LineGen(@NotNull class_2338 pos, Rotator rotator, class_2338 secondPos) {
        super(pos, rotator);
        this.secondPos = secondPos;
    }

    public LineGen(@NotNull class_2338 pos, class_2338 secondPos) {
        super(pos);
        this.secondPos = secondPos;
    }

    public class_2338 getSecondPos() {
        return this.secondPos;
    }

    public void setSecondPos(class_2338 secondPos) {
        this.secondPos = secondPos;
    }

    @Override
    public Map<class_1923, LongOpenHashSet> getShapeCoordinates() {
        class_2350 direction = WorldGenUtil.getDirection(LongPosHelper.decodeBlockPos(this.centerPos), this.secondPos);
        if (direction != null) {
            this.generateAxisLine(direction);
        } else {
            this.drawLine();
        }
        return this.chunkMap;
    }

    public void generateAxisLine(class_2350 dir) {
        int length = (int)WorldGenUtil.getDistance(LongPosHelper.decodeBlockPos(this.centerPos), this.secondPos);
        for (int i = 0; i < length; ++i) {
            this.modifyChunkMap(LongPosHelper.offset(dir, this.centerPos, i));
        }
    }

    public void drawLine() {
        int zs;
        this.modifyChunkMap(this.centerPos);
        int x1 = this.centerX;
        int y1 = this.centerY;
        int z1 = this.centerZ;
        int x2 = this.secondPos.method_10263();
        int y2 = this.secondPos.method_10264();
        int z2 = this.secondPos.method_10260();
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int xs = x1 < x2 ? 1 : -1;
        int ys = y1 < y2 ? 1 : -1;
        int n = zs = z1 < z2 ? 1 : -1;
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                x1 += xs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                this.modifyChunkMap(LongPosHelper.encodeBlockPos(x1, y1, z1));
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                y1 += ys;
                if (p1 >= 0) {
                    x1 += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                this.modifyChunkMap(LongPosHelper.encodeBlockPos(x1, y1, z1));
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                z1 += zs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                this.modifyChunkMap(LongPosHelper.encodeBlockPos(x1, y1, z1));
            }
        }
    }
}

