/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.gen;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.rodofire.easierworldcreator.Ewc;
import net.rodofire.easierworldcreator.maths.FastMaths;
import net.rodofire.easierworldcreator.shape.block.instanciator.AbstractFillableBlockShape;
import net.rodofire.easierworldcreator.shape.block.rotations.Rotator;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import org.jetbrains.annotations.NotNull;

public class SphereGen
extends AbstractFillableBlockShape {
    private int radiusX;
    private int radiusY;
    private int radiusZ;
    private SphereType halfSphere = SphereType.DEFAULT;
    private class_2350 direction = class_2350.field_11036;
    private long startTime;

    public SphereGen(@NotNull class_2338 pos, Rotator rotator, int radiusX, int radiusY, int radiusZ, SphereType halfSphere) {
        super(pos, rotator);
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        this.halfSphere = halfSphere;
    }

    public SphereGen(@NotNull class_2338 pos, int radius) {
        super(pos);
        this.radiusX = radius;
        this.radiusY = radius;
        this.radiusZ = radius;
    }

    public class_2350 getHalfSphereDirection() {
        return this.direction;
    }

    public void setHalfSphereDirection(class_2350 direction) {
        this.direction = direction;
    }

    public SphereType isHalfSphere() {
        return this.halfSphere;
    }

    public void setHalfSphere(SphereType halfSphere) {
        this.halfSphere = halfSphere;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public void setRadiusX(int radiusX) {
        this.radiusX = radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public void setRadiusY(int radiusY) {
        this.radiusY = radiusY;
    }

    public int getRadiusZ() {
        return this.radiusZ;
    }

    public void setRadiusZ(int radiusZ) {
        this.radiusZ = radiusZ;
    }

    @Override
    public Map<class_1923, LongOpenHashSet> getShapeCoordinates() {
        if (this.getFillingType() == AbstractFillableBlockShape.Type.EMPTY) {
            if (this.halfSphere == SphereType.HALF) {
                this.generateHalfEmptyEllipsoid();
            } else {
                this.generateEmptyEllipsoid();
            }
        } else if (this.halfSphere == SphereType.HALF) {
            this.generateHalfFullEllipsoid();
        } else {
            this.generateFullEllipsoid();
        }
        return this.chunkMap;
    }

    public void generateHalfEmptyEllipsoid() {
        if (this.direction == class_2350.field_11036) {
            this.generateEmptyEllipsoid(-180, 180, 0, 90);
        } else if (this.direction == class_2350.field_11033) {
            this.generateEmptyEllipsoid(-180, 180, -90, 0);
        } else if (this.direction == class_2350.field_11039) {
            this.generateEmptyEllipsoid(0, 180, -90, 90);
        } else if (this.direction == class_2350.field_11034) {
            this.generateEmptyEllipsoid(-180, 0, -90, 90);
        } else if (this.direction == class_2350.field_11043) {
            this.generateEmptyEllipsoid(-90, 90, -90, 90);
        } else {
            this.generateEmptyEllipsoid(90, 270, -90, 90);
        }
    }

    public void generateEmptyEllipsoid() {
        this.generateEmptyEllipsoid(-180, 180, -90, 90);
    }

    public void generateEmptyEllipsoid(int minLarge, int maxLarge, int minHeight, int maxHeight) {
        int maxLarge1 = Math.max(this.radiusZ, Math.max(this.radiusX, this.radiusY));
        class_2338.class_2339 mutable = new class_2338.class_2339();
        ArrayList poslist = new ArrayList();
        if (this.rotator == null) {
            for (float theta = (float)minLarge; theta <= (float)maxLarge; theta += 45.0f / (float)maxLarge1) {
                double xCosTheta = (float)this.radiusX * FastMaths.getFastCos(theta);
                double zSinTheta = (float)this.radiusZ * FastMaths.getFastSin(theta);
                for (float phi = (float)minHeight; phi <= (float)maxHeight; phi += 45.0f / (float)maxLarge1) {
                    double cosPhi = FastMaths.getFastCos(phi);
                    int x = (int)(xCosTheta * cosPhi);
                    int y = (int)((float)this.radiusY * FastMaths.getFastSin(phi));
                    int z = (int)(zSinTheta * cosPhi);
                    this.modifyChunkMap(LongPosHelper.encodeBlockPos(x + this.centerX, y + this.centerY, z + this.centerZ));
                }
            }
        } else {
            for (float theta = (float)minLarge; theta <= (float)maxLarge; theta += 45.0f / (float)maxLarge1) {
                float xCosTheta = (float)this.radiusX * FastMaths.getFastCos(theta);
                float zSinTheta = (float)this.radiusZ * FastMaths.getFastSin(theta);
                for (float phi = (float)minHeight; phi <= (float)maxHeight; phi += 45.0f / (float)maxLarge1) {
                    float cosPhi = FastMaths.getFastCos(phi);
                    float x = xCosTheta * cosPhi;
                    float y = (float)this.radiusY * FastMaths.getFastSin(phi);
                    float z = zSinTheta * cosPhi;
                    this.modifyChunkMap(this.rotator.get(x, y, z));
                }
            }
        }
    }

    public void generateHalfFullEllipsoid() {
        if (this.direction == class_2350.field_11036) {
            this.generateFullEllipsoid(-this.radiusX, this.radiusX, 0, this.radiusY, -this.radiusZ, this.radiusZ);
        } else if (this.direction == class_2350.field_11033) {
            this.generateFullEllipsoid(-this.radiusX, this.radiusX, -this.radiusY, 0, -this.radiusZ, this.radiusZ);
        } else if (this.direction == class_2350.field_11039) {
            this.generateFullEllipsoid(0, this.radiusX, -this.radiusY, this.radiusY, -this.radiusZ, this.radiusZ);
        } else if (this.direction == class_2350.field_11034) {
            this.generateFullEllipsoid(-this.radiusX, 0, -this.radiusY, this.radiusY, -this.radiusZ, this.radiusZ);
        } else if (this.direction == class_2350.field_11043) {
            this.generateFullEllipsoid(-this.radiusX, this.radiusX, -this.radiusY, this.radiusY, -this.radiusZ, 0);
        } else {
            this.generateFullEllipsoid(-this.radiusX, this.radiusX, -this.radiusY, this.radiusY, 0, this.radiusZ);
        }
    }

    public void generateFullEllipsoid() {
        this.generateFullEllipsoid(-this.radiusX, this.radiusX, -this.radiusY, this.radiusY, -this.radiusZ, this.radiusZ);
    }

    public void generateFullEllipsoid(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        this.setFill();
        int largeXSquared = this.radiusX * this.radiusX;
        int largeYSquared = this.radiusY * this.radiusY;
        int largeZSquared = this.radiusZ * this.radiusZ;
        float innerRadiusXSquared = (1.0f - this.getCustomFill()) * (1.0f - this.getCustomFill()) * (float)largeXSquared;
        float innerRadiusYSquared = (1.0f - this.getCustomFill()) * (1.0f - this.getCustomFill()) * (float)largeYSquared;
        float innerRadiusZSquared = (1.0f - this.getCustomFill()) * (1.0f - this.getCustomFill()) * (float)largeZSquared;
        if (this.radiusX > 32 || this.radiusY > 32 || this.radiusZ > 32) {
            Ewc.LOGGER.warn("generating huge sphere (diameter > 64)");
        }
        if (this.rotator == null) {
            for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
                float xx = x * x;
                float xs = xx / (float)largeXSquared;
                for (float y = (float)minY; y <= (float)maxY; y += 1.0f) {
                    float yy = y * y;
                    float ys = yy / (float)largeYSquared + xs;
                    for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                        float innerYSquared;
                        float innerZSquared;
                        float innerXSquared;
                        float zz = z * z;
                        if (!(ys + zz / (float)largeZSquared <= 1.0f)) continue;
                        boolean bl = true;
                        if (innerRadiusXSquared != 0.0f && (innerXSquared = xx / innerRadiusXSquared) + (innerZSquared = zz / innerRadiusZSquared) + (innerYSquared = yy / innerRadiusYSquared) <= 1.0f) {
                            bl = false;
                        }
                        if (!bl) continue;
                        this.modifyChunkMap(LongPosHelper.encodeBlockPos((int)((float)this.centerX + x), (int)((float)this.centerY + y), (int)((float)this.centerZ + z)));
                    }
                }
            }
        } else {
            for (float x = (float)minX; x <= (float)maxX; x += 0.5f) {
                float xx = x * x;
                float xs = xx / (float)largeXSquared;
                for (float y = (float)minY; y <= (float)maxY; y += 0.5f) {
                    float yy = y * y;
                    float ys = yy / (float)largeYSquared + xs;
                    for (float z = (float)minZ; z <= (float)maxZ; z += 0.5f) {
                        float innerYSquared;
                        float innerZSquared;
                        float innerXSquared;
                        float zz = z * z;
                        if (!(ys + zz / (float)largeZSquared <= 1.0f)) continue;
                        boolean bl = true;
                        if (innerRadiusXSquared != 0.0f && (innerXSquared = xx / innerRadiusXSquared) + (innerZSquared = zz / innerRadiusZSquared) + (innerYSquared = yy / innerRadiusYSquared) <= 1.0f) {
                            bl = false;
                        }
                        if (!bl) continue;
                        this.modifyChunkMap(this.rotator.get(x, y, z));
                    }
                }
            }
        }
    }

    public static enum SphereType {
        HALF,
        DEFAULT;

    }
}

