/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.gen;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3545;
import net.rodofire.easierworldcreator.maths.FastMaths;
import net.rodofire.easierworldcreator.shape.block.instanciator.AbstractBlockShape;
import net.rodofire.easierworldcreator.shape.block.rotations.Rotator;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import org.jetbrains.annotations.NotNull;

public class SpiralGen
extends AbstractBlockShape {
    private class_3545<Integer, Integer> radiusX;
    private class_3545<Integer, Integer> radiusZ;
    private int height;
    private int spiralOffset = 0;
    private float turnNumber = 1.0f;
    private SpiralType spiralType = SpiralType.DEFAULT;
    private float spiralFilling = 1.0f;
    private float outlineRadiusX = 1.0f;
    private float outlineRadiusZ = 1.0f;
    private class_3545<Integer, Integer> helicoidAngle = new class_3545((Object)0, (Object)0);

    public SpiralGen(@NotNull class_2338 pos, Rotator rotator, class_3545<Integer, Integer> radiusX, class_3545<Integer, Integer> radiusZ, int height, float turnNumber) {
        super(pos, rotator);
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
        this.height = height;
        this.turnNumber = turnNumber;
    }

    public SpiralGen(@NotNull class_2338 pos, int radius, int height) {
        super(pos);
        this.radiusX = new class_3545((Object)radius, (Object)radius);
        this.radiusZ = new class_3545((Object)radius, (Object)radius);
        this.height = height;
    }

    public float getOutlineRadiusZ() {
        return this.outlineRadiusZ;
    }

    public void setOutlineRadiusZ(int outlineRadiusZ) {
        this.outlineRadiusZ = outlineRadiusZ;
    }

    public float getOutlineRadiusX() {
        return this.outlineRadiusX;
    }

    public void setOutlineRadiusX(int outlineRadiusX) {
        this.outlineRadiusX = outlineRadiusX;
    }

    public float getSpiralFilling() {
        return this.spiralFilling;
    }

    public void setSpiralFilling(float spiralFilling) {
        this.spiralFilling = spiralFilling;
    }

    public SpiralType getSpiralType() {
        return this.spiralType;
    }

    public void setSpiralType(SpiralType spiralType) {
        this.spiralType = spiralType;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public class_3545<Integer, Integer> getRadiusZ() {
        return this.radiusZ;
    }

    public int getStartRadiusZ() {
        return (Integer)this.radiusZ.method_15442();
    }

    public int getStartRadiusX() {
        return (Integer)this.radiusX.method_15442();
    }

    public int getEndRadiusZ() {
        return (Integer)this.radiusZ.method_15441();
    }

    public int getEndRadiusX() {
        return (Integer)this.radiusX.method_15441();
    }

    public void setRadiusZ(class_3545<Integer, Integer> radiusZ) {
        this.radiusZ = radiusZ;
    }

    public class_3545<Integer, Integer> getRadiusX() {
        return this.radiusX;
    }

    public void setRadiusX(class_3545<Integer, Integer> radiusX) {
        this.radiusX = radiusX;
    }

    public void setEndRadiusX(int endRadiusX) {
        this.radiusX = new class_3545((Object)((Integer)this.radiusX.method_15442()), (Object)endRadiusX);
    }

    public void setEndRadiusZ(int endRadiusZ) {
        this.radiusZ = new class_3545((Object)((Integer)this.radiusZ.method_15442()), (Object)endRadiusZ);
    }

    public void setStartRadiusX(int startRadiusX) {
        this.radiusX = new class_3545((Object)startRadiusX, (Object)((Integer)this.radiusX.method_15441()));
    }

    public void setStartRadiusZ(int startRadiusZ) {
        this.radiusZ = new class_3545((Object)startRadiusZ, (Object)((Integer)this.radiusZ.method_15441()));
    }

    public float getTurnNumber() {
        return this.turnNumber;
    }

    public void setTurnNumber(float turnNumber) {
        this.turnNumber = turnNumber;
    }

    public int getSpiralOffset() {
        return this.spiralOffset;
    }

    public void setSpiralOffset(int spiralOffset) {
        this.spiralOffset = spiralOffset;
    }

    public class_3545<Integer, Integer> getHelicoidAngle() {
        return this.helicoidAngle;
    }

    public void setHelicoidAngle(class_3545<Integer, Integer> helicoidAngle) {
        this.helicoidAngle = helicoidAngle;
    }

    @Override
    public Map<class_1923, LongOpenHashSet> getShapeCoordinates() {
        this.getFilling();
        switch (this.spiralType.ordinal()) {
            case 0: {
                this.generateEllipsoidSpiral(new class_2338(0, 0, 0));
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.generateHelicoid();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.generateHelicoid();
                this.spiralOffset = 180;
                this.generateHelicoid();
                break;
            }
            case 7: {
                this.generateLargeOutlineSpiral();
                break;
            }
            case 8: {
                float intermediateOutlineX = this.outlineRadiusX;
                float intermediateOutlineZ = this.outlineRadiusZ;
                float max = Math.max(intermediateOutlineX, intermediateOutlineZ);
                for (float i = 0.0f; i < max; i += 0.5f) {
                    this.outlineRadiusX = i * intermediateOutlineX / max;
                    this.outlineRadiusZ = i * intermediateOutlineZ / max;
                    this.generateLargeOutlineSpiral();
                }
                break;
            }
        }
        return this.chunkMap;
    }

    public void generateEllipsoidSpiral(class_2338 pos) {
        int maxLarge = Math.max(Math.max((Integer)this.radiusX.method_15442(), (Integer)this.radiusX.method_15441()), Math.max((Integer)this.radiusZ.method_15442(), (Integer)this.radiusZ.method_15441()));
        float f = this.turnNumber * (float)maxLarge;
        float a = 360.0f / (float)(this.height * maxLarge);
        float limit = (float)maxLarge * this.turnNumber * (float)this.height;
        if (this.rotator == null) {
            for (float i = 0.0f; i < limit; i += 1.0f) {
                float ai = a * i + (float)this.spiralOffset;
                float percentage = i / limit;
                float radiusX = this.getXRadius(percentage);
                float radiusZ = this.getZRadius(percentage);
                int x = (int)(radiusX * FastMaths.getFastCos(ai));
                int z = (int)(radiusZ * FastMaths.getFastSin(ai));
                int y = (int)(i / f);
                this.modifyChunkMap(LongPosHelper.encodeBlockPos(x + this.centerX + pos.method_10263(), y + this.centerY, z + this.centerZ + pos.method_10260()));
            }
        } else {
            for (float i = 0.0f; i < limit; i += 0.5f) {
                float ai = a * i + (float)this.spiralOffset;
                float percentage = i / limit;
                float radiusX = this.getXRadius(percentage);
                float radiusZ = this.getZRadius(percentage);
                float x = radiusX * FastMaths.getFastCos(ai);
                float z = radiusZ * FastMaths.getFastSin(ai);
                float y = i / f;
                this.modifyChunkMap(this.rotator.get(x + (float)pos.method_10263(), y, z + (float)pos.method_10260()));
            }
        }
    }

    public void generateLargeOutlineSpiral() {
        float angle = (float)Math.atan((float)this.height / this.turnNumber);
        int degAngle = (int)Math.toDegrees(angle);
        class_243 vec = new class_243((double)FastMaths.getFastCos(degAngle), (double)FastMaths.getFastSin(degAngle), 0.0).method_1029();
        double cosY = FastMaths.getFastCos(degAngle);
        double sinY = FastMaths.getFastSin(degAngle);
        float maxLarge = Math.max(this.outlineRadiusX, this.outlineRadiusZ);
        for (float i = 0.0f; i < 360.0f; i += 45.0f / maxLarge) {
            double x = this.outlineRadiusX * FastMaths.getFastCos(i);
            double z = this.outlineRadiusZ * FastMaths.getFastSin(i);
            this.generateEllipsoidSpiral(this.rotator.getRawBlockPos((float)x, 0.0f, (float)z));
        }
    }

    public void generateHelicoid() {
        int maxLarge = Math.max(Math.max((Integer)this.radiusX.method_15442(), (Integer)this.radiusX.method_15441()), Math.max((Integer)this.radiusZ.method_15442(), (Integer)this.radiusZ.method_15441()));
        float f = this.turnNumber * (float)maxLarge;
        float a = 360.0f / (float)(this.height * maxLarge);
        float limit = (float)maxLarge * this.turnNumber * (float)this.height;
        if (this.rotator == null && (Integer)this.helicoidAngle.method_15442() < 45 && (Integer)this.helicoidAngle.method_15442() > -45 && (Integer)this.helicoidAngle.method_15441() < 45 && (Integer)this.helicoidAngle.method_15441() > -45) {
            for (float i = 0.0f; i < limit; i += 1.0f) {
                float ai = a * i + (float)this.spiralOffset;
                float percentage = i / limit;
                float radiusX = this.getXRadius(percentage);
                float radiusZ = this.getZRadius(percentage);
                float gainX = radiusX / (float)maxLarge;
                float gainZ = radiusZ / (float)maxLarge;
                float innerRadiusX = (1.0f - this.spiralFilling) * radiusX;
                float innerRadiusZ = (1.0f - this.spiralFilling) * radiusZ;
                float innerRadiusXSquared = innerRadiusX * innerRadiusX;
                float innerRadiusZSquared = innerRadiusZ * innerRadiusZ;
                int helicoidAngle = this.getAngle(percentage);
                float xpr = gainX * FastMaths.getFastCos(ai);
                float zpr = gainZ * FastMaths.getFastSin(ai);
                for (float j = 0.0f; j <= (float)maxLarge; j += 1.0f) {
                    float innerZSquared;
                    float innerXSquared;
                    int x = (int)(xpr * j);
                    int z = (int)(zpr * j);
                    double distance = FastMaths.getLength(x, z);
                    boolean bl = true;
                    if (innerRadiusXSquared != 0.0f && (innerXSquared = (float)(x * x) / innerRadiusXSquared) + (innerZSquared = (float)(z * z) / innerRadiusZSquared) <= 1.0f) {
                        bl = false;
                    }
                    if (!bl) continue;
                    int y = (int)((double)((int)(i / f)) + distance * (double)FastMaths.getFastSin(helicoidAngle));
                    this.modifyChunkMap(LongPosHelper.encodeBlockPos(x + this.centerX, y + this.centerY, z + this.centerZ));
                }
            }
        } else {
            for (float i = 0.0f; i < limit; i += 0.25f) {
                float ai = a * i + (float)this.spiralOffset;
                float percentage = i / limit;
                float radiusX = this.getXRadius(percentage);
                float radiusZ = this.getZRadius(percentage);
                float gainX = radiusX / (float)maxLarge;
                float gainZ = radiusZ / (float)maxLarge;
                float innerRadiusX = (1.0f - this.spiralFilling) * radiusX;
                float innerRadiusZ = (1.0f - this.spiralFilling) * radiusZ;
                float innerRadiusXSquared = innerRadiusX * innerRadiusX;
                float innerRadiusZSquared = innerRadiusZ * innerRadiusZ;
                int helicoidAngle = this.getAngle(percentage);
                float xpr = gainX * FastMaths.getFastCos(ai);
                float zpr = gainZ * FastMaths.getFastSin(ai);
                for (float j = 0.0f; j <= (float)maxLarge; j += 1.0f) {
                    float innerZSquared;
                    float innerXSquared;
                    float x = xpr * j;
                    float z = zpr * j;
                    float distance = FastMaths.getLength(x, z);
                    boolean bl = true;
                    if (innerRadiusXSquared != 0.0f && (innerXSquared = x * x / innerRadiusXSquared) + (innerZSquared = z * z / innerRadiusZSquared) <= 1.0f) {
                        bl = false;
                    }
                    if (!bl) continue;
                    float y = i / f + distance * FastMaths.getFastSin(helicoidAngle);
                    this.modifyChunkMap(this.rotator.get(x, y, z));
                }
            }
        }
    }

    private void getFilling() {
        if (this.spiralType == SpiralType.HELICOID || this.spiralType == SpiralType.DOUBLE_HELICOID) {
            this.spiralFilling = 1.0f;
        } else if (this.spiralType == SpiralType.HALF_HELICOID || this.spiralType == SpiralType.HALF_DOUBLE_HELICOID) {
            this.spiralFilling = 0.5f;
        }
    }

    public float getXRadius(float percentage) {
        return (int)((float)((Integer)this.radiusX.method_15442()).intValue() * (1.0f - percentage) + (float)((Integer)this.radiusZ.method_15441()).intValue() * percentage);
    }

    public float getZRadius(float percentage) {
        return (int)((float)((Integer)this.radiusZ.method_15442()).intValue() * (1.0f - percentage) + (float)((Integer)this.radiusZ.method_15441()).intValue() * percentage);
    }

    public int getAngle(float percentage) {
        return (int)((float)((Integer)this.helicoidAngle.method_15442()).intValue() * (1.0f - percentage) + (float)((Integer)this.helicoidAngle.method_15441()).intValue() * percentage);
    }

    public static enum SpiralType {
        DEFAULT,
        HELICOID,
        HALF_HELICOID,
        CUSTOM_HELICOID,
        DOUBLE_HELICOID,
        HALF_DOUBLE_HELICOID,
        CUSTOM_DOUBLE_HELICOID,
        LARGE_OUTLINE,
        FULL_LARGE_OUTLINE;

    }
}

