/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.gen;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.rodofire.easierworldcreator.maths.FastMaths;
import net.rodofire.easierworldcreator.shape.block.instanciator.AbstractFillableBlockShape;
import net.rodofire.easierworldcreator.shape.block.rotations.Rotator;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import org.jetbrains.annotations.NotNull;

public class TorusGen
extends AbstractFillableBlockShape {
    private int innerRadiusX;
    private int outerRadiusX;
    private int innerRadiusZ;
    private int outerRadiusZ;
    private TorusType torusType = TorusType.FULL;
    private float verticalTorus = 1.0f;
    private float horizontalTorus = 1.0f;
    private float outerSquared;
    float outerXSquared;
    float outerZSquared;
    float innerSquared;
    float innerXSquared;
    float innerZSquared;

    public TorusGen(@NotNull class_2338 pos, Rotator rotator, int innerRadiusX, int outerRadiusX, int innerRadiusZ, int outerRadiusZ) {
        super(pos, rotator);
        this.innerRadiusX = innerRadiusX;
        this.outerRadiusX = outerRadiusX;
        this.innerRadiusZ = innerRadiusZ;
        this.outerRadiusZ = outerRadiusZ;
        this.init();
    }

    public TorusGen(@NotNull class_2338 pos, int innerRadius, int outerRadius) {
        super(pos);
        this.innerRadiusX = innerRadius;
        this.outerRadiusX = outerRadius;
        this.innerRadiusZ = innerRadius;
        this.outerRadiusZ = outerRadius;
        this.init();
    }

    private void init() {
        this.outerSquared = this.outerRadiusX * this.outerRadiusZ;
        this.outerXSquared = this.outerRadiusX * this.outerRadiusX;
        this.outerZSquared = this.outerRadiusZ * this.outerRadiusZ;
        this.innerSquared = this.innerRadiusX * this.innerRadiusZ;
        this.innerXSquared = this.innerRadiusX * this.innerRadiusX;
        this.innerZSquared = this.innerRadiusZ * this.innerRadiusZ;
    }

    public int getInnerRadiusX() {
        return this.innerRadiusX;
    }

    public void setInnerRadiusX(int innerRadiusX) {
        this.innerRadiusX = innerRadiusX;
        this.init();
    }

    public int getOuterRadiusX() {
        return this.outerRadiusX;
    }

    public void setOuterRadiusX(int outerRadiusX) {
        this.outerRadiusX = outerRadiusX;
        this.init();
    }

    public int getInnerRadiusZ() {
        return this.innerRadiusZ;
    }

    public void setInnerRadiusZ(int innerRadiusZ) {
        this.innerRadiusZ = innerRadiusZ;
        this.init();
    }

    public int getOuterRadiusZ() {
        return this.outerRadiusZ;
    }

    public void setOuterRadiusZ(int outerRadiusZ) {
        this.outerRadiusZ = outerRadiusZ;
        this.init();
    }

    public TorusType getTorusType() {
        return this.torusType;
    }

    public void setTorusType(TorusType torusType) {
        this.torusType = torusType;
    }

    public float getVerticalTorus() {
        return this.verticalTorus;
    }

    public void setVerticalTorus(float verticalTorus) {
        this.verticalTorus = verticalTorus;
    }

    public float getHorizontalTorus() {
        return this.horizontalTorus;
    }

    public void setHorizontalTorus(float horizontalTorus) {
        this.horizontalTorus = horizontalTorus;
    }

    @Override
    public Map<class_1923, LongOpenHashSet> getShapeCoordinates() {
        this.setTorusFill();
        if (this.getFillingType() == AbstractFillableBlockShape.Type.EMPTY) {
            this.generateEmptyTore();
        } else {
            this.generateFullTore();
        }
        return this.chunkMap;
    }

    public void generateFullTore() {
        this.setFill();
        int maxInnerRadiusX = Math.max(this.innerRadiusX, this.innerRadiusZ);
        int maxOuterRadiusX = Math.max(this.outerRadiusX, this.outerRadiusZ);
        int b = maxOuterRadiusX + maxInnerRadiusX;
        if (this.rotator == null) {
            int x = -b;
            while ((float)x <= (float)(2 * b) * this.horizontalTorus - (float)b) {
                int xSquared = x * x;
                for (int z = -b; z <= b; ++z) {
                    int zSquared = z * z;
                    float angle = (float)Math.toDegrees(Math.atan2(z, x));
                    double outerRadius = this.getOuterRadius(angle);
                    double innerRadius = this.getInnerRadius(angle);
                    int squaredSum = xSquared + zSquared;
                    int outerRadiusSquared = (int)(outerRadius * outerRadius);
                    int innerRadiusSquared = (int)(innerRadius * innerRadius);
                    int a1 = squaredSum + outerRadiusSquared - innerRadiusSquared;
                    int e = 4 * outerRadiusSquared * squaredSum;
                    int y = -b;
                    while ((float)y <= (float)(2 * b) * this.verticalTorus - (float)b) {
                        boolean bl;
                        int ySquared = y * y;
                        int a = a1 + ySquared;
                        if (a * a - e <= 0 && (bl = true)) {
                            this.modifyChunkMap(LongPosHelper.encodeBlockPos(x + this.centerX, y + this.centerY, z + this.centerZ));
                        }
                        ++y;
                    }
                }
                ++x;
            }
        } else {
            float max = (float)(2 * b) * this.verticalTorus - (float)b;
            for (float x = (float)(-b); x <= max; x += 0.5f) {
                float xSquared = x * x;
                for (float z = (float)(-b); z <= (float)b; z += 0.5f) {
                    float zSquared = z * z;
                    float angle = (float)Math.toDegrees(Math.atan2(z, x));
                    double outerRadius = this.getOuterRadius(angle);
                    double innerRadius = this.getInnerRadius(angle);
                    int outerRadiusSquared = (int)(outerRadius * outerRadius);
                    int innerRadiusSquared = (int)(innerRadius * innerRadius);
                    float squaredSum = xSquared + zSquared;
                    float a1 = squaredSum + (float)outerRadiusSquared - (float)innerRadiusSquared;
                    float e = (float)(4 * outerRadiusSquared) * squaredSum;
                    for (float y = (float)(-b); y <= max; y += 0.5f) {
                        boolean bl;
                        float ySquared = y * y;
                        float a = a1 + ySquared;
                        if (!(a * a - e <= 0.0f) || !(bl = true)) continue;
                        this.modifyChunkMap(this.rotator.get(x, y, z));
                    }
                }
            }
        }
    }

    public void generateEmptyTore() {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        ArrayList poslist = new ArrayList();
        int maxOuterRadius = Math.max(this.outerRadiusX, this.outerRadiusZ);
        int maxInnerRadius = Math.max(this.innerRadiusX, this.innerRadiusZ);
        if (this.rotator == null) {
            int u = 0;
            while ((float)u <= this.verticalTorus * 360.0f) {
                int v = 0;
                while ((float)v <= this.horizontalTorus * 360.0f) {
                    float[] vec = this.getEllipsoidalToreCoordinates(u, v);
                    this.modifyChunkMap(LongPosHelper.encodeBlockPos((int)((float)this.centerX + vec[0]), (int)((float)this.centerY + vec[1]), (int)((float)this.centerZ + vec[3])));
                    v += 45 / maxInnerRadius;
                }
                u += 40 / maxOuterRadius;
            }
        } else {
            float maxOuter = 40.0f / ((float)maxOuterRadius * 1.3f);
            float maxInner = 45.0f / ((float)maxInnerRadius * 1.3f);
            for (float u = 0.0f; u <= 360.0f * this.verticalTorus; u += maxOuter) {
                for (float v = 0.0f; v <= 360.0f * this.horizontalTorus; v += maxInner) {
                    double[] vec = this.getPreciseToreCoordinates(u, v);
                    this.modifyChunkMap(this.rotator.get(vec[0], vec[1], vec[2]));
                }
            }
        }
    }

    private void setTorusFill() {
        switch (this.torusType.ordinal()) {
            case 0: {
                this.verticalTorus = 1.0f;
                this.horizontalTorus = 1.0f;
                break;
            }
            case 2: {
                this.horizontalTorus = 0.5f;
                this.verticalTorus = 1.0f;
                break;
            }
            case 1: {
                this.verticalTorus = 0.5f;
                this.horizontalTorus = 1.0f;
                break;
            }
            case 4: {
                this.verticalTorus = 1.0f;
                break;
            }
            case 3: {
                this.horizontalTorus = 1.0f;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.torusType));
            }
        }
    }

    private double[] getPreciseToreCoordinates(float u, float v) {
        double sinU = FastMaths.getPreciseSin(u);
        double R = (double)this.outerRadiusX + (double)(this.outerRadiusZ - this.outerRadiusX) * Math.abs(sinU);
        double r = (double)this.innerRadiusX + (double)(this.innerRadiusZ - this.innerRadiusX) * Math.abs(sinU);
        double a = R + r * (double)FastMaths.getPreciseCos(v);
        double x = a * (double)FastMaths.getPreciseCos(u);
        double z = a * sinU;
        double y = r * (double)FastMaths.getPreciseSin(v);
        return new double[]{x, y, z};
    }

    public float[] getEllipsoidalToreCoordinates(int u, int v) {
        double R = (float)this.outerRadiusX + (float)(this.outerRadiusZ - this.outerRadiusX) * Math.abs(FastMaths.getFastSin(u));
        double r = (float)this.innerRadiusX + (float)(this.innerRadiusZ - this.innerRadiusX) * Math.abs(FastMaths.getFastSin(u));
        double a = R + r * (double)FastMaths.getFastCos(v);
        float x = (float)(a * (double)FastMaths.getFastCos(u));
        float z = (float)(a * (double)FastMaths.getFastSin(u));
        float y = (float)(r * (double)FastMaths.getFastSin(v));
        return new float[]{x, y, z};
    }

    public double getInnerRadius(float angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        return (double)this.innerSquared / FastMaths.getFastSqrt((double)this.innerXSquared * sinAngle * sinAngle + (double)this.innerZSquared * cosAngle * cosAngle, 0.01f);
    }

    public double getOuterRadius(float angle) {
        double cosAngle = FastMaths.getFastCos(angle);
        double sinAngle = FastMaths.getFastSin(angle);
        return (double)this.outerSquared / FastMaths.getFastSqrt((double)this.outerXSquared * sinAngle * sinAngle + (double)this.outerZSquared * cosAngle * cosAngle, 0.01f);
    }

    public static enum TorusType {
        FULL,
        VERTICAL_HALF,
        HORIZONTAL_HALF,
        VERTICAL_CUSTOM,
        HORIZONTAL_CUSTOM,
        CUSTOM;

    }
}

