/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.instanciator;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.rodofire.easierworldcreator.shape.block.rotations.Rotator;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlockShape {
    protected long centerPos;
    protected int centerX;
    protected int centerY;
    protected int centerZ;
    protected Rotator rotator;
    protected Map<class_1923, LongOpenHashSet> chunkMap = new HashMap<class_1923, LongOpenHashSet>();
    MutableObject<class_1923> lastChunkPos = new MutableObject(null);
    MutableObject<LongOpenHashSet> lastSet = new MutableObject(null);

    public AbstractBlockShape(@NotNull class_2338 centerPos) {
        this.centerPos = LongPosHelper.encodeBlockPos(centerPos);
        this.setCenterPos();
    }

    public AbstractBlockShape(class_2338 centerPos, Rotator rotator) {
        this.centerPos = LongPosHelper.encodeBlockPos(centerPos);
        this.rotator = rotator;
        this.setCenterPos();
    }

    public void setRotator(Rotator rotator) {
        this.rotator = rotator;
    }

    public abstract Map<class_1923, LongOpenHashSet> getShapeCoordinates();

    private void setCenterPos() {
        this.centerX = LongPosHelper.decodeX(this.centerPos);
        this.centerY = LongPosHelper.decodeY(this.centerPos);
        this.centerZ = LongPosHelper.decodeZ(this.centerPos);
    }

    protected void modifyChunkMap(long pos) {
        class_1923 chunkPos = LongPosHelper.getChunkPos(pos);
        if (!chunkPos.equals(this.lastChunkPos.getValue())) {
            this.lastChunkPos.setValue((Object)chunkPos);
            this.lastSet.setValue((Object)this.chunkMap.computeIfAbsent(chunkPos, k -> new LongOpenHashSet()));
        }
        ((LongOpenHashSet)this.lastSet.getValue()).add(pos);
    }
}

