/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.layer;

import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.blockdata.WorldStateCollector;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.DividedBlockListManager;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayer;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayerManager;
import net.rodofire.easierworldcreator.shape.block.layer.AbstractLayer;
import net.rodofire.easierworldcreator.util.LongPosHelper;

public abstract class AbstractRadialLikeLayer
extends AbstractLayer {
    AbstractRadialLikeLayer(BlockLayerManager blockLayer, class_243 center, class_2382 direction) {
        super(blockLayer, center, direction);
    }

    AbstractRadialLikeLayer(BlockLayerManager blockLayer, class_243 center) {
        super(blockLayer, center);
    }

    @Override
    public BlockListManager get(Map<class_1923, LongOpenHashSet> posMap) {
        BlockListManager manager = new BlockListManager();
        int[] layerDistance = new int[this.blockLayer.size()];
        layerDistance[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posMap.size(), Runtime.getRuntime().availableProcessors())));
        for (LongOpenHashSet set : posMap.values()) {
            futures.add(CompletableFuture.runAsync(() -> {
                BlockListManager manager1 = new BlockListManager();
                Object object = set.iterator();
                while (object.hasNext()) {
                    long pos = (Long)object.next();
                    float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
                    int index = this.findLayerIndex(layerDistance, distance);
                    BlockLayer layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                    class_2680 state = layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos));
                    manager1.put(state, pos);
                }
                object = manager;
                synchronized (object) {
                    manager.put(manager1);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public void place(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        int[] layerDistance = new int[this.blockLayer.size()];
        layerDistance[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
        }
        for (LongOpenHashSet set : posMap.values()) {
            LongIterator longIterator = set.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
                int index = this.findLayerIndex(layerDistance, distance);
                BlockLayer layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                layer.getPlacer().place(world, layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos), layer.getRuler());
            }
        }
    }

    @Override
    public BlockListManager getVerified(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            for (LongOpenHashSet posList : posMap.values()) {
                worldStates.collect(world1, posList);
            }
            BlockListManager manager = new BlockListManager();
            int[] layerDistance = new int[this.blockLayer.size()];
            layerDistance[0] = this.blockLayer.get(0).getDepth();
            for (int i = 1; i < this.blockLayer.size(); ++i) {
                layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posMap.size(), Runtime.getRuntime().availableProcessors())));
            for (LongOpenHashSet set : posMap.values()) {
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockListManager manager1 = new BlockListManager();
                    Object object = set.iterator();
                    while (object.hasNext()) {
                        BlockLayer layer;
                        long pos = (Long)object.next();
                        float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
                        int index = this.findLayerIndex(layerDistance, distance);
                        BlockLayer blockLayer = layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                        if (!layer.getRuler().canPlace(worldStates.getState(pos))) continue;
                        class_2680 state = layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos));
                        manager1.put(state, pos);
                    }
                    object = manager;
                    synchronized (object) {
                        manager.put(manager1);
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    @Override
    public DividedBlockListManager getDivided(Map<class_1923, LongOpenHashSet> posMap) {
        DividedBlockListManager manager = new DividedBlockListManager();
        int[] layerDistance = new int[this.blockLayer.size()];
        layerDistance[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posMap.size(), Runtime.getRuntime().availableProcessors())));
        for (Map.Entry<class_1923, LongOpenHashSet> set : posMap.entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                BlockListManager manager1 = new BlockListManager();
                Object object = ((LongOpenHashSet)set.getValue()).iterator();
                while (object.hasNext()) {
                    long pos = (Long)object.next();
                    float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
                    int index = this.findLayerIndex(layerDistance, distance);
                    BlockLayer layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                    class_2680 state = layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos));
                    manager1.put(state, pos);
                }
                object = manager;
                synchronized (object) {
                    manager.putWithoutVerification((class_1923)set.getKey(), manager1);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public DividedBlockListManager getVerifiedDivided(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            for (LongOpenHashSet posList : posMap.values()) {
                worldStates.collect(world1, posList);
            }
            DividedBlockListManager manager = new DividedBlockListManager();
            int[] layerDistance = new int[this.blockLayer.size()];
            layerDistance[0] = this.blockLayer.get(0).getDepth();
            for (int i = 1; i < this.blockLayer.size(); ++i) {
                layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posMap.size(), Runtime.getRuntime().availableProcessors())));
            for (Map.Entry<class_1923, LongOpenHashSet> set : posMap.entrySet()) {
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockListManager manager1 = new BlockListManager();
                    Object object = ((LongOpenHashSet)set.getValue()).iterator();
                    while (object.hasNext()) {
                        BlockLayer layer;
                        long pos = (Long)object.next();
                        float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
                        int index = this.findLayerIndex(layerDistance, distance);
                        BlockLayer blockLayer = layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                        if (!layer.getRuler().canPlace(worldStates.getState(pos))) continue;
                        class_2680 state = layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos));
                        manager1.put(state, pos);
                    }
                    object = manager;
                    synchronized (object) {
                        manager.putWithoutVerification((class_1923)set.getKey(), manager1);
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    @Override
    public <T extends Collection<class_2338>> BlockListManager get(T posList) {
        BlockListManager manager = new BlockListManager();
        int[] layerDistance = new int[this.blockLayer.size()];
        layerDistance[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posList.size(), Runtime.getRuntime().availableProcessors())));
        for (class_2338 pos : posList) {
            futures.add(CompletableFuture.runAsync(() -> {
                float distance = this.getDistance(pos.method_10263(), pos.method_10264(), pos.method_10260());
                int index = this.findLayerIndex(layerDistance, distance);
                BlockLayer layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                class_2680 state = layer.getPlacer().get(layer.getBlockStates(), pos);
                BlockListManager blockListManager = manager;
                synchronized (blockListManager) {
                    manager.put(state, pos);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public <T extends Collection<class_2338>> void place(class_5281 world, T posList) {
        int[] layerDistance = new int[this.blockLayer.size()];
        layerDistance[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
        }
        for (class_2338 pos : posList) {
            float distance = this.getDistance(pos.method_10263(), pos.method_10264(), pos.method_10260());
            int index = this.findLayerIndex(layerDistance, distance);
            BlockLayer layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
            layer.getPlacer().place(world, layer.getBlockStates(), pos, layer.getRuler());
        }
    }

    @Override
    public <T extends Collection<class_2338>> BlockListManager getVerified(class_5281 world, T posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            BlockListManager manager = new BlockListManager();
            int[] layerDistance = new int[this.blockLayer.size()];
            layerDistance[0] = this.blockLayer.get(0).getDepth();
            for (int i = 1; i < this.blockLayer.size(); ++i) {
                layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posList.size(), Runtime.getRuntime().availableProcessors())));
            for (class_2338 pos : posList) {
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockLayer layer;
                    float distance = this.getDistance(pos.method_10263(), pos.method_10264(), pos.method_10260());
                    int index = this.findLayerIndex(layerDistance, distance);
                    BlockLayer blockLayer = layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                    if (layer.getRuler().canPlace(worldStates.getState(LongPosHelper.encodeBlockPos(pos)))) {
                        class_2680 state = layer.getPlacer().get(layer.getBlockStates(), pos);
                        BlockListManager blockListManager = manager;
                        synchronized (blockListManager) {
                            manager.put(state, pos);
                        }
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    @Override
    public <T extends Collection<class_2338>> DividedBlockListManager getDivided(T posList) {
        DividedBlockListManager manager = new DividedBlockListManager();
        int[] layerDistance = new int[this.blockLayer.size()];
        layerDistance[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posList.size(), Runtime.getRuntime().availableProcessors())));
        for (class_2338 pos : posList) {
            futures.add(CompletableFuture.runAsync(() -> {
                float distance = this.getDistance(pos.method_10263(), pos.method_10264(), pos.method_10260());
                int index = this.findLayerIndex(layerDistance, distance);
                BlockLayer layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                class_2680 state = layer.getPlacer().get(layer.getBlockStates(), pos);
                DividedBlockListManager dividedBlockListManager = manager;
                synchronized (dividedBlockListManager) {
                    manager.put(state, pos);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public <T extends Collection<class_2338>> DividedBlockListManager getVerifiedDivided(class_5281 world, T posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            DividedBlockListManager manager = new DividedBlockListManager();
            int[] layerDistance = new int[this.blockLayer.size()];
            layerDistance[0] = this.blockLayer.get(0).getDepth();
            for (int i = 1; i < this.blockLayer.size(); ++i) {
                layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posList.size(), Runtime.getRuntime().availableProcessors())));
            for (class_2338 pos : posList) {
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockLayer layer;
                    float distance = this.getDistance(pos.method_10263(), pos.method_10264(), pos.method_10260());
                    int index = this.findLayerIndex(layerDistance, distance);
                    BlockLayer blockLayer = layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                    if (layer.getRuler().canPlace(worldStates.getState(LongPosHelper.encodeBlockPos(pos)))) {
                        class_2680 state = layer.getPlacer().get(layer.getBlockStates(), pos);
                        DividedBlockListManager dividedBlockListManager = manager;
                        synchronized (dividedBlockListManager) {
                            manager.put(state, pos);
                        }
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    @Override
    public <U extends AbstractLongCollection> BlockListManager get(U posList) {
        BlockListManager manager = new BlockListManager();
        int[] layerDistance = new int[this.blockLayer.size()];
        layerDistance[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posList.size(), Runtime.getRuntime().availableProcessors())));
        LongIterator longIterator = posList.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            futures.add(CompletableFuture.runAsync(() -> {
                float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
                int index = this.findLayerIndex(layerDistance, distance);
                BlockLayer layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                class_2680 state = layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos));
                BlockListManager blockListManager = manager;
                synchronized (blockListManager) {
                    manager.put(state, pos);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public <U extends AbstractLongCollection> void place(class_5281 world, U posList) {
        int[] layerDistance = new int[this.blockLayer.size()];
        layerDistance[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
        }
        LongIterator longIterator = posList.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
            int index = this.findLayerIndex(layerDistance, distance);
            BlockLayer layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
            layer.getPlacer().place(world, layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos), layer.getRuler());
        }
    }

    @Override
    public <U extends AbstractLongCollection> BlockListManager getVerified(class_5281 world, U posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            BlockListManager manager = new BlockListManager();
            int[] layerDistance = new int[this.blockLayer.size()];
            layerDistance[0] = this.blockLayer.get(0).getDepth();
            for (int i = 1; i < this.blockLayer.size(); ++i) {
                layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posList.size(), Runtime.getRuntime().availableProcessors())));
            LongIterator longIterator = posList.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockLayer layer;
                    float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
                    int index = this.findLayerIndex(layerDistance, distance);
                    BlockLayer blockLayer = layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                    if (layer.getRuler().canPlace(worldStates.getState(pos))) {
                        class_2680 state = layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos));
                        BlockListManager blockListManager = manager;
                        synchronized (blockListManager) {
                            manager.put(state, pos);
                        }
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    @Override
    public <U extends AbstractLongCollection> DividedBlockListManager getDivided(U posList) {
        DividedBlockListManager manager = new DividedBlockListManager();
        int[] layerDistance = new int[this.blockLayer.size()];
        layerDistance[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posList.size(), Runtime.getRuntime().availableProcessors())));
        LongIterator longIterator = posList.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            futures.add(CompletableFuture.runAsync(() -> {
                float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
                int index = this.findLayerIndex(layerDistance, distance);
                BlockLayer layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                class_2680 state = layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos));
                DividedBlockListManager dividedBlockListManager = manager;
                synchronized (dividedBlockListManager) {
                    manager.put(state, pos);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public <U extends AbstractLongCollection> DividedBlockListManager getVerifiedDivided(class_5281 world, U posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            DividedBlockListManager manager = new DividedBlockListManager();
            int[] layerDistance = new int[this.blockLayer.size()];
            layerDistance[0] = this.blockLayer.get(0).getDepth();
            for (int i = 1; i < this.blockLayer.size(); ++i) {
                layerDistance[i] = this.blockLayer.get(i).getDepth() + layerDistance[i - 1];
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(2, Math.min(posList.size(), Runtime.getRuntime().availableProcessors())));
            LongIterator longIterator = posList.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockLayer layer;
                    float distance = this.getDistance(LongPosHelper.decodeBlockPos2Array(pos));
                    int index = this.findLayerIndex(layerDistance, distance);
                    BlockLayer blockLayer = layer = index >= 0 ? this.blockLayer.get(index) : this.blockLayer.get(0);
                    if (layer.getRuler().canPlace(worldStates.getState(pos))) {
                        class_2680 state = layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos));
                        DividedBlockListManager dividedBlockListManager = manager;
                        synchronized (dividedBlockListManager) {
                            manager.put(state, pos);
                        }
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    protected abstract float getDistance(int[] var1);

    protected abstract float getDistance(int var1, int var2, int var3);

    protected abstract int findLayerIndex(int[] var1, float var2);
}

