/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.layer;

import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.blockdata.WorldStateCollector;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.DividedBlockListManager;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayer;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayerManager;
import net.rodofire.easierworldcreator.shape.block.layer.AbstractLayer;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import net.rodofire.easierworldcreator.util.WorldGenUtil;
import org.jetbrains.annotations.NotNull;

public class DirectionalLayer
extends AbstractLayer {
    DirectionalLayer(BlockLayerManager blockLayer, class_243 center, class_2382 direction) {
        super(blockLayer, center, direction);
    }

    @Override
    public BlockListManager get(Map<class_1923, LongOpenHashSet> posMap) {
        BlockListManager manager = new BlockListManager();
        int[] depth = this.initDepth();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(Runtime.getRuntime().availableProcessors() / 2, posMap.size()));
        double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
        this.directionVector = this.directionVector.method_1029();
        for (Map.Entry<class_1923, LongOpenHashSet> entry : posMap.entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                BlockListManager threadedManager = new BlockListManager();
                Object object = ((LongOpenHashSet)entry.getValue()).iterator();
                while (object.hasNext()) {
                    long po = (Long)object.next();
                    double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, LongPosHelper.decodeBlockPos(po).method_46558()) / distanceMin;
                    BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
                    threadedManager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(po)), po);
                }
                object = manager;
                synchronized (object) {
                    manager.put(threadedManager);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public void place(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
    }

    @Override
    public BlockListManager getVerified(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            for (LongOpenHashSet set : posMap.values()) {
                worldStates.collect(world1, set);
            }
            BlockListManager manager = new BlockListManager();
            int[] depth = this.initDepth();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(Runtime.getRuntime().availableProcessors() / 2, posMap.size()));
            double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
            this.directionVector = this.directionVector.method_1029();
            for (Map.Entry<class_1923, LongOpenHashSet> entry : posMap.entrySet()) {
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockListManager threadedManager = new BlockListManager();
                    Object object = ((LongOpenHashSet)entry.getValue()).iterator();
                    while (object.hasNext()) {
                        long po = (Long)object.next();
                        double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, LongPosHelper.decodeBlockPos(po).method_46558()) / distanceMin;
                        BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
                        if (!layer.getRuler().canPlace(worldStates.getState(po))) continue;
                        threadedManager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(po)), po);
                    }
                    object = manager;
                    synchronized (object) {
                        manager.put(threadedManager);
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    @Override
    public DividedBlockListManager getDivided(Map<class_1923, LongOpenHashSet> posMap) {
        DividedBlockListManager manager = new DividedBlockListManager();
        int[] depth = this.initDepth();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(Runtime.getRuntime().availableProcessors() / 2, posMap.size()));
        double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
        this.directionVector = this.directionVector.method_1029();
        for (Map.Entry<class_1923, LongOpenHashSet> entry : posMap.entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                BlockListManager threadedManager = new BlockListManager();
                Object object = ((LongOpenHashSet)entry.getValue()).iterator();
                while (object.hasNext()) {
                    long po = (Long)object.next();
                    double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, LongPosHelper.decodeBlockPos(po).method_46558()) / distanceMin;
                    BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
                    threadedManager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(po)), po);
                }
                object = manager;
                synchronized (object) {
                    manager.putWithoutVerification(threadedManager);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public DividedBlockListManager getVerifiedDivided(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            for (LongOpenHashSet set : posMap.values()) {
                worldStates.collect(world1, set);
            }
            DividedBlockListManager manager = new DividedBlockListManager();
            int[] depth = this.initDepth();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(Runtime.getRuntime().availableProcessors() / 2, posMap.size()));
            double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
            this.directionVector = this.directionVector.method_1029();
            for (Map.Entry<class_1923, LongOpenHashSet> entry : posMap.entrySet()) {
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockListManager threadedManager = new BlockListManager();
                    Object object = ((LongOpenHashSet)entry.getValue()).iterator();
                    while (object.hasNext()) {
                        long po = (Long)object.next();
                        double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, LongPosHelper.decodeBlockPos(po).method_46558()) / distanceMin;
                        BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
                        if (!layer.getRuler().canPlace(worldStates.getState(po))) continue;
                        threadedManager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(po)), po);
                    }
                    object = manager;
                    synchronized (object) {
                        manager.putWithoutVerification(threadedManager);
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    @Override
    public <T extends Collection<class_2338>> BlockListManager get(T posList) {
        BlockListManager manager = new BlockListManager();
        int[] depth = this.initDepth();
        double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
        this.directionVector = this.directionVector.method_1029();
        for (class_2338 pos : posList) {
            double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, pos.method_46558()) / distanceMin;
            BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
            manager.put(layer.getPlacer().get(layer.getBlockStates(), pos), pos);
        }
        return manager;
    }

    @Override
    public <T extends Collection<class_2338>> void place(class_5281 world, T posList) {
    }

    @Override
    public <T extends Collection<class_2338>> BlockListManager getVerified(class_5281 world, T posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            BlockListManager manager = new BlockListManager();
            int[] depth = this.initDepth();
            double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
            this.directionVector = this.directionVector.method_1029();
            for (class_2338 pos : posList) {
                double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, pos.method_46558()) / distanceMin;
                BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
                if (!layer.getRuler().canPlace(worldStates.getState(pos))) continue;
                manager.put(layer.getPlacer().get(layer.getBlockStates(), pos), pos);
            }
            return manager;
        }
        return null;
    }

    @Override
    public <T extends Collection<class_2338>> DividedBlockListManager getDivided(T posList) {
        DividedBlockListManager manager = new DividedBlockListManager();
        int[] depth = this.initDepth();
        double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
        this.directionVector = this.directionVector.method_1029();
        for (class_2338 pos : posList) {
            double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, pos.method_46558()) / distanceMin;
            BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
            manager.put(layer.getPlacer().get(layer.getBlockStates(), pos), pos);
        }
        return manager;
    }

    @Override
    public <T extends Collection<class_2338>> DividedBlockListManager getVerifiedDivided(class_5281 world, T posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            DividedBlockListManager manager = new DividedBlockListManager();
            int[] depth = this.initDepth();
            double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
            this.directionVector = this.directionVector.method_1029();
            for (class_2338 pos : posList) {
                double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, pos.method_46558()) / distanceMin;
                BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
                if (!layer.getRuler().canPlace(worldStates.getState(pos))) continue;
                manager.put(layer.getPlacer().get(layer.getBlockStates(), pos), pos);
            }
            return manager;
        }
        return null;
    }

    @Override
    public <U extends AbstractLongCollection> BlockListManager get(U posList) {
        BlockListManager manager = new BlockListManager();
        int[] depth = this.initDepth();
        double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
        this.directionVector = this.directionVector.method_1029();
        LongIterator longIterator = posList.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, LongPosHelper.decodeBlockPos(pos).method_46558()) / distanceMin;
            BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
            manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos);
        }
        return manager;
    }

    @Override
    public <U extends AbstractLongCollection> void place(class_5281 world, U posList) {
    }

    @Override
    public <U extends AbstractLongCollection> BlockListManager getVerified(class_5281 world, U posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            BlockListManager manager = new BlockListManager();
            int[] depth = this.initDepth();
            double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
            this.directionVector = this.directionVector.method_1029();
            LongIterator longIterator = posList.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, LongPosHelper.decodeBlockPos(pos).method_46558()) / distanceMin;
                BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
                if (!layer.getRuler().canPlace(worldStates.getState(pos))) continue;
                manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos);
            }
            return manager;
        }
        return null;
    }

    @Override
    public <U extends AbstractLongCollection> DividedBlockListManager getDivided(U posList) {
        DividedBlockListManager manager = new DividedBlockListManager();
        int[] depth = this.initDepth();
        double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
        this.directionVector = this.directionVector.method_1029();
        LongIterator longIterator = posList.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, LongPosHelper.decodeBlockPos(pos).method_46558()) / distanceMin;
            BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
            manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos);
        }
        return manager;
    }

    @Override
    public <U extends AbstractLongCollection> DividedBlockListManager getVerifiedDivided(class_5281 world, U posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            DividedBlockListManager manager = new DividedBlockListManager();
            int[] depth = this.initDepth();
            double distanceMin = WorldGenUtil.getExactDistance(this.directionVector) / WorldGenUtil.getSquared(this.directionVector);
            this.directionVector = this.directionVector.method_1029();
            LongIterator longIterator = posList.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                double b = WorldGenUtil.getDistanceFromPointToPlane(this.directionVector, this.centerPos, LongPosHelper.decodeBlockPos(pos).method_46558()) / distanceMin;
                BlockLayer layer = this.blockLayer.get(this.binarySearch(depth, b));
                if (!layer.getRuler().canPlace(worldStates.getState(pos))) continue;
                manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos);
            }
            return manager;
        }
        return null;
    }

    private int @NotNull [] initDepth() {
        int[] depth = new int[this.blockLayer.size()];
        depth[0] = this.blockLayer.get(0).getDepth();
        for (int i = 1; i < this.blockLayer.size(); ++i) {
            depth[i] = this.blockLayer.get(i).getDepth() + depth[i - 1];
        }
        return depth;
    }

    private int binarySearch(int[] depth, double distance) {
        int left = 0;
        int right = depth.length - 1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            double diff = Math.abs((double)depth[mid] - distance);
            if (diff < 1.0E-6) {
                return mid;
            }
            if ((double)depth[mid] < distance) {
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        return left;
    }
}

