/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.layer;

import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.DividedBlockListManager;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayer;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayerManager;
import net.rodofire.easierworldcreator.shape.block.layer.DirectionalLayer;
import net.rodofire.easierworldcreator.shape.block.layer.InnerCylindricalLayer;
import net.rodofire.easierworldcreator.shape.block.layer.InnerRadialLayer;
import net.rodofire.easierworldcreator.shape.block.layer.Layer;
import net.rodofire.easierworldcreator.shape.block.layer.OuterCylindricalLayer;
import net.rodofire.easierworldcreator.shape.block.layer.OuterRadialLayer;
import net.rodofire.easierworldcreator.shape.block.layer.SurfaceLayer;
import net.rodofire.easierworldcreator.util.LongPosHelper;

public class LayerManager
implements Layer {
    Type layerType;
    private final BlockLayerManager blockLayerManager;
    protected class_243 centerPos = new class_243(0.0, 0.0, 0.0);
    protected class_2382 directionVector = new class_2382(0, 1, 0);

    public LayerManager(Type layerType, BlockLayerManager blockLayerManager) {
        this.layerType = layerType;
        this.blockLayerManager = blockLayerManager;
    }

    public LayerManager(Type layerType, BlockLayerManager blockLayerManager, class_243 centerPos) {
        this.blockLayerManager = blockLayerManager;
        this.layerType = layerType;
        this.centerPos = centerPos;
    }

    public LayerManager(Type layerType, BlockLayerManager blockLayerManager, class_243 centerPos, class_2382 directionVector) {
        this.layerType = layerType;
        this.blockLayerManager = blockLayerManager;
        this.centerPos = centerPos;
        this.directionVector = directionVector;
    }

    @Override
    public BlockListManager get(Map<class_1923, LongOpenHashSet> posMap) {
        if (this.blockLayerManager.size() == 1) {
            BlockListManager manager = new BlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posMap.forEach((chunkPos, longs) -> longs.forEach(pos -> manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos)));
            return manager;
        }
        return this.getLayer().get(posMap);
    }

    @Override
    public void place(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        if (this.blockLayerManager.size() == 1) {
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posMap.forEach((chunkPos, longs) -> longs.forEach(pos -> layer.getPlacer().place(world, layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos), layer.getRuler())));
        }
        this.getLayer().place(world, posMap);
    }

    @Override
    public BlockListManager getVerified(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        if (this.blockLayerManager.size() == 1) {
            BlockListManager manager = new BlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posMap.forEach((chunkPos, longs) -> longs.forEach(pos -> {
                if (layer.getRuler().canPlace(world.method_8320(LongPosHelper.decodeBlockPos(pos)))) {
                    manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos);
                }
            }));
            return manager;
        }
        return this.getLayer().getVerified(world, posMap);
    }

    @Override
    public DividedBlockListManager getDivided(Map<class_1923, LongOpenHashSet> posMap) {
        if (this.blockLayerManager.size() == 1) {
            DividedBlockListManager manager = new DividedBlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posMap.forEach((chunkPos, longs) -> longs.forEach(pos -> manager.putWithoutVerification(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos)));
            return manager;
        }
        return this.getLayer().getDivided(posMap);
    }

    @Override
    public DividedBlockListManager getVerifiedDivided(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        if (this.blockLayerManager.size() == 1) {
            DividedBlockListManager manager = new DividedBlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posMap.forEach((chunkPos, longs) -> longs.forEach(pos -> {
                if (layer.getRuler().canPlace(world.method_8320(LongPosHelper.decodeBlockPos(pos)))) {
                    manager.putWithoutVerification(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos);
                }
            }));
            return manager;
        }
        return this.getLayer().getVerifiedDivided(world, posMap);
    }

    @Override
    public <T extends Collection<class_2338>> BlockListManager get(T posList) {
        if (this.blockLayerManager.size() == 1) {
            BlockListManager manager = new BlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> manager.put(layer.getPlacer().get(layer.getBlockStates(), (class_2338)pos), (class_2338)pos));
            return manager;
        }
        return this.getLayer().get(posList);
    }

    @Override
    public <T extends Collection<class_2338>> void place(class_5281 world, T posList) {
        if (this.blockLayerManager.size() == 1) {
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> layer.getPlacer().place(world, layer.getBlockStates(), (class_2338)pos, layer.getRuler()));
        }
        this.getLayer().place(world, posList);
    }

    @Override
    public <T extends Collection<class_2338>> BlockListManager getVerified(class_5281 world, T posList) {
        if (this.blockLayerManager.size() == 1) {
            BlockListManager manager = new BlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> {
                if (layer.getRuler().canPlace(world.method_8320(pos))) {
                    manager.put(layer.getPlacer().get(layer.getBlockStates(), (class_2338)pos), (class_2338)pos);
                }
            });
            return manager;
        }
        return this.getLayer().getVerified(world, posList);
    }

    @Override
    public <T extends Collection<class_2338>> DividedBlockListManager getDivided(T posList) {
        if (this.blockLayerManager.size() == 1) {
            DividedBlockListManager manager = new DividedBlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> manager.put(layer.getPlacer().get(layer.getBlockStates(), (class_2338)pos), (class_2338)pos));
            return manager;
        }
        return this.getLayer().getDivided(posList);
    }

    @Override
    public <T extends Collection<class_2338>> DividedBlockListManager getVerifiedDivided(class_5281 world, T posList) {
        if (this.blockLayerManager.size() == 1) {
            DividedBlockListManager manager = new DividedBlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> {
                if (layer.getRuler().canPlace(world.method_8320(pos))) {
                    manager.put(layer.getPlacer().get(layer.getBlockStates(), (class_2338)pos), (class_2338)pos);
                }
            });
            return manager;
        }
        return this.getLayer().getVerifiedDivided(world, posList);
    }

    @Override
    public <U extends AbstractLongCollection> BlockListManager get(U posList) {
        if (this.blockLayerManager.size() == 1) {
            BlockListManager manager = new BlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos));
            return manager;
        }
        return this.getLayer().get(posList);
    }

    @Override
    public <U extends AbstractLongCollection> void place(class_5281 world, U posList) {
        if (this.blockLayerManager.size() == 1) {
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> layer.getPlacer().place(world, layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos), layer.getRuler()));
        }
        this.getLayer().place(world, posList);
    }

    @Override
    public <U extends AbstractLongCollection> BlockListManager getVerified(class_5281 world, U posList) {
        if (this.blockLayerManager.size() == 1) {
            BlockListManager manager = new BlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> {
                if (layer.getRuler().canPlace(world.method_8320(LongPosHelper.decodeBlockPos(pos)))) {
                    manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos);
                }
            });
            return manager;
        }
        return this.getLayer().getVerified(world, posList);
    }

    @Override
    public <U extends AbstractLongCollection> DividedBlockListManager getDivided(U posList) {
        if (this.blockLayerManager.size() == 1) {
            DividedBlockListManager manager = new DividedBlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos));
            return manager;
        }
        return this.getLayer().getDivided(posList);
    }

    @Override
    public <U extends AbstractLongCollection> DividedBlockListManager getVerifiedDivided(class_5281 world, U posList) {
        if (this.blockLayerManager.size() == 1) {
            DividedBlockListManager manager = new DividedBlockListManager();
            BlockLayer layer = this.blockLayerManager.getFirstLayer();
            posList.forEach(pos -> {
                if (layer.getRuler().canPlace(world.method_8320(LongPosHelper.decodeBlockPos(pos)))) {
                    manager.put(layer.getPlacer().get(layer.getBlockStates(), LongPosHelper.decodeBlockPos(pos)), pos);
                }
            });
            return manager;
        }
        return this.getLayer().getVerifiedDivided(world, posList);
    }

    @Override
    public class_243 getCenterPos() {
        return this.centerPos;
    }

    @Override
    public void setCenterPos(class_243 centerPos) {
        this.centerPos = centerPos;
    }

    @Override
    public class_243 getDirectionVector() {
        return class_243.method_24954((class_2382)this.directionVector);
    }

    @Override
    public void setDirectionVector(class_2382 directionVector) {
        this.directionVector = directionVector;
    }

    private Layer getLayer() {
        return switch (this.layerType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new SurfaceLayer(this.blockLayerManager);
            case 1 -> new InnerRadialLayer(this.blockLayerManager, this.centerPos);
            case 2 -> new OuterRadialLayer(this.blockLayerManager, this.centerPos);
            case 3 -> new InnerCylindricalLayer(this.blockLayerManager, this.centerPos, this.directionVector);
            case 4 -> new OuterCylindricalLayer(this.blockLayerManager, this.centerPos, this.directionVector);
            case 5 -> new DirectionalLayer(this.blockLayerManager, this.centerPos, this.directionVector);
        };
    }

    public static enum Type {
        SURFACE,
        INNER_RADIAL,
        OUTER_RADIAL,
        INNER_CYLINDRICAL,
        OUTER_CYLINDRICAL,
        ALONG_DIRECTION;

    }
}

