/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.layer;

import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.blockdata.StructurePlacementRuleManager;
import net.rodofire.easierworldcreator.blockdata.WorldStateCollector;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.DividedBlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.OrderedBlockListManager;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayer;
import net.rodofire.easierworldcreator.blockdata.layer.BlockLayerManager;
import net.rodofire.easierworldcreator.shape.block.layer.AbstractLayer;
import net.rodofire.easierworldcreator.shape.block.placer.LayerPlacer;
import net.rodofire.easierworldcreator.util.LongPosHelper;
import net.rodofire.easierworldcreator.util.consumer.QuadConsumer;

class SurfaceLayer
extends AbstractLayer {
    SurfaceLayer(BlockLayerManager blockLayer) {
        super(blockLayer);
    }

    @Override
    public BlockListManager get(Map<class_1923, LongOpenHashSet> posMap) {
        BlockListManager manager = new BlockListManager();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(posMap.size(), Runtime.getRuntime().availableProcessors()));
        for (Map.Entry<class_1923, LongOpenHashSet> entry : posMap.entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                BlockListManager threadedManager = new BlockListManager();
                LongSet leftPositions = (LongSet)entry.getValue();
                this.processCommonGet(leftPositions, (placer, states, ruler, pos) -> threadedManager.put(placer.get((List<class_2680>)states, LongPosHelper.decodeBlockPos(pos)), (long)pos));
                BlockListManager blockListManager = manager;
                synchronized (blockListManager) {
                    manager.put(threadedManager);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public void place(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        for (Map.Entry<class_1923, LongOpenHashSet> entry : posMap.entrySet()) {
            LongSet leftPositions = (LongSet)entry.getValue();
            for (int i = 1; i < this.blockLayer.size() && !leftPositions.isEmpty(); ++i) {
                BlockLayer layer = this.blockLayer.get(i - 1);
                int depth = layer.getDepth();
                LongOpenHashSet difference = new LongOpenHashSet();
                LayerPlacer placer = layer.getPlacer();
                List<class_2680> states = layer.getBlockStates();
                StructurePlacementRuleManager ruler = layer.getRuler();
                LongIterator longIterator = leftPositions.iterator();
                while (longIterator.hasNext()) {
                    long pos = (Long)longIterator.next();
                    if (leftPositions.contains(LongPosHelper.up(pos, depth))) continue;
                    difference.add(pos);
                    placer.place(world, states, LongPosHelper.decodeBlockPos(pos), ruler);
                }
                leftPositions.removeAll((LongCollection)difference);
            }
            if (leftPositions.isEmpty()) continue;
            List<class_2680> states = this.blockLayer.getLastLayer().getBlockStates();
            LayerPlacer placer = this.blockLayer.getLastLayer().getPlacer();
            StructurePlacementRuleManager ruler = this.blockLayer.getLastLayer().getRuler();
            LongIterator longIterator = leftPositions.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                placer.place(world, states, LongPosHelper.decodeBlockPos(pos), ruler);
            }
        }
    }

    @Override
    public BlockListManager getVerified(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            for (LongOpenHashSet set : posMap.values()) {
                worldStates.collect(world1, set);
            }
            BlockListManager manager = new BlockListManager();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(posMap.size(), Runtime.getRuntime().availableProcessors()));
            for (Map.Entry<class_1923, LongOpenHashSet> entry : posMap.entrySet()) {
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockListManager threadedManager = new BlockListManager();
                    LongSet leftPositions = (LongSet)entry.getValue();
                    this.processCommonGet(leftPositions, (placer, states, ruler, pos) -> {
                        if (ruler.canPlace(worldStates.getState((long)pos))) {
                            manager.put(placer.get((List<class_2680>)states, LongPosHelper.decodeBlockPos(pos)), (long)pos);
                        }
                    });
                    BlockListManager blockListManager = manager;
                    synchronized (blockListManager) {
                        manager.put(threadedManager);
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    @Override
    public DividedBlockListManager getDivided(Map<class_1923, LongOpenHashSet> posMap) {
        DividedBlockListManager manager = new DividedBlockListManager();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ForkJoinPool pool = new ForkJoinPool(Math.min(posMap.size(), Runtime.getRuntime().availableProcessors()));
        for (Map.Entry<class_1923, LongOpenHashSet> entry : posMap.entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                BlockListManager threadedManager = new BlockListManager();
                LongSet leftPositions = (LongSet)entry.getValue();
                this.processCommonGet(leftPositions, (placer, states, ruler, pos) -> threadedManager.put(placer.get((List<class_2680>)states, LongPosHelper.decodeBlockPos(pos)), (long)pos));
                DividedBlockListManager dividedBlockListManager = manager;
                synchronized (dividedBlockListManager) {
                    manager.putWithoutVerification((class_1923)entry.getKey(), threadedManager);
                }
            }, pool));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        pool.shutdown();
        return manager;
    }

    @Override
    public DividedBlockListManager getVerifiedDivided(class_5281 world, Map<class_1923, LongOpenHashSet> posMap) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            for (LongOpenHashSet set : posMap.values()) {
                worldStates.collect(world1, set);
            }
            DividedBlockListManager manager = new DividedBlockListManager();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Math.min(posMap.size(), Runtime.getRuntime().availableProcessors()));
            for (Map.Entry<class_1923, LongOpenHashSet> entry : posMap.entrySet()) {
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockListManager threadedManager = new BlockListManager();
                    LongSet leftPositions = (LongSet)entry.getValue();
                    this.processCommonGet(leftPositions, (placer, states, ruler, pos) -> {
                        if (ruler.canPlace(worldStates.getState((long)pos))) {
                            threadedManager.put(placer.get((List<class_2680>)states, LongPosHelper.decodeBlockPos(pos)), (long)pos);
                        }
                    });
                    DividedBlockListManager dividedBlockListManager = manager;
                    synchronized (dividedBlockListManager) {
                        manager.putWithoutVerification((class_1923)entry.getKey(), threadedManager);
                    }
                }, pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            pool.shutdown();
            return manager;
        }
        return null;
    }

    @Override
    public <T extends Collection<class_2338>> BlockListManager get(T posList) {
        BlockListManager manager = new BlockListManager();
        HashSet leftPositions = new HashSet(posList);
        for (int i = 1; i < this.blockLayer.size() && !leftPositions.isEmpty(); ++i) {
            BlockLayer layer = this.blockLayer.get(i - 1);
            int depth = layer.getDepth();
            HashSet<class_2338> difference = new HashSet<class_2338>();
            LayerPlacer placer = layer.getPlacer();
            List<class_2680> states = layer.getBlockStates();
            for (class_2338 pos : leftPositions) {
                if (leftPositions.contains(pos.method_10086(depth))) continue;
                difference.add(pos);
                manager.put(placer.get(states, pos), pos);
            }
            leftPositions.removeAll(difference);
        }
        if (!leftPositions.isEmpty()) {
            LayerPlacer placer = this.blockLayer.getLastLayer().getPlacer();
            List<class_2680> states = this.blockLayer.getLastLayer().getBlockStates();
            for (class_2338 pos : leftPositions) {
                manager.put(placer.get(states, pos), pos);
            }
        }
        return manager;
    }

    @Override
    public <T extends Collection<class_2338>> void place(class_5281 world, T posList) {
        HashSet leftPositions = new HashSet(posList);
        for (int i = 1; i < this.blockLayer.size() && !leftPositions.isEmpty(); ++i) {
            BlockLayer layer = this.blockLayer.get(i - 1);
            int depth = layer.getDepth();
            HashSet<class_2338> difference = new HashSet<class_2338>();
            LayerPlacer placer = layer.getPlacer();
            List<class_2680> states = layer.getBlockStates();
            StructurePlacementRuleManager ruler = layer.getRuler();
            for (class_2338 pos : leftPositions) {
                if (leftPositions.contains(pos.method_10086(depth))) continue;
                difference.add(pos);
                placer.place(world, states, pos, ruler);
            }
            leftPositions.removeAll(difference);
        }
        if (!leftPositions.isEmpty()) {
            LayerPlacer placer = this.blockLayer.getLastLayer().getPlacer();
            List<class_2680> states = this.blockLayer.getLastLayer().getBlockStates();
            StructurePlacementRuleManager ruler = this.blockLayer.getLastLayer().getRuler();
            for (class_2338 pos : leftPositions) {
                placer.place(world, states, pos, ruler);
            }
        }
    }

    @Override
    public <T extends Collection<class_2338>> BlockListManager getVerified(class_5281 world, T posList) {
        OrderedBlockListManager worldStates = new OrderedBlockListManager();
        for (class_2338 pos : posList) {
            worldStates.put(world.method_8320(pos), pos);
        }
        BlockListManager manager = new BlockListManager();
        HashSet leftPositions = new HashSet(posList);
        for (int i = 1; i < this.blockLayer.size() && !leftPositions.isEmpty(); ++i) {
            BlockLayer layer = this.blockLayer.get(i - 1);
            int depth = layer.getDepth();
            HashSet<class_2338> difference = new HashSet<class_2338>();
            LayerPlacer placer = layer.getPlacer();
            List<class_2680> states = layer.getBlockStates();
            for (class_2338 pos : leftPositions) {
                if (leftPositions.contains(pos.method_10086(depth))) continue;
                difference.add(pos);
                manager.put(placer.get(states, pos), pos);
            }
            leftPositions.removeAll(difference);
        }
        if (!leftPositions.isEmpty()) {
            LayerPlacer placer = this.blockLayer.getLastLayer().getPlacer();
            List<class_2680> states = this.blockLayer.getLastLayer().getBlockStates();
            for (class_2338 pos : leftPositions) {
                manager.put(placer.get(states, pos), pos);
            }
        }
        return manager;
    }

    @Override
    public <T extends Collection<class_2338>> DividedBlockListManager getDivided(T posList) {
        DividedBlockListManager manager = new DividedBlockListManager();
        HashSet leftPositions = new HashSet(posList);
        for (int i = 1; i < this.blockLayer.size() && !leftPositions.isEmpty(); ++i) {
            BlockLayer layer = this.blockLayer.get(i - 1);
            int depth = layer.getDepth();
            HashSet<class_2338> difference = new HashSet<class_2338>();
            LayerPlacer placer = layer.getPlacer();
            List<class_2680> states = layer.getBlockStates();
            for (class_2338 pos : leftPositions) {
                if (leftPositions.contains(pos.method_10086(depth))) continue;
                difference.add(pos);
                manager.put(placer.get(states, pos), pos);
            }
            leftPositions.removeAll(difference);
        }
        if (!leftPositions.isEmpty()) {
            LayerPlacer placer = this.blockLayer.getLastLayer().getPlacer();
            List<class_2680> states = this.blockLayer.getLastLayer().getBlockStates();
            for (class_2338 pos : leftPositions) {
                manager.put(placer.get(states, pos), pos);
            }
        }
        return manager;
    }

    @Override
    public <T extends Collection<class_2338>> DividedBlockListManager getVerifiedDivided(class_5281 world, T posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            DividedBlockListManager manager = new DividedBlockListManager();
            HashSet leftPositions = new HashSet(posList);
            for (int i = 1; i < this.blockLayer.size() && !leftPositions.isEmpty(); ++i) {
                BlockLayer layer = this.blockLayer.get(i - 1);
                int depth = layer.getDepth();
                HashSet<class_2338> difference = new HashSet<class_2338>();
                LayerPlacer placer = layer.getPlacer();
                List<class_2680> states = layer.getBlockStates();
                StructurePlacementRuleManager ruler = layer.getRuler();
                for (class_2338 pos : leftPositions) {
                    if (leftPositions.contains(pos.method_10086(depth))) continue;
                    difference.add(pos);
                    if (!ruler.canPlace(worldStates.getState(LongPosHelper.encodeBlockPos(pos)))) continue;
                    manager.put(placer.get(states, pos), pos);
                }
                leftPositions.removeAll(difference);
            }
            if (!leftPositions.isEmpty()) {
                LayerPlacer placer = this.blockLayer.getLastLayer().getPlacer();
                List<class_2680> states = this.blockLayer.getLastLayer().getBlockStates();
                StructurePlacementRuleManager ruler = this.blockLayer.getLastLayer().getRuler();
                for (class_2338 pos : leftPositions) {
                    if (!ruler.canPlace(worldStates.getState(LongPosHelper.encodeBlockPos(pos)))) continue;
                    manager.put(placer.get(states, pos), pos);
                }
            }
            return manager;
        }
        return null;
    }

    @Override
    public <U extends AbstractLongCollection> BlockListManager get(U posList) {
        BlockListManager manager = new BlockListManager();
        LongOpenHashSet leftPositions = new LongOpenHashSet(posList);
        this.processCommonGet((LongSet)leftPositions, (placer, states, ruler, pos) -> manager.put(placer.get((List<class_2680>)states, LongPosHelper.decodeBlockPos(pos)), (long)pos));
        return manager;
    }

    @Override
    public <U extends AbstractLongCollection> void place(class_5281 world, U posList) {
        LongOpenHashSet leftPositions = new LongOpenHashSet(posList);
        for (int i = 1; i < this.blockLayer.size() && !leftPositions.isEmpty(); ++i) {
            BlockLayer layer = this.blockLayer.get(i - 1);
            int depth = layer.getDepth();
            LongOpenHashSet difference = new LongOpenHashSet();
            LayerPlacer placer = layer.getPlacer();
            List<class_2680> states = layer.getBlockStates();
            StructurePlacementRuleManager ruler = layer.getRuler();
            LongIterator longIterator = leftPositions.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                if (leftPositions.contains(LongPosHelper.up(pos, depth))) continue;
                difference.add(pos);
                placer.place(world, states, LongPosHelper.decodeBlockPos(pos), ruler);
            }
            leftPositions.removeAll((LongCollection)difference);
        }
        if (!leftPositions.isEmpty()) {
            LayerPlacer placer = this.blockLayer.getLastLayer().getPlacer();
            List<class_2680> states = this.blockLayer.getLastLayer().getBlockStates();
            StructurePlacementRuleManager ruler = this.blockLayer.getLastLayer().getRuler();
            LongIterator longIterator = leftPositions.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                placer.place(world, states, LongPosHelper.decodeBlockPos(pos), ruler);
            }
        }
    }

    @Override
    public <U extends AbstractLongCollection> BlockListManager getVerified(class_5281 world, U posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            BlockListManager manager = new BlockListManager();
            LongOpenHashSet leftPositions = new LongOpenHashSet(posList);
            this.processCommonGet((LongSet)leftPositions, (placer, states, ruler, pos) -> {
                if (ruler.canPlace(worldStates.getState((long)pos))) {
                    manager.put(placer.get((List<class_2680>)states, LongPosHelper.decodeBlockPos(pos)), (long)pos);
                }
            });
            return manager;
        }
        return null;
    }

    @Override
    public <U extends AbstractLongCollection> DividedBlockListManager getDivided(U posList) {
        DividedBlockListManager manager = new DividedBlockListManager();
        LongOpenHashSet leftPositions = new LongOpenHashSet(posList);
        this.processCommonGet((LongSet)leftPositions, (placer, states, ruler, pos) -> manager.put(placer.get((List<class_2680>)states, LongPosHelper.decodeBlockPos(pos)), (long)pos));
        return manager;
    }

    @Override
    public <U extends AbstractLongCollection> DividedBlockListManager getVerifiedDivided(class_5281 world, U posList) {
        WorldStateCollector worldStates = new WorldStateCollector();
        if (world instanceof class_3218) {
            class_3218 world1 = (class_3218)world;
            worldStates.collect(world1, posList);
            DividedBlockListManager manager = new DividedBlockListManager();
            LongOpenHashSet leftPositions = new LongOpenHashSet(posList);
            this.processCommonGet((LongSet)leftPositions, (placer, states, ruler, pos) -> {
                if (ruler.canPlace(worldStates.getState((long)pos))) {
                    manager.put(placer.get((List<class_2680>)states, LongPosHelper.decodeBlockPos(pos)), (long)pos);
                }
            });
            return manager;
        }
        return null;
    }

    private void processCommonGet(LongSet leftPositions, QuadConsumer<LayerPlacer, List<class_2680>, StructurePlacementRuleManager, Long> consumer) {
        for (int i = 0; i < this.blockLayer.size() && !leftPositions.isEmpty(); ++i) {
            BlockLayer layer = this.blockLayer.get(i);
            int depth = layer.getDepth();
            LongOpenHashSet difference = new LongOpenHashSet();
            LayerPlacer placer = layer.getPlacer();
            List<class_2680> states = layer.getBlockStates();
            StructurePlacementRuleManager ruler = layer.getRuler();
            LongIterator longIterator = leftPositions.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                if (leftPositions.contains(LongPosHelper.up(pos, depth))) continue;
                difference.add(pos);
                consumer.accept(placer, states, ruler, pos);
            }
            leftPositions.removeAll((LongCollection)difference);
        }
        if (!leftPositions.isEmpty()) {
            BlockLayer layer = this.blockLayer.getLastLayer();
            LayerPlacer placer = this.blockLayer.getLastLayer().getPlacer();
            List<class_2680> states = this.blockLayer.getLastLayer().getBlockStates();
            StructurePlacementRuleManager ruler = layer.getRuler();
            LongIterator longIterator = leftPositions.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                consumer.accept(placer, states, ruler, pos);
            }
        }
    }
}

