/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.placer;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.rodofire.easierworldcreator.blockdata.StructurePlacementRuleManager;
import net.rodofire.easierworldcreator.util.BlockPlaceUtil;
import net.rodofire.easierworldcreator.util.FastNoiseLite;

public class LayerPlacer {
    private final PlacingType type;
    FastNoiseLite noise;
    int placedBlocks = 0;

    public LayerPlacer(int placedBlocks, PlacingType type) {
        this.placedBlocks = placedBlocks;
        this.type = type;
    }

    public LayerPlacer(PlacingType type, FastNoiseLite noise) {
        this.type = type;
        this.noise = noise;
    }

    public LayerPlacer(PlacingType type) {
        this.type = type;
    }

    public boolean place(class_5281 worldAccess, List<class_2680> states, class_2338 pos) {
        return this.place(worldAccess, states, pos, null);
    }

    public boolean place(class_5281 worldAccess, class_2680[] states, class_2338 pos) {
        return this.place(worldAccess, states, pos, null);
    }

    public boolean place(class_5281 worldAccess, List<class_2680> states, class_2338 pos, StructurePlacementRuleManager ruler) {
        class_2680 state;
        if (states.size() == 1) {
            state = states.getFirst();
        } else {
            switch (this.type.ordinal()) {
                case 2: {
                    state = BlockPlaceUtil.getBlockWith2DNoise(states, pos, this.noise);
                    break;
                }
                case 3: {
                    state = BlockPlaceUtil.getBlockWith3DNoise(states, pos, this.noise);
                    break;
                }
                case 1: {
                    state = BlockPlaceUtil.getBlockWithOrder(states, this.placedBlocks);
                    this.placedBlocks = (this.placedBlocks + 1) % (states.size() - 1);
                    break;
                }
                default: {
                    state = BlockPlaceUtil.getRandomBlock(states);
                }
            }
        }
        if (ruler == null) {
            return worldAccess.method_8320(pos).method_26215() && worldAccess.method_8652(pos, state, 3);
        }
        return ruler.canPlace(state) && worldAccess.method_8652(pos, state, 3);
    }

    public boolean place(class_5281 worldAccess, class_2680[] states, class_2338 pos, StructurePlacementRuleManager ruler) {
        class_2680 state;
        if (states.length == 1) {
            state = states[0];
        } else {
            switch (this.type.ordinal()) {
                case 2: {
                    state = BlockPlaceUtil.getBlockWith2DNoise(states, pos, this.noise);
                    break;
                }
                case 3: {
                    state = BlockPlaceUtil.getBlockWith3DNoise(states, pos, this.noise);
                    break;
                }
                case 1: {
                    state = BlockPlaceUtil.getBlockWithOrder(states, this.placedBlocks);
                    this.placedBlocks = (this.placedBlocks + 1) % (states.length - 1);
                    break;
                }
                default: {
                    state = BlockPlaceUtil.getRandomBlock(states);
                }
            }
        }
        if (ruler == null) {
            return worldAccess.method_8320(pos).method_26215() && worldAccess.method_8652(pos, state, 3);
        }
        return ruler.canPlace(state) && worldAccess.method_8652(pos, state, 3);
    }

    public class_2680 get(List<class_2680> states, class_2338 pos) {
        if (states.size() == 1) {
            return states.getFirst();
        }
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BlockPlaceUtil.getRandomBlock(states);
            case 2 -> BlockPlaceUtil.getBlockWith2DNoise(states, pos, this.noise);
            case 3 -> BlockPlaceUtil.getBlockWith3DNoise(states, pos, this.noise);
            case 1 -> {
                class_2680 blockState = BlockPlaceUtil.getBlockWithOrder(states, this.placedBlocks);
                this.placedBlocks = (this.placedBlocks + 1) % (states.size() - 1);
                yield blockState;
            }
        };
    }

    public class_2680 get(class_2680[] states, class_2338 pos) {
        if (states.length == 1) {
            return states[0];
        }
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BlockPlaceUtil.getRandomBlock(states);
            case 2 -> BlockPlaceUtil.getBlockWith2DNoise(states, pos, this.noise);
            case 3 -> BlockPlaceUtil.getBlockWith3DNoise(states, pos, this.noise);
            case 1 -> {
                class_2680 blockState = BlockPlaceUtil.getBlockWithOrder(states, this.placedBlocks);
                this.placedBlocks = (this.placedBlocks + 1) % (states.length - 1);
                yield blockState;
            }
        };
    }

    public static enum PlacingType {
        RANDOM,
        ORDER,
        NOISE2D,
        NOISE3D;

    }
}

