/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.placer;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.rodofire.easierworldcreator.Ewc;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListHelper;
import net.rodofire.easierworldcreator.blockdata.blocklist.BlockListManager;
import net.rodofire.easierworldcreator.blockdata.blocklist.DividedBlockListManager;
import net.rodofire.easierworldcreator.blockdata.sorter.BlockSorter;
import net.rodofire.easierworldcreator.shape.block.layer.LayerManager;
import net.rodofire.easierworldcreator.shape.block.placer.WGShapeData;
import net.rodofire.easierworldcreator.shape.block.placer.WGShapeHandler;
import net.rodofire.easierworldcreator.shape.block.placer.animator.StructurePlaceAnimator;
import net.rodofire.easierworldcreator.util.file.LoadChunkShapeInfo;
import net.rodofire.easierworldcreator.world.chunk.ChunkPosManager;

public class ShapePlacer {
    class_5281 world;
    class_2338 center;
    private final class_2960 featureName;
    private final PlaceMoment placeMoment;
    private StructurePlaceAnimator animator;
    private WGShapeData shapeData;

    public ShapePlacer(class_5281 world, PlaceMoment placeMoment, class_2338 center) {
        this(world, placeMoment, center, class_2960.method_60654((String)("unknown_mod:custom_shape" + class_5819.method_43047().method_43055())));
    }

    public ShapePlacer(class_5281 world, PlaceMoment placeMoment, class_2338 center, class_2960 featureName) {
        this.world = world;
        this.placeMoment = placeMoment;
        this.featureName = featureName;
        this.center = center;
    }

    public ShapePlacer(class_5281 world, PlaceMoment placeMoment, WGShapeData shapeData, class_2338 center) {
        this(world, placeMoment, shapeData, center, class_2960.method_60654((String)("unknown_mod:custom_shape" + class_5819.method_43047().method_43055())));
    }

    public ShapePlacer(class_5281 world, PlaceMoment placeMoment, WGShapeData shapeData, class_2338 center, class_2960 featureName) {
        this.world = world;
        this.placeMoment = placeMoment;
        this.shapeData = shapeData;
        this.featureName = featureName;
        this.center = center;
    }

    public PlaceMoment getPlaceMoment() {
        return this.placeMoment;
    }

    public void setShapeData(WGShapeData shapeData) {
        this.shapeData = shapeData;
    }

    public void place(BlockListManager defaultManager) {
        switch (this.placeMoment.ordinal()) {
            case 0: {
                Ewc.LOGGER.error("cannot place structure during world generation using BlockListManager. Please use DividedBlockListManager.");
                IllegalStateException exception = new IllegalStateException();
                exception.fillInStackTrace();
                throw exception;
            }
            case 1: {
                if (this.animator == null) {
                    this.animator = new StructurePlaceAnimator(this.world, new BlockSorter(BlockSorter.BlockSorterType.RANDOM), StructurePlaceAnimator.AnimatorTime.CONSTANT_TICKS);
                }
                this.animator.place(defaultManager);
                break;
            }
            case 2: {
                defaultManager.placeAll(this.world);
            }
        }
    }

    public void place(Map<class_1923, LongOpenHashSet> posLit, LayerManager manager) {
        ChunkPosManager chunkPosManager = new ChunkPosManager(this.world);
        if (this.placeMoment == PlaceMoment.WORLD_GEN && chunkPosManager.isMultiChunk(posLit.keySet(), this.center)) {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
            if (!chunkPosManager.canPlaceMultiChunk(posLit.keySet(), 8)) {
                return;
            }
            if (this.shapeData == null) {
                this.shapeData = WGShapeData.ofStep(class_2893.class_2895.field_13178, this.featureName.method_12836() + "-" + this.featureName.method_12832());
            }
            WGShapeHandler.encodeInformations(this.world, posLit.keySet(), this.shapeData, chunkPosManager.getOffset());
            for (Map.Entry<class_1923, LongOpenHashSet> posSet : posLit.entrySet()) {
                futures.add(CompletableFuture.runAsync(() -> manager.get((LongOpenHashSet)posSet.getValue()).placeJson(this.world, (class_1923)posSet.getKey(), chunkPosManager.getOffset(), this.featureName.method_12836() + "-" + this.featureName.method_12832()), pool));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            this.placeWorldGenFiles();
        } else if (this.placeMoment == PlaceMoment.ANIMATED_OTHER) {
            if (this.animator == null) {
                this.animator = new StructurePlaceAnimator(this.world, new BlockSorter(BlockSorter.BlockSorterType.RANDOM), StructurePlaceAnimator.AnimatorTime.CONSTANT_TICKS);
            }
            this.animator.place(manager.get(posLit));
        } else {
            manager.get(posLit).placeAll(this.world);
        }
    }

    public void place(DividedBlockListManager manager) {
        ChunkPosManager chunkPosManager = new ChunkPosManager(this.world);
        if (this.placeMoment == PlaceMoment.WORLD_GEN && chunkPosManager.isMultiChunk(manager.getChunkPos(), this.center)) {
            if (!chunkPosManager.canPlaceMultiChunk(manager.getChunkPos(), 8)) {
                return;
            }
            if (this.shapeData == null) {
                this.shapeData = WGShapeData.ofStep(class_2893.class_2895.field_13178, this.featureName.method_12836() + "-" + this.featureName.method_12832());
            }
            WGShapeHandler.encodeInformations(this.world, manager.getChunkPos(), this.shapeData, chunkPosManager.getOffset());
            manager.placeJson(this.world, this.featureName.method_12836() + "-" + this.featureName.method_12832(), chunkPosManager.getOffset());
            this.placeWorldGenFiles();
        } else if (this.placeMoment == PlaceMoment.ANIMATED_OTHER) {
            if (this.animator == null) {
                this.animator = new StructurePlaceAnimator(this.world, new BlockSorter(BlockSorter.BlockSorterType.RANDOM), StructurePlaceAnimator.AnimatorTime.CONSTANT_TICKS);
            }
            this.animator.place(manager.getOrdered());
        } else {
            manager.placeAll(this.world);
        }
    }

    private void placeWorldGenFiles() {
        List<Path> path = LoadChunkShapeInfo.getWorldGenFiles(this.world, this.center);
        for (Path path1 : path) {
            this.world.method_36972(() -> "ewc multi-chunk feature generating: " + String.valueOf(path1.getFileName()));
            BlockListManager manager = BlockListHelper.fromJsonPath(this.world, path1);
            if (manager == null) continue;
            manager.placeAllNDelete(this.world);
        }
    }

    public static enum PlaceMoment {
        WORLD_GEN,
        ANIMATED_OTHER,
        OTHER;

    }
}

