/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.placer;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_5281;
import net.minecraft.class_6796;
import net.rodofire.easierworldcreator.shape.block.placer.WGShapeData;
import net.rodofire.easierworldcreator.shape.block.placer.WGShapePlacerManager;
import net.rodofire.easierworldcreator.util.file.EwcFolderData;

public class WGShapeHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void encodeInformations(class_5281 worldAccess, Set<class_1923> posSet, WGShapeData placer, class_1923 posOffset) {
        for (class_1923 pos : posSet) {
            class_1923 newPos = new class_1923(pos.field_9181 + posOffset.field_9181, pos.field_9180 + posOffset.field_9180);
            WGShapeHandler.encodeInformation(worldAccess, newPos, placer);
        }
    }

    public static void encodeInformation(class_5281 worldAccess, class_1923 pos, WGShapeData placer) {
        List<WGShapeData> data = WGShapeHandler.loadData(worldAccess, pos);
        data.add(new WGShapeData(placer.getName(), placer.getFeatureShift().isPresent() ? (WGShapeData.PlacementShift)((Object)placer.getFeatureShift().get().method_15441()) : null, placer.getFeatureShift().isPresent() ? (class_6796)placer.getFeatureShift().get().method_15442() : null, placer.getStep().orElse(null)));
        WGShapeHandler.saveData(worldAccess, pos, data);
    }

    public static WGShapePlacerManager decodeInformation(class_5281 worldAccess, class_1923 pos) {
        List<WGShapeData> data = WGShapeHandler.loadData(worldAccess, pos);
        if (data.isEmpty()) {
            return null;
        }
        WGShapePlacerManager manager = new WGShapePlacerManager(pos, data.size());
        for (WGShapeData shapeData : data) {
            manager.put(shapeData);
        }
        return manager;
    }

    private static List<WGShapeData> loadData(class_5281 worldAccess, class_1923 pos) {
        List list;
        Path path = EwcFolderData.getStructureReference(worldAccess, pos);
        if (path == null) {
            return new ArrayList<WGShapeData>();
        }
        File file = path.toFile();
        if (!file.exists()) {
            return new ArrayList<WGShapeData>();
        }
        FileReader reader = new FileReader(file);
        try {
            Type type = new TypeToken<List<WGShapeData>>(){}.getType();
            list = (List)GSON.fromJson((Reader)reader, type);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.fillInStackTrace();
                return new ArrayList<WGShapeData>();
            }
        }
        reader.close();
        return list;
    }

    private static void saveData(class_5281 worldAccess, class_1923 pos, List<WGShapeData> data) {
        Path path = EwcFolderData.getStructureReference(worldAccess, pos);
        File file = path.toFile();
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(data, (Appendable)writer);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }
}

