/*
 * Decompiled with CFR 0.152.
 */
package net.rodofire.easierworldcreator.shape.block.placer;

import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2893;
import net.minecraft.class_3545;
import net.minecraft.class_5281;
import net.minecraft.class_6796;
import net.rodofire.easierworldcreator.shape.block.placer.WGShapeData;
import net.rodofire.easierworldcreator.util.file.EwcFolderData;

public class WGShapePlacerManager {
    private final Map<class_6796, ShortSet> beforeFeatures = new HashMap<class_6796, ShortSet>();
    private final Map<class_6796, ShortSet> afterFeatures = new HashMap<class_6796, ShortSet>();
    private final Map<class_2893.class_2895, ShortSet> steps = new HashMap<class_2893.class_2895, ShortSet>();
    class_1923 pos;
    private final String[] references;
    private final Set<String> placed = new HashSet<String>();
    short putReferences = 0;

    public WGShapePlacerManager(class_1923 pos, int referenceSize) {
        this.references = new String[referenceSize];
        this.pos = pos;
    }

    public void put(WGShapeData placer) {
        String name;
        this.references[this.putReferences] = name = placer.getName();
        if (placer.getFeatureShift().isPresent()) {
            class_3545<class_6796, WGShapeData.PlacementShift> feature = placer.getFeatureShift().get();
            if (feature.method_15441() == WGShapeData.PlacementShift.AFTER) {
                this.afterFeatures.computeIfAbsent((class_6796)feature.method_15442(), k -> new ShortOpenHashSet()).add(this.putReferences);
            } else {
                this.beforeFeatures.computeIfAbsent((class_6796)feature.method_15442(), k -> new ShortOpenHashSet()).add(this.putReferences);
            }
        } else if (placer.getStep().isPresent()) {
            this.steps.computeIfAbsent(placer.getStep().get(), k -> new ShortOpenHashSet()).add(this.putReferences);
        }
        this.putReferences = (short)(this.putReferences + 1);
    }

    public void putAll(List<WGShapeData> placers) {
        for (WGShapeData placer : placers) {
            this.put(placer);
        }
    }

    public Path[] getToPlace(class_5281 worldAccess, class_6796 beforeFeature, class_6796 featureAfter) {
        ShortSet result;
        ShortOpenHashSet set = new ShortOpenHashSet();
        if (beforeFeature != null && (result = this.beforeFeatures.get(beforeFeature)) != null) {
            set.addAll((ShortCollection)this.beforeFeatures.get(beforeFeature));
        }
        if ((result = this.afterFeatures.get(featureAfter)) != null) {
            set.addAll((ShortCollection)this.afterFeatures.get(featureAfter));
        }
        if (set.isEmpty()) {
            return new Path[0];
        }
        return this.getPath(worldAccess, (ShortSet)set);
    }

    public Path[] getToPlace(class_5281 worldAccess, class_2893.class_2895 feature) {
        ShortSet set = this.steps.get(feature);
        if (set == null) {
            return new Path[0];
        }
        return this.getPath(worldAccess, set);
    }

    private Path[] getPath(class_5281 worldAccess, ShortSet set) {
        Path basePath = EwcFolderData.getStructureDataDir(worldAccess, this.pos);
        Path[] paths = new Path[set.size()];
        int i = 0;
        ShortIterator shortIterator = set.iterator();
        while (shortIterator.hasNext()) {
            short index = (Short)shortIterator.next();
            paths[i] = basePath.resolve(this.references[index] + ".json");
            this.placed.add(this.references[index]);
            ++i;
        }
        return paths;
    }

    public Path[] getLeft(class_5281 worldAccess) {
        Path basePath = EwcFolderData.getStructureDataDir(worldAccess, this.pos);
        HashSet<Path> paths = new HashSet<Path>();
        for (String string : this.references) {
            if (this.placed.contains(string)) continue;
            paths.add(basePath.resolve(string + ".json"));
        }
        return paths.toArray(new Path[0]);
    }
}

